/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.GuiConfig;
import mcjty.theoneprobe.gui.GuiNote;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.keys.KeyBindings;
import mcjty.theoneprobe.keys.KeyInputHandler;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientSetup {
    public static boolean ignoreNextGuiClose = false;

    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientSetup());
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
    }

    @SubscribeEvent
    public void onGuiOpen(ScreenEvent.Opening event) {
        if (ignoreNextGuiClose) {
            Screen current = Minecraft.m_91087_().f_91080_;
            if (event.getScreen() == null && (current instanceof GuiConfig || current instanceof GuiNote)) {
                ignoreNextGuiClose = false;
                event.setCanceled(true);
            }
        }
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        KeyBindings.init();
        event.register(KeyBindings.toggleVisible);
        event.register(KeyBindings.toggleLiquids);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void renderGameOverlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.TITLE_TEXT.id())) {
            return;
        }
        if ((Boolean)Config.holdKeyToMakeVisible.get() != false ? !KeyBindings.toggleVisible.m_90857_() : (Boolean)Config.isVisible.get() == false) {
            return;
        }
        if (this.hasItemInEitherHand(ModItems.CREATIVE_PROBE)) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, event.getGuiGraphics(), event.getPartialTick());
        } else {
            switch ((Integer)Config.needsProbe.get()) {
                case 0: 
                case 3: {
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getGuiGraphics(), event.getPartialTick());
                    break;
                }
                case 1: 
                case 2: {
                    if (!ModItems.hasAProbeSomewhere((Player)Minecraft.m_91087_().f_91074_)) break;
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getGuiGraphics(), event.getPartialTick());
                }
            }
        }
    }

    private ProbeMode getModeForPlayer() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)Config.extendedInMain.get()).booleanValue() && this.hasItemInMainHand(ModItems.PROBE)) {
            return ProbeMode.EXTENDED;
        }
        return player.m_6144_() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }

    private boolean hasItemInEitherHand(Item item) {
        ItemStack mainHeldItem = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHeldItem = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND);
        return mainHeldItem.m_41720_() == item || offHeldItem.m_41720_() == item;
    }

    private boolean hasItemInMainHand(Item item) {
        ItemStack mainHeldItem = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        return mainHeldItem.m_41720_() == item;
    }
}

