/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.items;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.compat.BaubleTools;
import mcjty.theoneprobe.items.CreativeProbe;
import mcjty.theoneprobe.items.Probe;
import mcjty.theoneprobe.items.ProbeNote;
import mcjty.theoneprobe.items.TopArmorMaterial;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModItems {
    public static CreativeProbe CREATIVE_PROBE;
    public static Probe PROBE;
    public static Item DIAMOND_HELMET_PROBE;
    public static Item GOLD_HELMET_PROBE;
    public static Item IRON_HELMET_PROBE;
    public static Item PROBE_GOGGLES;
    public static ProbeNote PROBE_NOTE;
    public static final String PROBETAG = "theoneprobe";
    public static final String PROBETAG_HAND = "theoneprobe_hand";

    public static void init() {
        PROBE = new Probe();
        CREATIVE_PROBE = new CreativeProbe();
        TopArmorMaterial materialDiamondHelmet = new TopArmorMaterial("diamond_helmet_probe", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11673_, 2.0f, null);
        TopArmorMaterial materialGoldHelmet = new TopArmorMaterial("gold_helmet_probe", 7, new int[]{1, 3, 5, 2}, 25, SoundEvents.f_11676_, 0.0f, null);
        TopArmorMaterial materialIronHelmet = new TopArmorMaterial("iron_helmet_probe", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11677_, 0.0f, null);
        DIAMOND_HELMET_PROBE = ModItems.makeHelmet(materialDiamondHelmet, 3, "diamond_helmet_probe");
        GOLD_HELMET_PROBE = ModItems.makeHelmet(materialGoldHelmet, 4, "gold_helmet_probe");
        IRON_HELMET_PROBE = ModItems.makeHelmet(materialIronHelmet, 2, "iron_helmet_probe");
        PROBE_NOTE = new ProbeNote();
        if (TheOneProbe.baubles) {
            PROBE_GOGGLES = BaubleTools.initProbeGoggle();
        }
    }

    private static Item makeHelmet(TopArmorMaterial material, int renderIndex, String name) {
        ArmorItem item = new ArmorItem(material, ArmorItem.Type.HELMET, new Item.Properties()){};
        return item;
    }

    public static boolean isProbeInHand(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() == PROBE || stack.m_41720_() == CREATIVE_PROBE) {
            return true;
        }
        if (stack.m_41783_() == null) {
            return false;
        }
        return stack.m_41783_().m_128441_(PROBETAG_HAND);
    }

    private static boolean isProbeHelmet(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41783_() == null) {
            return false;
        }
        return stack.m_41783_().m_128441_(PROBETAG);
    }

    public static boolean hasAProbeSomewhere(Player player) {
        return ModItems.hasProbeInHand(player, InteractionHand.MAIN_HAND) || ModItems.hasProbeInHand(player, InteractionHand.OFF_HAND) || ModItems.hasProbeInHelmet(player) || ModItems.hasProbeInBauble(player);
    }

    private static boolean hasProbeInHand(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        return ModItems.isProbeInHand(item);
    }

    private static boolean hasProbeInHelmet(Player player) {
        ItemStack helmet = player.m_150109_().m_8020_(39);
        return ModItems.isProbeHelmet(helmet);
    }

    private static boolean hasProbeInBauble(Player player) {
        if (TheOneProbe.baubles) {
            return BaubleTools.hasProbeGoggle(player);
        }
        return false;
    }
}

