/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ComponentTransplace
extends SpellEffect {
    public ComponentTransplace(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (source.getCaster() == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (target.isLivingEntity() && source.getCaster().m_9236_().m_46472_().equals(target.getLivingEntity().m_9236_().m_46472_())) {
            EntityTeleportEvent tpEventTarget;
            Vec3 casterPos = source.getOrigin();
            Vec3 targetPos = target.getLivingEntity().m_20182_();
            EntityTeleportEvent tpEventCaster = new EntityTeleportEvent((Entity)source.getCaster(), targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            if (!MinecraftForge.EVENT_BUS.post((Event)tpEventCaster)) {
                source.getCaster().m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)(tpEventTarget = new EntityTeleportEvent((Entity)target.getLivingEntity(), casterPos.f_82479_, casterPos.f_82480_, casterPos.f_82481_)))) {
                target.getLivingEntity().m_6021_(casterPos.f_82479_, casterPos.f_82480_, casterPos.f_82481_);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ENDER;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age < 5) {
            Vec3 rotationOffset = new Vec3(1.5, 0.0, 0.0);
            BlockPos bp = BlockPos.m_274446_((Position)impact_position).m_7918_(0, -1, 0);
            for (int angle = 0; angle < 360; angle += 30) {
                Vec3 point = rotationOffset.m_82524_((float)((double)angle * Math.PI / 180.0));
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)caster), (double)((float)bp.m_123341_() + 0.5f) + point.f_82479_, (double)bp.m_123342_(), (double)((float)bp.m_123343_() + 0.5f) + point.f_82481_, (double)((float)bp.m_123341_() + 0.5f), (double)(bp.m_123342_() + 2), (double)((float)bp.m_123343_() + 0.5f));
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }
}

