/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.items.IPhylacteryItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualBlockPos;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.sound.SFX;
import com.mna.entities.utility.PresentItem;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemCrystalPhylactery;
import com.mna.items.sorcery.ItemEntityCrystal;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RitualEffectShadowSoul
extends RitualEffect {
    public RitualEffectShadowSoul(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        NonNullList<RitualBlockPos> positions = context.getAllPositions();
        for (RitualBlockPos pos : positions) {
            if (pos == null) continue;
            BlockPos cur = pos.getBlockPos();
            context.getLevel().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SOUL.get())).setGravity(0.0f).setPhysics(true), (double)cur.m_123341_() + Math.random(), (double)cur.m_123342_() + 0.1, (double)cur.m_123343_() + Math.random(), 0.0, 0.05, 0.0);
        }
        return true;
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return SFX.Loops.SHADOW_COPY;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack phylacteryStack = ItemStack.f_41583_;
        ItemStack crystalStack = ItemStack.f_41583_;
        List<ItemStack> collected = context.getCollectedReagents();
        for (int i = 0; i < collected.size(); ++i) {
            ItemStack stack = collected.get(i);
            if (stack.m_41720_() instanceof IPhylacteryItem) {
                phylacteryStack = stack;
                continue;
            }
            if (stack.m_41720_() != ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get() || ItemEntityCrystal.getEntityType(stack) == null) continue;
            crystalStack = stack;
        }
        if (phylacteryStack.m_41619_() || crystalStack.m_41619_()) {
            this.ejectItems(context);
            return false;
        }
        try {
            EntityType<?> crystalType = ItemEntityCrystal.getEntityType(crystalStack);
            EntityType<? extends Mob> existing = ((IPhylacteryItem)phylacteryStack.m_41720_()).getContainedEntity(phylacteryStack);
            if (existing != null && existing != crystalType) {
                this.ejectItems(context);
                return false;
            }
            if (existing == null) {
                ItemCrystalPhylactery.setEntityType(phylacteryStack, crystalType, context.getLevel());
            }
            ((IPhylacteryItem)phylacteryStack.m_41720_()).fill(phylacteryStack, crystalType, (float)((IPhylacteryItem)phylacteryStack.m_41720_()).getMaximumFill() * 0.25f, context.getLevel());
            Vec3 center = Vec3.m_82512_((Vec3i)context.getCenter());
            PresentItem epi = new PresentItem(context.getLevel(), center.f_82479_, center.f_82480_, center.f_82481_, phylacteryStack);
            context.getLevel().m_7967_((Entity)epi);
            Entity e = ItemEntityCrystal.restoreEntity(context.getLevel(), crystalStack);
            e.m_146884_(Vec3.m_82512_((Vec3i)context.getCenter()));
            context.getLevel().m_7967_(e);
        }
        catch (Throwable t) {
            this.ejectItems(context);
        }
        return false;
    }

    private void ejectItems(IRitualContext context) {
        Vec3 center = Vec3.m_82512_((Vec3i)context.getCenter());
        context.getCollectedReagents().forEach(is -> {
            ItemEntity ie = new ItemEntity(context.getLevel(), center.f_82479_, center.f_82480_, center.f_82481_, is, (double)-0.2f + Math.random() * (double)0.4f, (double)0.2f, (double)-0.2f + Math.random() * (double)0.4f);
            context.getLevel().m_7967_((Entity)ie);
        });
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

