/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.blocks.BlockInit;
import com.mna.blocks.artifice.CoffinBlock;
import com.mna.blocks.tileentities.CoffinTile;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.boss.WitherLich;
import com.mna.factions.Factions;
import com.mna.tools.StructureUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RitualEffectColdDark
extends RitualEffect {
    public RitualEffectColdDark(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public Component canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return Component.m_237115_((String)"Progression could not be found...this is a problem.");
        }
        WitherLich tempBoss = new WitherLich(context.getLevel(), Vec3.m_82539_((Vec3i)context.getCenter()));
        if (!StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), context.getCenter(), tempBoss.getArenaStructureID(), tempBoss.getArenaStructureSegment())) {
            if (progression.getTierProgress(context.getLevel()) < 1.0f) {
                return Component.m_237115_((String)"ritual.mna.progression.not_ready");
            }
            if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Factions.UNDEAD) {
                return Component.m_237115_((String)"event.mna.faction_ritual_failed");
            }
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getCaster() == null || context.getCaster().m_20148_() == null) {
            return false;
        }
        BlockPos pos = context.getCenter();
        WitherLich lich = new WitherLich(context.getLevel());
        if (StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), context.getCenter(), lich.getArenaStructureID(), lich.getArenaStructureSegment())) {
            lich.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
            context.getLevel().m_7967_((Entity)lich);
            return true;
        }
        BlockPos top_pos = context.getCenter();
        BlockPos other_pos = null;
        Direction coffin_facing = null;
        if (context.getLevel().m_46859_(top_pos.m_122012_())) {
            other_pos = top_pos.m_122012_();
            coffin_facing = Direction.NORTH;
        } else if (context.getLevel().m_46859_(top_pos.m_122029_())) {
            other_pos = top_pos.m_122029_();
            coffin_facing = Direction.EAST;
        } else if (context.getLevel().m_46859_(top_pos.m_122019_())) {
            other_pos = top_pos.m_122019_();
            coffin_facing = Direction.SOUTH;
        } else if (context.getLevel().m_46859_(top_pos.m_122024_())) {
            other_pos = top_pos.m_122024_();
            coffin_facing = Direction.WEST;
        } else {
            other_pos = top_pos.m_122012_();
            coffin_facing = Direction.NORTH;
        }
        if (other_pos == null || coffin_facing == null) {
            return false;
        }
        context.getLevel().m_46597_(top_pos, (BlockState)((BlockState)((CoffinBlock)((Object)BlockInit.COFFIN.get())).m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)BedBlock.f_54117_, (Comparable)coffin_facing));
        context.getLevel().m_46597_(other_pos, (BlockState)((BlockState)((CoffinBlock)((Object)BlockInit.COFFIN.get())).m_49966_().m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)).m_61124_((Property)BedBlock.f_54117_, (Comparable)coffin_facing));
        BlockEntity te = context.getLevel().m_7702_(other_pos);
        if (te == null || !(te instanceof CoffinTile)) {
            return false;
        }
        ((CoffinTile)te).setRitualPlayer(context.getCaster());
        context.getCaster().m_213846_((Component)Component.m_237115_((String)"event.mna.cold_dark_prompt").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 100;
    }
}

