/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.manaweaving;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.recipes.AMRecipeBaseSerializer;
import com.mna.recipes.manaweaving.TransmutationRecipe;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TransmutationRecipeSerializer
extends AMRecipeBaseSerializer<TransmutationRecipe> {
    public static HashMap<ResourceLocation, TransmutationRecipe> ALL_RECIPES = new HashMap();

    @Override
    public TransmutationRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        TransmutationRecipe recipe = new TransmutationRecipe(recipeId);
        recipe.parseJSON(json);
        ALL_RECIPES.put(recipeId, recipe);
        return recipe;
    }

    @Override
    public TransmutationRecipe readExtra(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            TransmutationRecipe recipe = new TransmutationRecipe(recipeId);
            recipe.setTargetBlock(buffer.m_130281_());
            if (buffer.readBoolean()) {
                recipe.setReplaceBlock(buffer.m_130281_());
            }
            if (buffer.readBoolean()) {
                recipe.setLootTable(buffer.m_130281_());
            }
            if (buffer.readBoolean()) {
                recipe.setRepresentationItem(buffer.m_130281_());
            }
            ALL_RECIPES.put(recipeId, recipe);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading transmutation recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(FriendlyByteBuf buffer, TransmutationRecipe recipe) {
        try {
            buffer.m_130085_(recipe.getTargetBlock());
            if (recipe.hasReplaceBlock()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(recipe.getReplaceBlock());
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.hasLootTable()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(recipe.getLootTable());
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.hasRepresentationItem()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(recipe.getRepresentationItem());
            } else {
                buffer.writeBoolean(false);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing transmutation recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

