/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.items.sorcery.ItemSpell;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.network.messages.BaseServerMessage;
import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class SpellAdjustmentsMessage
extends BaseServerMessage {
    private CompoundTag spellValues;
    private InteractionHand hand;

    public SpellAdjustmentsMessage(CompoundTag spellValues, InteractionHand hand) {
        this.spellValues = spellValues;
        this.hand = hand;
        this.messageIsValid = true;
    }

    public SpellAdjustmentsMessage() {
        this.messageIsValid = false;
    }

    public CompoundTag getData() {
        return this.spellValues;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static SpellAdjustmentsMessage decode(FriendlyByteBuf buf) {
        SpellAdjustmentsMessage msg = new SpellAdjustmentsMessage();
        try {
            msg.spellValues = buf.m_130260_();
            msg.hand = InteractionHand.values()[buf.readInt()];
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SpellAdjustmentsMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpellAdjustmentsMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.getData());
        buf.writeInt(msg.hand.ordinal());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        SpellRecipe recipe = SpellRecipe.fromNBT(this.getData());
        ItemStack heldStack = player.m_21120_(this.getHand());
        if (recipe.isValid() && heldStack.m_41720_() instanceof ItemSpell && !(heldStack.m_41720_() instanceof ItemSpellBook)) {
            recipe.writeToNBT(heldStack.m_41784_());
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Error setting spell data values; serverside validation failed!").m_130940_(ChatFormatting.RED));
        }
    }
}

