/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class RequestWellspringPowerNetworkSyncMessage
extends BaseServerMessage {
    private boolean nearbyNodes;

    public RequestWellspringPowerNetworkSyncMessage(boolean nearbyNodes) {
        this.nearbyNodes = nearbyNodes;
        this.messageIsValid = true;
    }

    public RequestWellspringPowerNetworkSyncMessage() {
        this.messageIsValid = false;
    }

    public static final RequestWellspringPowerNetworkSyncMessage decode(FriendlyByteBuf buf) {
        RequestWellspringPowerNetworkSyncMessage msg = new RequestWellspringPowerNetworkSyncMessage();
        try {
            msg.nearbyNodes = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RequestWellspringPowerNetworkSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public boolean getNearbyNodes() {
        return this.nearbyNodes;
    }

    public static final void encode(RequestWellspringPowerNetworkSyncMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.getNearbyNodes());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage(world, player, true);
        if (this.getNearbyNodes()) {
            ServerMessageDispatcher.sendWellspringSyncMessage(world, player, 512);
        }
    }
}

