/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.items.base.IRadialInventorySelect;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RadialInventorySlotChangeMessage
extends BaseServerMessage {
    private int slot;
    private boolean offhand;

    public RadialInventorySlotChangeMessage(int slot, boolean offhand) {
        this.slot = slot;
        this.offhand = offhand;
        this.messageIsValid = true;
    }

    public RadialInventorySlotChangeMessage() {
        this.messageIsValid = false;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isOffhand() {
        return this.offhand;
    }

    public static RadialInventorySlotChangeMessage decode(FriendlyByteBuf buf) {
        RadialInventorySlotChangeMessage msg = new RadialInventorySlotChangeMessage();
        try {
            msg.slot = buf.readInt();
            msg.offhand = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RadialInventorySlotChangeMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RadialInventorySlotChangeMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getSlot());
        buf.writeBoolean(msg.isOffhand());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ItemStack stack = this.isOffhand() ? player.m_21206_() : player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof IRadialInventorySelect) {
            IRadialInventorySelect radial = (IRadialInventorySelect)item;
            radial.setSlot((Player)player, this.isOffhand() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, this.getSlot(), this.isOffhand(), false);
        }
    }
}

