/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseClientMessage;
import com.mna.recipes.multiblock.MultiblockDefinition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StructureSyncMessage
extends BaseClientMessage {
    private CompoundTag _data;
    private ResourceLocation structureID;

    private StructureSyncMessage(CompoundTag data, ResourceLocation structureID) {
        this._data = data;
        this.structureID = structureID;
        this.messageIsValid = true;
    }

    private StructureSyncMessage() {
        this.messageIsValid = false;
    }

    public static StructureSyncMessage decode(FriendlyByteBuf buf) {
        StructureSyncMessage msg = new StructureSyncMessage();
        try {
            msg._data = buf.m_130260_();
            msg.structureID = buf.m_130281_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading StructureSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(StructureSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg._data);
        buf.m_130085_(msg.structureID);
    }

    public static StructureSyncMessage fromMultiblock(MultiblockDefinition multiblock, ServerLevel world) {
        return new StructureSyncMessage(multiblock.serializeCoreBlocks(world), multiblock.m_6423_());
    }

    @Override
    public void Handle(Level world, Player player) {
        world.m_7465_().m_44043_(this.structureID).ifPresent(r -> {
            if (r instanceof MultiblockDefinition) {
                MultiblockDefinition mbd = (MultiblockDefinition)r;
                mbd.deserializeCoreBlocks(this._data);
            }
        });
    }
}

