/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PossessionMessage
extends BaseClientMessage {
    int entityID;

    public PossessionMessage(int entityID) {
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    public PossessionMessage() {
        this.messageIsValid = false;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static PossessionMessage decode(FriendlyByteBuf buf) {
        PossessionMessage msg = new PossessionMessage();
        try {
            msg.entityID = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading getEntityID: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(PossessionMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
    }

    @Override
    public void Handle(Level world, Player player) {
        Entity e = world.m_6815_(this.getEntityID());
        if (e != null) {
            ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
        }
    }
}

