/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.blocks.tileentities.ParticleEmitterTile;
import com.mna.capabilities.particles.ParticleAura;
import com.mna.capabilities.particles.ParticleAuraProvider;
import com.mna.network.messages.BaseClientMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public class AuraSyncMessageToClient
extends BaseClientMessage {
    private int entityID;
    private CompoundTag tag;
    private BlockPos pos;

    private AuraSyncMessageToClient() {
        this.messageIsValid = false;
    }

    private AuraSyncMessageToClient(int entityID, CompoundTag tag) {
        this();
        this.entityID = entityID;
        this.tag = tag;
        this.messageIsValid = true;
    }

    public AuraSyncMessageToClient(BlockPos pos, CompoundTag tag) {
        this();
        this.tag = tag;
        this.pos = pos;
        this.messageIsValid = true;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    @Nullable
    public BlockPos getBlockPos() {
        return this.pos;
    }

    public boolean isBlock() {
        return this.pos != null;
    }

    public static AuraSyncMessageToClient decode(FriendlyByteBuf buf) {
        AuraSyncMessageToClient msg = new AuraSyncMessageToClient();
        try {
            if (buf.readBoolean()) {
                msg.entityID = buf.readInt();
            } else {
                msg.pos = BlockPos.m_122022_((long)buf.readLong());
            }
            msg.tag = buf.m_130261_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MAPFXSyncRequestMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(AuraSyncMessageToClient msg, FriendlyByteBuf buf) {
        if (msg.pos == null) {
            buf.writeBoolean(true);
            buf.writeInt(msg.getEntityID());
        } else {
            buf.writeBoolean(false);
            buf.writeLong(msg.pos.m_121878_());
        }
        buf.m_130079_(msg.tag);
    }

    public static AuraSyncMessageToClient fromPlayer(Player player) {
        LazyOptional aura = player.getCapability(ParticleAuraProvider.AURA);
        CompoundTag tag = aura.isPresent() ? ((ParticleAura)aura.resolve().get()).save() : new CompoundTag();
        AuraSyncMessageToClient msg = new AuraSyncMessageToClient(player.m_19879_(), tag);
        return msg;
    }

    public static AuraSyncMessageToClient fromTile(ParticleEmitterTile tile) {
        AuraSyncMessageToClient msg = new AuraSyncMessageToClient(tile.m_58899_(), tile.getData().getTag());
        return msg;
    }

    @Override
    public void Handle(Level world, Player player) {
        if (this.isBlock() && world.m_46749_(this.getBlockPos())) {
            BlockEntity be = world.m_7702_(this.getBlockPos());
            if (be != null && be instanceof ParticleEmitterTile) {
                ParticleEmitterTile peTile = (ParticleEmitterTile)be;
                peTile.setData(this.getTag());
            }
        } else {
            Entity entity = world.m_6815_(this.getEntityID());
            if (entity != null && entity instanceof Player) {
                Player resolvedPlayer = (Player)entity;
                resolvedPlayer.getCapability(ParticleAuraProvider.AURA).ifPresent(a -> a.load(this.getTag()));
            }
        }
    }
}

