/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.villager_lootables;

import com.mna.api.tools.MATags;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LootPouchItem
extends Item {
    public final ResourceLocation POUCH_ITEMS;
    private final Consumer<ItemStack> randomizer;

    public LootPouchItem(ResourceLocation itemTag, Consumer<ItemStack> randomizerFunction) {
        super(new Item.Properties());
        this.POUCH_ITEMS = itemTag;
        this.randomizer = randomizerFunction;
    }

    public LootPouchItem(ResourceLocation itemTag) {
        this(itemTag, null);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_9236_().m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        this.addStackToPlayer(player, new ItemStack((ItemLike)Items.f_42454_));
        this.addStackToPlayer(player, new ItemStack((ItemLike)Items.f_42401_));
        int numTypes = 2;
        switch ((int)(Math.random() * 10.0)) {
            case 8: 
            case 9: {
                numTypes = 3;
                break;
            }
            case 6: 
            case 7: {
                numTypes = 1;
            }
        }
        for (int i = 0; i < numTypes; ++i) {
            this.addStackToPlayer(player, this.getRandomLootStack());
        }
        stack.m_41774_(1);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private ItemStack getRandomLootStack() {
        List<Item> items = MATags.getItemTagContents(this.POUCH_ITEMS);
        if (items.size() == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)items.get((int)(Math.random() * (double)items.size())));
        if (this.randomizer != null) {
            this.randomizer.accept(stack);
        }
        return stack;
    }

    private void addStackToPlayer(Player player, ItemStack stack) {
        if (!player.m_36356_(stack)) {
            player.m_36176_(stack, true);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        list.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }
}

