/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.ManaAndArtifice;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.gui.containers.providers.NamedSpellRecipe;
import com.mna.items.base.IItemWithGui;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSpellRecipe
extends Item
implements IItemWithGui<ItemSpellRecipe>,
ICanContainSpell {
    public ItemSpellRecipe(Item.Properties properties) {
        super(properties);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedSpellRecipe();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldStack = playerIn.m_21120_(handIn);
        if (heldStack.m_41720_() == this && this.openGuiIfModifierPressed(heldStack, playerIn, worldIn)) {
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        return InteractionResultHolder.m_19100_((Object)heldStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Component> flavorText = this.getFlavorText(stack);
        if (flavorText != null) {
            tooltip.addAll(flavorText);
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, player));
        recipe.addItemTooltip(stack, worldIn, tooltip, player);
        IItemWithGui.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean requiresModifierKey() {
        return false;
    }

    @Nullable
    protected ArrayList<Component> getFlavorText(ItemStack stack) {
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, null));
        if (recipe.isValid() && recipe.getComponents().stream().noneMatch(c -> c.getPart() == Components.LMNOP)) {
            return this.getTranslatedDisplayName(recipe);
        }
        return super.m_7626_(stack);
    }

    protected Component getTranslatedDisplayName(SpellRecipe recipe) {
        StringBuilder sb = new StringBuilder();
        recipe.iterateComponents(c -> {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(Component.m_237115_((String)((SpellEffect)c.getPart()).getRegistryName().toString()).getString());
        });
        return Component.m_237110_((String)"item.mna.spell.recipe_display_name", (Object[])new Object[]{Component.m_237115_((String)((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString()).getString(), sb.toString()});
    }

    public boolean m_41468_() {
        return true;
    }

    public CompoundTag getSpellCompound(ItemStack stack, @Nullable Player player) {
        return stack.m_41783_();
    }
}

