/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.items.IShowHud;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.SpellCastingResultCode;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.effects.EffectInit;
import com.mna.gui.containers.providers.NamedSpellAdjust;
import com.mna.gui.containers.providers.NamedSpellCustomization;
import com.mna.items.ItemInit;
import com.mna.items.renderers.ItemSpellRenderer;
import com.mna.items.sorcery.ItemSpellRecipe;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.network.NetworkHooks;

public class ItemSpell
extends ItemSpellRecipe
implements IShowHud {
    public ItemSpell() {
        this(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public ItemSpell(Item.Properties properties) {
        super(properties);
    }

    public static final void castSpellOnChannelTick(ItemStack stack, Player player, int itemInUseCount, BiPredicate<Player, ItemStack> consumeChanneledMana) {
        if (itemInUseCount == 0 || !consumeChanneledMana.test(player, stack) || player.m_21023_((MobEffect)EffectInit.SILENCE.get())) {
            player.m_21253_();
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_21253_();
        }
        return stack;
    }

    public static final InteractionResultHolder<ItemStack> castSpellOnUse(ItemStack spellStack, Level world, Player player, InteractionHand hand, Function<ItemStack, Boolean> consumeMana) {
        if (!SpellRecipe.stackContainsSpell(spellStack)) {
            return InteractionResultHolder.m_19098_((Object)spellStack);
        }
        player.m_6674_(hand);
        SpellCastingResult result = SpellCaster.PlayerCast(spellStack, player, hand, player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0), player.m_20154_(), world, consumeMana.apply(spellStack), false);
        if (result.getCode() == SpellCastingResultCode.CHANNEL) {
            player.m_6672_(hand);
            if (consumeMana.apply(spellStack).booleanValue()) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MANA_STUNT.get(), spellStack.m_41779_(), 5));
            }
            return InteractionResultHolder.m_19090_((Object)spellStack);
        }
        if (result.getCode() == SpellCastingResultCode.SUCCESS) {
            ItemSpell.setCooldown(player, spellStack);
            return InteractionResultHolder.m_19090_((Object)spellStack);
        }
        ItemSpell.setCooldown(player, spellStack);
        return InteractionResultHolder.m_19090_((Object)spellStack);
    }

    public static final InteractionResult castSpellOnRightClickEntity(ItemStack spellStack, Level world, Player player, InteractionHand hand, Function<ItemStack, Boolean> consumeMana) {
        if (SpellRecipe.fromNBT(spellStack.m_41784_()).isChanneled()) {
            return InteractionResult.PASS;
        }
        if (player.m_36335_().m_41519_(spellStack.m_41720_())) {
            return InteractionResult.PASS;
        }
        return ItemSpell.castSpellOnUse(spellStack, world, player, hand, consumeMana).m_19089_();
    }

    protected boolean shouldConsumeMana(ItemStack stack) {
        return true;
    }

    protected boolean consumeChanneledMana(Player player, ItemStack stack) {
        return SpellCaster.consumeChanneledMana(player, stack);
    }

    protected static final void setCooldown(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSpellRecipe) {
            ItemSpellRecipe item = (ItemSpellRecipe)stack.m_41720_();
            SpellRecipe recipe = SpellRecipe.fromNBT(item.getSpellCompound(stack, player));
            SpellCaster.setCooldown(stack, player, recipe.getCooldown((LivingEntity)player));
        }
    }

    public static ItemStack createWTFBoomStack() {
        ItemStack spellStack = new ItemStack((ItemLike)ItemInit.SPELL.get());
        spellStack.m_41714_((Component)Component.m_237113_((String)"L").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)"M").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"N").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"O").m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)"P").m_130940_(ChatFormatting.LIGHT_PURPLE)));
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(Shapes.SELF);
        recipe.addComponent(Components.LMNOP);
        recipe.writeToNBT(spellStack.m_41784_());
        ItemSpell.setCustomIcon(spellStack, 328);
        return spellStack;
    }

    @Override
    protected ArrayList<Component> getFlavorText(ItemStack stack) {
        SpellRecipe recipe;
        if (SpellRecipe.stackContainsSpell(stack) && (recipe = SpellRecipe.fromNBT(stack.m_41783_())).isValid() && recipe.getComponents().stream().anyMatch(c -> c.getPart() == Components.LMNOP) && !recipe.isMysterious()) {
            ArrayList<Component> output = new ArrayList<Component>();
            output.add((Component)Component.m_237115_((String)"mna:components/wtfboom.warning"));
            return output;
        }
        return super.getFlavorText(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new ItemSpellRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == ItemInit.SPELL.get() && ItemSpell.getCustomIcon(itemstack) == -1) {
            if (!world.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new NamedSpellCustomization());
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        if (!SpellRecipe.isMysterious(itemstack) && this.openGuiIfModifierPressed(player.m_21120_(hand), player, world)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return ItemSpell.castSpellOnUse(itemstack, world, player, hand, this::shouldConsumeMana);
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedSpellAdjust();
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        return ItemSpell.castSpellOnRightClickEntity(stack, playerIn.m_9236_(), playerIn, hand, this::shouldConsumeMana);
    }

    public void m_5929_(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            ItemSpell.castSpellOnChannelTick(stack, (Player)player, count, this::consumeChanneledMana);
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, player));
            ItemSpell.setCooldown(player, stack);
            if (this.shouldConsumeMana(stack)) {
                if (entityLiving.m_21023_((MobEffect)EffectInit.MANA_STUNT.get()) && entityLiving.m_21124_((MobEffect)EffectInit.MANA_STUNT.get()).m_19564_() == 5) {
                    entityLiving.m_21195_((MobEffect)EffectInit.MANA_STUNT.get());
                }
                SpellCaster.AddAffinityAndMagicXP(recipe, player, recipe.getMaxChannelTime() - timeLeft);
            }
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.MAINHAND || armorType == EquipmentSlot.OFFHAND;
    }

    public int m_8105_(ItemStack stack) {
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41783_());
        int base = recipe.getMaxChannelTime();
        if (EnchantmentHelper.m_44936_((ItemStack)stack)) {
            base *= 2;
        }
        return base;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @Override
    protected Component getTranslatedDisplayName(SpellRecipe recipe) {
        if (recipe.isMysterious()) {
            return Component.m_237115_((String)"item.mna.spell.mysterious");
        }
        MutableComponent shape = Component.m_237115_((String)((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString());
        StringBuilder sb = new StringBuilder();
        recipe.iterateComponents(c -> {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(Component.m_237115_((String)((SpellEffect)c.getPart()).getRegistryName().toString()).getString());
        });
        MutableComponent base = Component.m_237110_((String)"item.mna.spell.display_name", (Object[])new Object[]{shape.getString(), sb.toString()});
        return base;
    }

    public static void setCustomIcon(ItemStack stack, int index) {
        stack.m_41784_().m_128405_("icon", index);
    }

    public static int getCustomIcon(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("icon")) {
            return tag.m_128451_("icon");
        }
        return -1;
    }

    @Override
    public boolean requiresModifierKey() {
        return true;
    }
}

