/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.runes;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.IAreaItem;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.gui.containers.providers.NamedAreaAdjust;
import com.mna.items.ItemInit;
import com.mna.items.base.IItemWithGui;
import com.mna.items.runes.ItemRune;
import com.mna.tools.math.MathUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class ItemRuneMarkingPair
extends ItemRune
implements IItemWithGui<ItemRuneMarkingPair>,
IAreaItem<ItemRuneMarkingPair>,
DyeableLeatherItem {
    public int getMaxStackSize(ItemStack stack) {
        return this.getBounds(stack) == null ? 64 : 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack held = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        if (pUsedHand == InteractionHand.MAIN_HAND) {
            AABB bounds = this.getBounds(held);
            if (bounds == null) {
                pPlayer.m_213846_((Component)Component.m_237115_((String)"item.mna_rune_marking_pair.no_area_no_gui"));
                return InteractionResultHolder.m_19096_((Object)held);
            }
            if (IItemWithGui.super.openGuiIfModifierPressed(this.m_7968_(), pPlayer, pLevel)) {
                return InteractionResultHolder.m_19096_((Object)held);
            }
        }
        return InteractionResultHolder.m_19098_((Object)held);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.m_43723_().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            if (context.m_43725_().m_5776_()) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.rune_marking.no_magic").m_130940_(ChatFormatting.GOLD));
            }
            return InteractionResult.FAIL;
        }
        if (context.m_43724_() == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        boolean didSplit = false;
        if (stack.m_41613_() > 1) {
            stack.m_41774_(1);
            stack = new ItemStack((ItemLike)ItemInit.RUNE_MARKING_PAIR.get());
            didSplit = true;
        }
        this.scanAndSetArea(stack, (LevelReader)context.m_43725_(), context.m_8083_(), 4);
        if (didSplit && !context.m_43723_().m_36356_(stack)) {
            context.m_43723_().m_36176_(stack, true);
        }
        return InteractionResult.SUCCESS;
    }

    private void scanAndSetArea(ItemStack stack, LevelReader reader, BlockPos center, int maxRadius) {
        BlockState centerState = reader.m_8055_(center);
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (int i = -maxRadius; i <= maxRadius; ++i) {
            for (int j = -maxRadius; j <= maxRadius; ++j) {
                for (int k = -maxRadius; k <= maxRadius; ++k) {
                    BlockPos offset;
                    BlockState offsetState;
                    if (i == 0 && j == 0 && k == 0 || !(offsetState = reader.m_8055_(offset = center.m_7918_(i, j, k))).m_60713_(centerState.m_60734_())) continue;
                    if (minX > i) {
                        minX = i;
                    }
                    if (maxX < i) {
                        maxX = i;
                    }
                    if (minY > j) {
                        minY = j;
                    }
                    if (maxY < j) {
                        maxY = j;
                    }
                    if (minZ > k) {
                        minZ = k;
                    }
                    if (maxZ >= k) continue;
                    maxZ = k;
                }
            }
        }
        this.setArea(stack, center.m_7918_(minX, minY, minZ), center.m_7918_(maxX, maxY, maxZ));
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        AABB area = this.getBounds(stack);
        if (area != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.mna.rune_marking_pair.setArea", (Object[])new Object[]{area.f_82288_, area.f_82289_, area.f_82290_, area.f_82291_, area.f_82292_, area.f_82293_}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.rune_marking_pair.noPosition"));
        }
        IItemWithGui.super.m_7373_(stack, worldIn, tooltip, flagIn);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getBounds(stack) != null;
    }

    @Override
    public void setArea(ItemStack stack, BlockPos center, int radius) {
        CompoundTag nbt = stack.m_41698_("mark");
        this.writeAABB(nbt, new AABB(center).m_82400_((double)radius));
    }

    @Override
    public void setArea(ItemStack stack, BlockPos corner_a, BlockPos corner_b) {
        CompoundTag nbt = stack.m_41698_("mark");
        this.writeAABB(nbt, MathUtils.createInclusiveBB(corner_a, corner_b));
    }

    @Override
    public void setArea(ItemStack stack, AABB aabb) {
        CompoundTag nbt = stack.m_41698_("mark");
        this.writeAABB(nbt, aabb);
    }

    @Override
    public AABB getBounds(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        return this.readAABB(nbt);
    }

    @Override
    public void copyAreaFrom(ItemStack source, ItemStack destination) {
        if (!(source.m_41720_() instanceof IAreaItem) || !(destination.m_41720_() instanceof IAreaItem)) {
            return;
        }
        CompoundTag srcNbt = source.m_41698_("mark");
        CompoundTag destNbt = destination.m_41698_("mark");
        destNbt.m_128405_("minx", srcNbt.m_128451_("minx"));
        destNbt.m_128405_("miny", srcNbt.m_128451_("miny"));
        destNbt.m_128405_("minz", srcNbt.m_128451_("minz"));
        destNbt.m_128405_("maxx", srcNbt.m_128451_("maxx"));
        destNbt.m_128405_("maxy", srcNbt.m_128451_("maxy"));
        destNbt.m_128405_("maxz", srcNbt.m_128451_("maxz"));
    }

    private void writeAABB(CompoundTag tag, AABB aabb) {
        tag.m_128347_("minx", aabb.f_82288_);
        tag.m_128347_("miny", aabb.f_82289_);
        tag.m_128347_("minz", aabb.f_82290_);
        tag.m_128347_("maxx", aabb.f_82291_);
        tag.m_128347_("maxy", aabb.f_82292_);
        tag.m_128347_("maxz", aabb.f_82293_);
    }

    private AABB readAABB(CompoundTag tag) {
        if (tag.m_128441_("minx") && tag.m_128441_("miny") && tag.m_128441_("minz") && tag.m_128441_("maxx") && tag.m_128441_("maxy") && tag.m_128441_("maxz")) {
            return new AABB(tag.m_128459_("minx"), tag.m_128459_("miny"), tag.m_128459_("minz"), tag.m_128459_("maxx"), tag.m_128459_("maxy"), tag.m_128459_("maxz"));
        }
        return null;
    }

    @Override
    public void adjust(ItemStack stack, Vector3f amount, boolean grow) {
        AABB aabb = this.getBounds(stack);
        aabb = grow ? aabb.m_82363_((double)amount.x, (double)amount.y, (double)amount.z) : aabb.m_82310_((double)amount.x, (double)amount.y, (double)amount.z);
        this.setArea(stack, aabb);
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedAreaAdjust();
    }
}

