/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.ritual;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.items.TieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.rituals.RitualBlockPos;
import com.mna.api.rituals.RitualEffect;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Ritual;
import com.mna.recipes.rituals.RitualRecipe;
import com.mna.rituals.MatchedRitual;
import com.mna.rituals.contexts.RitualCheckContext;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ItemPurifiedVinteumDust
extends TieredItem {
    public ItemPurifiedVinteumDust(Item.Properties properties) {
        super(new Item.Properties());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.m_43723_().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        IPlayerProgression progression = (IPlayerProgression)context.m_43723_().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return InteractionResult.FAIL;
        }
        if (!context.m_43725_().f_46443_ && context.m_43723_().m_6144_() && context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == BlockInit.CHALK_RUNE.get()) {
            this.commandRitualEntity(context, (NonNullList<RitualBlockPos>)NonNullList.m_122779_());
            return InteractionResult.SUCCESS;
        }
        MatchedRitual ritualMatch = RitualRecipe.matchAnyInWorld(context.m_8083_(), context.m_43725_());
        if (ritualMatch != null) {
            if (context.m_43725_().f_46443_) {
                this.spawnClientParticles(context);
            } else {
                Component cantStartReason;
                RitualEffect matchedEffect = Registries.RitualEffect.get().getValues().stream().filter(r -> r.matchRitual(ritualMatch.getRitual().m_6423_())).findFirst().orElse(null);
                if (matchedEffect == null && !ritualMatch.getRitual().hasCommand()) {
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"mna:ritual-no-handler"));
                    return InteractionResult.FAIL;
                }
                if (ritualMatch.getRitual().getTier() > progression.getTier()) {
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"mna:ritual-start-tier-fail"));
                    return InteractionResult.FAIL;
                }
                if (matchedEffect != null && (!context.m_43723_().m_7500_() || matchedEffect.applyStartCheckInCreative()) && (cantStartReason = matchedEffect.canRitualStart(new RitualCheckContext(context.m_43723_(), (ServerLevel)context.m_43725_(), ritualMatch.getRitual(), context.m_8083_(), this.getRitualAbove(context)))) != null) {
                    context.m_43723_().m_213846_(cantStartReason);
                    return InteractionResult.FAIL;
                }
                this.updateBlockStates(context, ritualMatch.getPositions(), true);
                RitualInteractResult result = this.commandRitualEntity(context, ritualMatch.getPositions());
                if (result == RitualInteractResult.SPAWN) {
                    this.spawnRitualEntity(context, ritualMatch.getRitual(), ritualMatch.getPositions());
                } else if (result == RitualInteractResult.STARTED && !context.m_43723_().m_6144_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void spawnClientParticles(UseOnContext context) {
        for (int i = 0; i < 50; ++i) {
            context.m_43725_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_RANDOM.get())), (double)((float)context.m_8083_().m_123341_() + context.m_43725_().m_213780_().m_188501_() * 10.0f - 5.0f), (double)((float)context.m_8083_().m_123342_() + context.m_43725_().m_213780_().m_188501_()), (double)((float)context.m_8083_().m_123343_() + context.m_43725_().m_213780_().m_188501_() * 10.0f - 5.0f), 0.0, 0.0, 0.0);
        }
    }

    void updateBlockStates(UseOnContext context, NonNullList<RitualBlockPos> matchedPositions, boolean activated) {
        for (RitualBlockPos position : matchedPositions) {
            BlockState state = context.m_43725_().m_8055_(position.getBlockPos());
            BlockState newState = (BlockState)state.m_61124_((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(activated));
            context.m_43725_().m_46597_(position.getBlockPos(), newState);
            context.m_43725_().m_7260_(position.getBlockPos(), state, newState, 2);
        }
    }

    private Ritual getRitualAbove(UseOnContext context) {
        List entities = context.m_43725_().m_6249_((Entity)context.m_43723_(), new AABB(context.m_8083_()).m_82400_(2.0), e -> e.m_6095_() == EntityInit.RITUAL_ENTITY.get());
        Entity ritualEntity = null;
        if (entities != null && entities.size() == 1 && (ritualEntity = (Entity)entities.get(0)) instanceof Ritual) {
            return (Ritual)ritualEntity;
        }
        return null;
    }

    RitualInteractResult commandRitualEntity(UseOnContext context, NonNullList<RitualBlockPos> matchedPositions) {
        Ritual ritualEntity = this.getRitualAbove(context);
        if (ritualEntity != null) {
            if (context.m_43723_().m_6047_()) {
                if (ritualEntity.cancelRitual()) {
                    return RitualInteractResult.CANCELED;
                }
            } else if (ritualEntity.confirmRitualReagents()) {
                return RitualInteractResult.STARTED;
            }
            return RitualInteractResult.NO_ACTION;
        }
        return RitualInteractResult.SPAWN;
    }

    boolean spawnRitualEntity(UseOnContext context, RitualRecipe ritual, NonNullList<RitualBlockPos> matchedPositions) {
        if (context.m_43723_() == null) {
            ManaAndArtifice.LOGGER.error("Received a null player reference when trying to spawn a ritual.  This shouln't happen and something has messed with vanilla code!  Aborting.");
            return false;
        }
        if (context.m_43723_().m_20148_() == null) {
            ManaAndArtifice.LOGGER.error("Unable to resolve UUID for a player.  This shouln't happen and something has messed with vanilla code!  Aborting.");
            return false;
        }
        MutableBoolean success = new MutableBoolean(false);
        context.m_43723_().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            float speed = Math.max(1.0f - 0.2f * (float)(p.getTier() - ritual.getTier()), 0.2f);
            Ritual ritualEntity = new Ritual((EntityType<? extends Ritual>)((EntityType)EntityInit.RITUAL_ENTITY.get()), context.m_43725_());
            BlockPos ritualSpawnPos = context.m_8083_();
            ritualEntity.m_6034_((float)ritualSpawnPos.m_123341_() + 0.5f, ritualSpawnPos.m_123342_(), (float)ritualSpawnPos.m_123343_() + 0.5f);
            ritualEntity.setRitualBlockLocations(matchedPositions);
            ritualEntity.setRitualName(ritual.m_6423_());
            ritualEntity.setSpeed(speed);
            ritualEntity.setCasterUUID(context.m_43723_().m_20148_());
            context.m_43725_().m_7967_((Entity)ritualEntity);
            success.setTrue();
        });
        return success.getValue();
    }

    static enum RitualInteractResult {
        SPAWN,
        UPDATED,
        STARTED,
        CANCELED,
        NO_ACTION;

    }
}

