/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.relic;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.api.items.IRelic;
import com.mna.api.items.IShowHud;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.gui.containers.providers.NamedAstroBlade;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.base.ItemBagBase;
import com.mna.items.filters.ItemFilterGroup;
import com.mna.items.renderers.AstroBladeRenderer;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.NonNullLazy;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ItemAstroBlade
extends ItemBagBase
implements IShowHud,
IRelic {
    public static final String NBT_AS_WARDEN = "as_warden";
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();
    public static final int INVENTORY_SIZE = 2;
    public static final int SLOT_HANDLE = 0;
    public static final int SLOT_BLADE = 1;
    private final Multimap<net.minecraft.world.entity.ai.attributes.Attribute, AttributeModifier> defaultModifiers;

    public ItemAstroBlade() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_().m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 10.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new AstroBladeRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.getAllowedEnchantments().contains(ench)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.getAllowedEnchantments().contains(enchantment);
    }

    @Override
    public ItemFilterGroup filterGroup() {
        return ItemFilterGroup.ANY_SPELL;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedAstroBlade(stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        SpellRecipe recipe;
        ItemInventoryBase inv = new ItemInventoryBase(stack);
        ItemStack bladeSlot = inv.getStackInSlot(1);
        if (bladeSlot.m_41720_() == ItemInit.ENCHANTED_VELLUM.get()) {
            return super.onLeftClickEntity(stack, player, entity);
        }
        if (!bladeSlot.m_41619_() && SpellRecipe.stackContainsSpell(bladeSlot) && !player.m_9236_().m_5776_() && (recipe = SpellRecipe.fromNBT(bladeSlot.m_41783_())).isValid()) {
            MutableBoolean consumed = new MutableBoolean(false);
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(c -> {
                if (c.getCastingResource().hasEnoughAbsolute((LivingEntity)player, recipe.getManaCost())) {
                    c.getCastingResource().consume((LivingEntity)player, recipe.getManaCost());
                    consumed.setTrue();
                }
            });
            if (consumed.getValue().booleanValue()) {
                SpellSource source = new SpellSource((LivingEntity)player, InteractionHand.MAIN_HAND);
                SpellContext context = new SpellContext(player.m_9236_(), recipe);
                recipe.iterateComponents(c -> {
                    int delay = (int)(c.getValue(Attribute.DELAY) * 20.0f);
                    boolean appliedComponent = false;
                    if (delay > 0) {
                        DelayedEventQueue.pushEvent(player.m_9236_(), new TimedDelayedSpellEffect(((SpellEffect)c.getPart()).getRegistryName().toString(), delay, source, new SpellTarget(entity), (IModifiedSpellPart<SpellEffect>)c, context));
                        appliedComponent = true;
                    } else if (((SpellEffect)c.getPart()).ApplyEffect(source, new SpellTarget(entity), (IModifiedSpellPart<SpellEffect>)c, context) == ComponentApplicationResult.SUCCESS) {
                        appliedComponent = true;
                    }
                    if (appliedComponent) {
                        SpellCaster.addComponentRoteProgress(player, (SpellEffect)c.getPart());
                    }
                });
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ItemStack held = player.m_21120_(hand);
            if (this.openGuiIfModifierPressed(held, player, world)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)held);
            }
            ItemInventoryBase inv = new ItemInventoryBase(held);
            ItemStack hiltSlot = inv.getStackInSlot(0);
            if (hiltSlot.m_41720_() == ItemInit.ENCHANTED_VELLUM.get()) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
            }
            if (!hiltSlot.m_41619_()) {
                ItemSpell.castSpellOnUse(hiltSlot, world, player, hand, this::shouldConsumeMana);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)held);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.mna.astro_blade.lore_1").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.mna.astro_blade.lore_2").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"  "));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<net.minecraft.world.entity.ai.attributes.Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43274_) {
        return p_43274_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43274_);
    }

    public int m_8105_(ItemStack p_41454_) {
        return 99999;
    }

    public void m_5929_(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            ItemSpell.castSpellOnChannelTick(stack, (Player)player, count, this::shouldConsumeChanneledMana);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_21253_();
        }
        return stack;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        if (pState.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return pState.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_60713_(Blocks.f_50033_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    protected ArrayList<Enchantment> getAllowedEnchantments() {
        this.allowedEnchantments.clear();
        if (this.allowedEnchantments.size() == 0) {
            this.allowedEnchantments.add(Enchantments.f_44979_);
            this.allowedEnchantments.add(Enchantments.f_44981_);
            this.allowedEnchantments.add(Enchantments.f_44980_);
            this.allowedEnchantments.add(Enchantments.f_44982_);
            this.allowedEnchantments.add(Enchantments.f_44978_);
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.BEHEADING.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.DURATION_MOD.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.RANGE_MOD.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.SPEED_MOD.get());
            this.allowedEnchantments.add(Enchantments.f_44971_);
            this.allowedEnchantments.add(Enchantments.f_44958_);
            this.allowedEnchantments.add(Enchantments.f_44984_);
            this.allowedEnchantments.add(Enchantments.f_44990_);
            this.allowedEnchantments.add(Enchantments.f_44955_);
            this.allowedEnchantments.add(Enchantments.f_44954_);
            this.allowedEnchantments.add(Enchantments.f_44988_);
            this.allowedEnchantments.add(Enchantments.f_44960_);
            this.allowedEnchantments.add(Enchantments.f_44972_);
            this.allowedEnchantments.add(Enchantments.f_44974_);
            this.allowedEnchantments.add(Enchantments.f_44977_);
            this.allowedEnchantments.add(Enchantments.f_44983_);
        }
        return this.allowedEnchantments;
    }

    protected boolean shouldConsumeMana(ItemStack stack) {
        return true;
    }

    protected boolean shouldConsumeChanneledMana(Player player, ItemStack stack) {
        return true;
    }
}

