/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.Registries;
import com.mna.api.faction.IFaction;
import com.mna.api.items.TieredItem;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.faction.util.FactionRaid;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemFactionHorn
extends TieredItem {
    private final ResourceLocation faction;
    private IFaction _cachedFaction;

    public ItemFactionHorn(ResourceLocation faction) {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
        this.faction = faction;
    }

    public IFaction getFaction() {
        if (this._cachedFaction == null) {
            this._cachedFaction = (IFaction)Registries.Factions.get().getValue(this.faction);
        }
        return this._cachedFaction;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        context.m_43723_().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < 5) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.faction_horn.low_tier"));
                return;
            }
            if (p.getAlliedFaction() == null || !p.getAlliedFaction().equals(this.getFaction())) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.faction_horn.wrong_faction"));
                return;
            }
            context.m_43723_().m_36335_().m_41524_((Item)this, 18000);
            if (this.getHornSound() != null) {
                world.m_6263_(null, (double)context.m_8083_().m_123341_(), (double)context.m_8083_().m_123342_(), (double)context.m_8083_().m_123343_(), this.getHornSound(), SoundSource.PLAYERS, 1.0f, (float)((double)0.9f + (double)0.2f * Math.random()));
            }
            this.spawnAllies(world, context.m_43723_(), context.m_8083_().m_7494_());
        });
        return InteractionResult.SUCCESS;
    }

    private void spawnAllies(Level world, Player player, BlockPos pos) {
        int strength = 150;
        FactionRaid fre = new FactionRaid(world, null, strength);
        fre.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        fre.setFaction(this.faction);
        fre.setProtective(player);
        world.m_7967_((Entity)fre);
    }

    private SoundEvent getHornSound() {
        IFaction faction = (IFaction)Registries.Factions.get().getValue(this.faction);
        if (faction != null) {
            return faction.getHornSound();
        }
        return null;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
    }
}

