/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifact;

import com.mna.api.entities.DamageHelper;
import com.mna.api.items.IShowHud;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.entities.boss.attacks.ThrownAllfatherAxe;
import com.mna.items.base.INoCreativeTab;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AllfatherAxeControl
extends Item
implements IShowHud,
INoCreativeTab {
    private static final int TELEPORT_MANA_COST = 125;
    private static final int RADIUS = 5;

    public AllfatherAxeControl() {
        super(new Item.Properties().m_41486_().setNoRepair().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        AllfatherAxeControl.recallAxe(context.m_43725_(), stack);
        return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack held = pPlayer.m_21120_(pUsedHand);
        AllfatherAxeControl.recallAxe(pLevel, held);
        return InteractionResultHolder.m_19092_((Object)held, (boolean)pLevel.m_5776_());
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        MutableBoolean consumed = new MutableBoolean();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (!p.m_36335_().m_41519_((Item)this)) {
                p.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    if (m.getCastingResource().hasEnough(entity, 125.0f)) {
                        m.getCastingResource().consume(entity, 125.0f);
                        consumed.setTrue();
                    }
                });
            }
        } else {
            consumed.setTrue();
        }
        if (consumed.getValue().booleanValue()) {
            ThrownAllfatherAxe axe = AllfatherAxeControl.getAxe(entity.m_9236_(), stack);
            stack.m_41774_(1);
            if (axe != null) {
                if (entity.m_9236_().m_5776_()) {
                    AllfatherAxeControl.spawnParticles(entity, axe);
                }
                BlockPos pos = BlockPos.m_274446_((Position)axe.m_20182_());
                if (entity.m_9236_().m_46859_(pos) && entity.m_9236_().m_46859_(pos.m_7494_())) {
                    DelayedEventQueue.pushEvent(entity.m_9236_(), new TimedDelayedEvent<Pair>("damage_burst", 10, new Pair((Object)entity, (Object)axe.m_20182_()), AllfatherAxeControl::teleportAndDamage));
                }
                axe.setReturning();
            }
        }
        return false;
    }

    private static void recallAxe(Level world, ItemStack stack) {
        ThrownAllfatherAxe axe = AllfatherAxeControl.getAxe(world, stack);
        stack.m_41774_(1);
        if (axe != null) {
            axe.setReturning();
        }
    }

    private static ThrownAllfatherAxe getAxe(Level world, ItemStack stack) {
        int entityID;
        Entity e;
        if (stack.m_41720_() instanceof AllfatherAxeControl && stack.m_41782_() && (e = world.m_6815_(entityID = stack.m_41783_().m_128451_("axe_id"))) instanceof ThrownAllfatherAxe) {
            return (ThrownAllfatherAxe)e;
        }
        return null;
    }

    public static void setAxe(ItemStack stack, ThrownAllfatherAxe entity) {
        if (stack.m_41720_() instanceof AllfatherAxeControl) {
            stack.m_41784_().m_128405_("axe_id", entity.m_19879_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(LivingEntity entity, ThrownAllfatherAxe axe) {
        Vec3 pos;
        int i;
        for (i = 0; i < 50; ++i) {
            pos = entity.m_20182_().m_82549_(new Vec3(0.0, Math.random(), 0.0));
            entity.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setColor((float)Math.random() * 255.0f, (float)Math.random() * 255.0f, (float)Math.random() * 255.0f).setScale(0.08f).setMaxAge(50), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.6f * Math.random() + (double)0.1f, (double)0.2f, 0.5);
        }
        for (i = 0; i < 50; ++i) {
            pos = axe.m_20182_().m_82549_(new Vec3(0.0, 1.0 + Math.random(), 0.0));
            entity.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setColor((float)Math.random() * 255.0f, (float)Math.random() * 255.0f, (float)Math.random() * 255.0f).setScale(0.08f).setMaxAge(50), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.6f * Math.random() + (double)0.1f, (double)-0.2f, 0.5);
        }
        DelayedEventQueue.pushEvent(entity.m_9236_(), new TimedDelayedEvent<Pair>("frost_burst", 10, new Pair((Object)axe.m_9236_(), (Object)axe.m_20182_()), AllfatherAxeControl::frostBurst));
    }

    private static void frostBurst(String identifier, Pair<Level, Vec3> data) {
        MAParticleType particle = (MAParticleType)((Object)ParticleInit.FROST.get());
        int count = 180;
        double angleRads = 0.0;
        double step = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            Vec3 dir = new Vec3(Math.cos(angleRads += step), Math.random() * 0.1, Math.sin(angleRads)).m_82541_();
            Vec3 vel = dir.m_82490_(1.5);
            dir = dir.m_82490_(0.2);
            ((Level)data.getFirst()).m_7106_((ParticleOptions)new MAParticleType(particle).setScale(0.5f), ((Vec3)data.getSecond()).m_7096_() + dir.f_82479_, ((Vec3)data.getSecond()).m_7098_() + Math.random(), ((Vec3)data.getSecond()).m_7094_() + dir.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    private static void teleportAndDamage(String identifier, Pair<LivingEntity, Vec3> data) {
        BlockPos soundPos = BlockPos.m_274446_((Position)((Position)data.getSecond()));
        ((LivingEntity)data.getFirst()).m_9236_().m_5594_(null, soundPos, SFX.Spell.Cast.ICE, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((LivingEntity)data.getFirst()).m_9236_().m_5594_(null, soundPos, SFX.Spell.Impact.Single.ICE, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((LivingEntity)data.getFirst()).m_9236_().m_45933_(null, new AABB(soundPos).m_82400_(5.0)).forEach(e -> {
            if (e instanceof LivingEntity) {
                ((LivingEntity)e).m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, e.m_9236_().m_9598_(), (Entity)data.getFirst()), 15.0f);
            }
        });
        ((LivingEntity)data.getFirst()).m_146884_((Vec3)data.getSecond());
        ((LivingEntity)data.getFirst()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40, 1, true, false));
    }
}

