/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items;

import com.mna.items.ItemInit;
import com.mna.items.artifice.ItemFluidJug;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemInteractionsInit {
    public static CauldronInteraction LEATHER_TO_VELLUM = (state, world, pos, player, hand, stack) -> {
        if (!world.f_46443_) {
            ItemStack vellum = new ItemStack((ItemLike)ItemInit.VELLUM.get(), 2);
            stack.m_41774_(1);
            if (!player.m_36356_(vellum)) {
                player.m_36176_(vellum, true);
            }
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    };

    static InteractionResult emptyFluidJug(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack stack, FluidStack toExtract, BlockState targetState, SoundEvent pFillSound) {
        if (!pLevel.m_5776_()) {
            MutableBoolean success = new MutableBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(h -> {
                if (h.drain(toExtract, IFluidHandler.FluidAction.SIMULATE).getAmount() == toExtract.getAmount()) {
                    h.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
                    pPlayer.m_36220_(Stats.f_12944_);
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemInit.FLUID_JUG.get())));
                    pLevel.m_46597_(pPos, targetState);
                    pLevel.m_5594_((Player)null, pPos, pFillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_142346_((Entity)null, GameEvent.f_157816_, pPos);
                    success.setTrue();
                }
            });
            return success.getValue() != false ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    static InteractionResult fillFluidJug(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack stack, FluidStack toInsert, Predicate<BlockState> pStatePredicate, SoundEvent pFillSound) {
        if (!pStatePredicate.test(pBlockState)) {
            return InteractionResult.PASS;
        }
        if (!pLevel.m_5776_()) {
            MutableBoolean success = new MutableBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(h -> {
                if (h.fill(toInsert, IFluidHandler.FluidAction.SIMULATE) == toInsert.getAmount()) {
                    h.fill(toInsert, IFluidHandler.FluidAction.EXECUTE);
                    pPlayer.m_36220_(Stats.f_12944_);
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemInit.FLUID_JUG.get())));
                    pLevel.m_46597_(pPos, Blocks.f_50256_.m_49966_());
                    pLevel.m_5594_((Player)null, pPos, pFillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_142346_((Entity)null, GameEvent.f_157816_, pPos);
                    success.setTrue();
                }
            });
            return success.getValue() != false ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    @SubscribeEvent
    public static void setupInteractions(FMLCommonSetupEvent event) {
        CauldronInteraction.f_175607_.put(Items.f_42454_, LEATHER_TO_VELLUM);
        CauldronInteraction.f_175607_.put((Item)ItemInit.MAGE_BOOTS.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.MAGE_HOOD.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.MAGE_LEGGINGS.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.MAGE_ROBES.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.RECIPE_COPY_BOOK.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.BANGLE.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.PRACTITIONERS_POUCH.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.RUNE_MARKING.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.RUNE_MARKING_PAIR.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.SPELL_BOOK.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.ROTE_BOOK.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ItemInit.GRIMOIRE.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175606_.put((Item)ItemInit.FLUID_JUG.get(), (blockState, level, pos, player, hand, stack) -> {
            FluidStack contained = ((ItemFluidJug)ItemInit.FLUID_JUG.get()).getFluidTagData(stack);
            if (contained.isEmpty() || contained.getAmount() < 1000 || contained.getFluid() != Fluids.f_76193_ && contained.getFluid() != Fluids.f_76195_) {
                return InteractionResult.FAIL;
            }
            FluidStack toExtract = contained.copy();
            toExtract.setAmount(1000);
            BlockState targetState = contained.getFluid() == Fluids.f_76193_ ? (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)) : Blocks.f_152477_.m_49966_();
            return ItemInteractionsInit.emptyFluidJug(blockState, level, pos, player, hand, stack, toExtract, targetState, SoundEvents.f_11778_);
        });
        CauldronInteraction.f_175606_.put((Item)ItemInit.FLUID_JUG_INFINITE_WATER.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.emptyFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76193_, 1000), (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_));
        CauldronInteraction.f_175606_.put((Item)ItemInit.FLUID_JUG_INFINITE_LAVA.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.emptyFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76195_, 1000), Blocks.f_152477_.m_49966_(), SoundEvents.f_11778_));
        CauldronInteraction.f_175607_.put((Item)ItemInit.FLUID_JUG.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.fillFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76193_, 1000), predicateBlockState -> (Integer)predicateBlockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        CauldronInteraction.f_175607_.put((Item)ItemInit.FLUID_JUG_INFINITE_WATER.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.fillFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76193_, 1000), predicateBlockState -> (Integer)predicateBlockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        CauldronInteraction.f_175608_.put((Item)ItemInit.FLUID_JUG.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.fillFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76195_, 1000), predicateBlockState -> true, SoundEvents.f_11781_));
        CauldronInteraction.f_175608_.put((Item)ItemInit.FLUID_JUG_INFINITE_LAVA.get(), (blockState, level, pos, player, hand, stack) -> ItemInteractionsInit.fillFluidJug(blockState, level, pos, player, hand, stack, new FluidStack((Fluid)Fluids.f_76195_, 1000), predicateBlockState -> true, SoundEvents.f_11781_));
    }
}

