/*
 * Decompiled with CFR 0.152.
 */
package com.mna.interop;

import com.mna.items.artifice.ItemFluidJug;
import com.mna.tools.math.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CurioRenderer
implements ICurioRenderer {
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStack.m_85836_();
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)slotContext.entity());
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)slotContext.entity());
        if (stack.m_41720_() instanceof ItemFluidJug) {
            matrixStack.m_252880_(0.0f, 0.3f, 0.2f);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
        } else {
            matrixStack.m_252880_(0.0f, 0.3f, 0.2f);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, (Level)mc.f_91073_, light);
        if (stack.m_41720_() instanceof ItemFluidJug) {
            FluidStack flStack = ((ItemFluidJug)stack.m_41720_()).getFluidTagData(stack);
            IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((Fluid)flStack.getFluid());
            if (!flStack.isEmpty()) {
                float pct = MathUtils.clamp01((float)flStack.getAmount() / 16000.0f);
                matrixStack.m_252880_(0.0f, -0.315f, 0.2f);
                this.renderFluidBar(matrixStack, renderTypeBuffer, light, partialTicks, extension, pct, ((ItemFluidJug)stack.m_41720_()).isInfinite());
            }
        }
        matrixStack.m_85849_();
    }

    private void renderFluidBar(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLight, float partialTicks, IClientFluidTypeExtensions attrs, float fillPct, boolean infinite) {
        float width = infinite ? 0.08f : 0.12f;
        float min = infinite ? 0.02f : 0.0f;
        float height = infinite ? 0.2f : 0.5f;
        ResourceLocation fluidTexBase = attrs.getStillTexture();
        if (fluidTexBase == null) {
            return;
        }
        TextureAtlasSprite sp = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidTexBase);
        RenderType liquid = RenderType.m_110431_((ResourceLocation)TextureAtlas.f_118259_);
        VertexConsumer builder = bufferIn.m_6299_(liquid);
        int color = attrs.getTintColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float[] rgba = new float[]{r, g, b, a};
        Matrix3f normal = ((PoseStack.Pose)matrixStackIn.f_85834_.getLast()).m_252943_();
        Matrix4f pos = ((PoseStack.Pose)matrixStackIn.f_85834_.getLast()).m_252922_();
        Vector3f nrm = new Vector3f(0.0f, 1.0f, 0.0f);
        nrm.mul((Matrix3fc)normal);
        float maxV = sp.m_118411_() + (sp.m_118412_() - sp.m_118411_()) * fillPct;
        float minU = sp.m_118367_(0.0);
        float maxU = sp.m_118367_(8.0);
        int light = 0xF000F0;
        builder.m_252986_(pos, -width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(minU, sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(maxU, sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, width, min + height * fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(maxU, maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, -width, min + height * fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(minU, maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
    }
}

