/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.Registries;
import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.recipes.ItemAndPatternRecipe;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeSpellPart
extends RecipeRendererBase {
    ItemAndPatternRecipe recipe;
    ISpellComponent output;
    ArrayList<List<ItemStack>> reagents = new ArrayList();

    public RecipeSpellPart(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        ItemStack affinity;
        if (this.recipe == null) {
            return;
        }
        this.renderSpellIcon(pGuiGraphics, x, y);
        this.renderManaweavePatterns(pGuiGraphics, x, y);
        this.renderRecipeStack(pGuiGraphics, 0, 41, 44);
        this.renderRecipeStack(pGuiGraphics, 1, 162, 159);
        this.renderRecipeStack(pGuiGraphics, 2, 41, 159);
        this.renderRecipeStack(pGuiGraphics, 3, 162, 44);
        this.renderRecipeStack(pGuiGraphics, 4, 41, 101);
        this.renderRecipeStack(pGuiGraphics, 5, 162, 101);
        this.renderRecipeStack(pGuiGraphics, 6, 101, 44);
        this.renderRecipeStack(pGuiGraphics, 7, 101, 159);
        Font fr = this.minecraft.f_91062_;
        int tier = this.recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)this.output.getRegistryName().toString());
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int stringWidth = fr.m_92852_((FormattedText)name);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = 10;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)name, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)name) / 2, y + textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + textY + 10, color, false);
        if (this.output.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, this.output.getFactionRequirement(), textX + stringWidth + xPadding, y + textY);
        }
        if (this.output instanceof SpellEffect && !(affinity = GuiTextures.affinityIcons.getOrDefault((Object)((SpellEffect)this.output).getAffinity(), ItemStack.f_41583_)).m_41619_()) {
            this.renderItemStack(pGuiGraphics, affinity, textX - 19, y + 5);
        }
    }

    private void renderRecipeStack(GuiGraphics pGuiGraphics, int index, int x, int y) {
        if (index >= this.reagents.size()) {
            return;
        }
        this.renderItemStack(pGuiGraphics, this.reagents.get(index), (int)((float)this.m_252754_() / this.scale + (float)x), (int)((float)this.m_252907_() / this.scale + (float)(y + 1)), 1.0f);
    }

    private void renderManaweavePatterns(GuiGraphics pGuiGraphics, int x, int y) {
        float patternScale = 0.1f;
        int POINT_RENDER_SIZE = 13;
        int startX = (int)((float)(x + 31) / patternScale);
        int startY = (int)((float)(y + 225) / patternScale);
        RenderSystem.setShaderColor((float)0.5f, (float)0.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.recipe.getRequiredPatterns().length; ++i) {
            ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe((Level)this.minecraft.f_91073_, this.recipe.getRequiredPatterns()[i]);
            if (p == null) continue;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85841_(patternScale, patternScale, patternScale);
            byte[][] pData = p.get();
            int pointSize = 13;
            for (int k = 0; k < pData.length; ++k) {
                for (int j = 0; j < pData[k].length; ++j) {
                    if (pData[k][j] == 0) continue;
                    pGuiGraphics.m_280218_(GuiTextures.Widgets.GUIDE_WIDGETS, startX - j * pointSize, startY + k * pointSize, 0, 0, POINT_RENDER_SIZE, POINT_RENDER_SIZE);
                }
            }
            pGuiGraphics.m_280168_().m_85849_();
            startX = (int)((float)startX + 34.0f / patternScale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSpellIcon(GuiGraphics pGuiGraphics, int x, int y) {
        if (this.output != null) {
            pGuiGraphics.m_280163_(this.output.getGuiIcon(), x + 102, y + 101, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.SPELLPART;
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
            this.recipe = (ItemAndPatternRecipe)pattern.get();
        }
        if (this.recipe != null) {
            ResourceLocation rLoc = this.recipe.getOutput();
            if (rLoc.m_135827_().equals("mna")) {
                rLoc = new ResourceLocation("mna", "shapes/" + this.recipe.getOutput().m_135815_());
                this.output = (ISpellComponent)Registries.Shape.get().getValue(rLoc);
                if (this.output == null) {
                    rLoc = new ResourceLocation("mna", "components/" + this.recipe.getOutput().m_135815_());
                    this.output = (ISpellComponent)Registries.SpellEffect.get().getValue(rLoc);
                }
                if (this.output == null) {
                    rLoc = new ResourceLocation("mna", "modifiers/" + this.recipe.getOutput().m_135815_());
                    this.output = (ISpellComponent)Registries.Modifier.get().getValue(rLoc);
                }
            } else {
                this.output = (ISpellComponent)Registries.Shape.get().getValue(this.recipe.getOutput());
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.SpellEffect.get().getValue(this.recipe.getOutput());
                }
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.Modifier.get().getValue(this.recipe.getOutput());
                }
            }
            for (int i = 0; i < this.recipe.getRequiredItems().length; ++i) {
                this.reagents.add(MATags.smartLookupItem(this.recipe.getRequiredItems()[i]).stream().map(item -> new ItemStack((ItemLike)item)).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public int getTier() {
        return this.recipe != null ? this.recipe.getTier() : 1;
    }
}

