/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets;

import com.mna.ManaAndArtifice;
import com.mna.api.tools.MATags;
import com.mna.gui.GuiTextures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReagentList
extends ObjectSelectionList<ReagentListEntry> {
    private boolean _scrolling = false;
    private boolean fullTooltip = false;
    private final Font font;
    private final Consumer<Component> tooltipFunction;

    public ReagentList(int screenLeft, int screenTop, int x, int y, int width, int height, @Nullable Consumer<Component> tooltipFunction) {
        super(Minecraft.m_91087_(), width, height, screenTop + y, screenTop + y + height, 16);
        this.m_93471_(false);
        this.m_93473_(false, 24);
        this.f_93393_ = screenLeft + x;
        this.f_93392_ = screenLeft + x + width;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.tooltipFunction = tooltipFunction;
        this.clear();
    }

    public void setFullTooltip(boolean fullTooltip) {
        this.fullTooltip = fullTooltip;
    }

    public void clear() {
        this.m_93516_();
    }

    public void reInit(Collection<ItemStack> stacks) {
        this.clear();
        if (stacks != null) {
            this.addIconsForAll(stacks.stream().map(is -> {
                ArrayList<ItemStack> mappedCollection = new ArrayList<ItemStack>();
                mappedCollection.add((ItemStack)is);
                return mappedCollection;
            }).collect(Collectors.toList()));
        }
    }

    public void reInit(HashMap<ResourceLocation, Integer> stacks) {
        this.clear();
        if (stacks != null) {
            ArrayList<List<ItemStack>> collections = new ArrayList<List<ItemStack>>();
            stacks.entrySet().forEach(e -> {
                ArrayList collectedStacks = new ArrayList();
                List<Item> items = MATags.smartLookupItem((ResourceLocation)e.getKey());
                if (items == null || items.size() == 0) {
                    return;
                }
                items.forEach(i -> collectedStacks.add(new ItemStack((ItemLike)i, ((Integer)e.getValue()).intValue())));
                collections.add(collectedStacks);
            });
            this.addIconsForAll(collections);
        }
    }

    private void addIconsForAll(Collection<List<ItemStack>> stacks) {
        ArrayList<List<ItemStack>> segment = new ArrayList<List<ItemStack>>();
        for (List<ItemStack> part : stacks) {
            segment.add(part);
            int segmentWidth = (segment.size() + 1) * 8 + 15;
            if (segmentWidth < this.f_93388_) continue;
            this.m_7085_((AbstractSelectionList.Entry)new ReagentListEntry(segment));
            segment.clear();
        }
        if (segment.size() > 0) {
            this.m_7085_((AbstractSelectionList.Entry)new ReagentListEntry(segment));
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        int scrollBarStartX = this.m_5756_();
        pGuiGraphics.m_280588_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_);
        this.m_239227_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.m_93518_() > 0) {
            int scrollBarHeight = 20;
            int top = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - scrollBarHeight) / this.m_93518_() + this.f_93390_;
            if (top < this.f_93390_) {
                top = this.f_93390_;
            }
            pGuiGraphics.m_280163_(GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, scrollBarStartX, top, 25.0f, 20.0f, 4, scrollBarHeight, 128, 128);
        }
        pGuiGraphics.m_280618_();
    }

    @Nullable
    protected final ReagentListEntry getEntryAtPos(double mouseX, double mouseY) {
        int lowerXBound = this.m_5747_();
        int upperXBound = lowerXBound + this.m_5759_();
        int adjustedY = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) + (int)this.m_93517_();
        int index = adjustedY / this.f_93387_;
        if (index >= 0 && adjustedY >= 0 && index < this.m_5773_() && mouseX < (double)this.m_5756_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
            return (ReagentListEntry)((Object)this.m_6702_().get(index));
        }
        return null;
    }

    protected int m_5756_() {
        return this.m_5747_() + this.m_5759_() - 4;
    }

    protected int m_7610_(int p_getRowTop_1_) {
        return this.f_93390_ - (int)this.m_93517_() + p_getRowTop_1_ * this.f_93387_ - 4;
    }

    public int m_5747_() {
        return this.f_93393_;
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected void m_93481_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        super.m_93481_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
        this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.m_5756_() && p_updateScrollingState_1_ < (double)(this.m_5756_() + 6);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.m_93481_(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            this.m_7897_(true);
            return true;
        }
        return this._scrolling;
    }

    public int m_93518_() {
        return Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ - 4));
    }

    public void setSelected(@Nullable ReagentListEntry selected) {
        super.m_6987_((AbstractSelectionList.Entry)selected);
    }

    public boolean isScrolling() {
        return this._scrolling;
    }

    public class ReagentListEntry
    extends ObjectSelectionList.Entry<ReagentListEntry> {
        private Collection<List<ItemStack>> stacks;
        private int spacing = 10;

        public ReagentListEntry(Collection<List<ItemStack>> parts) {
            this.stacks = new ArrayList<List<ItemStack>>(parts);
        }

        public void m_6311_(GuiGraphics pGuiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
            int i = 0;
            float scale = 0.5f;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85841_(scale, scale, scale);
            for (List<ItemStack> stackList : this.stacks) {
                boolean isOverMe;
                int stackIndex;
                ItemStack stack;
                if (stackList == null || stackList.size() == 0 || (stack = stackList.get(stackIndex = (int)(ManaAndArtifice.instance.proxy.getClientWorld().m_46467_() / 20L) % Math.max(stackList.size(), 1))).m_41619_()) continue;
                int x = (int)((float)(5 + left + i++ * this.spacing) / scale);
                int y = (int)((float)(top + 8) / scale);
                pGuiGraphics.m_280480_(stack, x, y);
                String str = String.format("%d", stack.m_41613_());
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
                pGuiGraphics.m_280056_(ReagentList.this.font, str, x + 14 - ReagentList.this.font.m_92895_(str) / 2, y + 8, 0xFFFFFF, false);
                pGuiGraphics.m_280168_().m_85849_();
                boolean bl = isOverMe = ReagentList.this.getEntryAtPos(mouseX, mouseY) == this;
                if (!this.m_5953_(mouseX, mouseY) || !isOverMe || !((float)mouseX >= (float)x * scale) || !((float)mouseX <= (float)(x + this.spacing + 5) * scale) || ReagentList.this.tooltipFunction == null) continue;
                if (ReagentList.this.fullTooltip) {
                    Minecraft mc = Minecraft.m_91087_();
                    stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_).forEach(ReagentList.this.tooltipFunction);
                    continue;
                }
                ReagentList.this.tooltipFunction.accept((Component)Component.m_237115_((String)stack.m_41778_()));
            }
            pGuiGraphics.m_280168_().m_85849_();
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            return true;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{""});
        }
    }
}

