/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.item;

import com.mna.gui.containers.ContainerInit;
import com.mna.gui.containers.slots.GhostSlot;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.artifice.FilterItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerFilterItem
extends AbstractContainerMenu {
    public ItemStack heldItem;
    private ItemInventoryBase inventory;
    public int bagHash;
    protected int mySlot;
    private int myPlayerIndex;
    private final DataSlot matchDurability = DataSlot.m_39401_();
    private final DataSlot matchTag = DataSlot.m_39401_();

    public ContainerFilterItem(MenuType<?> type, int id, Inventory playerInv, ItemInventoryBase inventory) {
        super(type, id);
        this.inventory = inventory;
        this.bagHash = inventory.getStack().hashCode();
        this.myPlayerIndex = playerInv.f_35977_;
        this.heldItem = inventory.getStack();
        this.matchDurability.m_6422_(((FilterItem)ItemInit.FILTER_ITEM.get()).getMatchDurability(this.heldItem) ? 1 : 0);
        this.matchTag.m_6422_(((FilterItem)ItemInit.FILTER_ITEM.get()).getMatchTag(this.heldItem) ? 1 : 0);
        this.initializeSlots(playerInv);
    }

    public ContainerFilterItem(int i, Inventory playerInv, FriendlyByteBuf buffer) {
        this((MenuType)ContainerInit.FILTER_ITEM.get(), i, playerInv, new ItemInventoryBase(playerInv.m_8020_(playerInv.f_35977_), 24));
    }

    protected void initializeSlots(Inventory playerInv) {
        int col;
        int slotIndex = 0;
        int bagSlotIndex = 0;
        this.m_38895_(this.matchDurability);
        this.m_38895_(this.matchTag);
        for (col = 0; col < 6; ++col) {
            for (int row = 0; row < 4; ++row) {
                this.m_38897_((Slot)new GhostSlot(this.inventory, bagSlotIndex++, 35 + col * 18, 7 + row * 18));
                ++slotIndex;
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)playerInv, col2 + row * 9 + 9, 8 + col2 * 18, 106 + row * 18));
                ++slotIndex;
            }
        }
        for (col = 0; col < 9; ++col) {
            if (col == playerInv.f_35977_) {
                this.mySlot = slotIndex;
            }
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 164));
            ++slotIndex;
        }
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public void m_38946_() {
        super.m_38946_();
        this.inventory.writeItemStack();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == this.mySlot || clickTypeIn == ClickType.SWAP && dragType == this.myPlayerIndex) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6877_(Player p_38940_) {
        if (!p_38940_.m_9236_().m_5776_()) {
            ((FilterItem)ItemInit.FILTER_ITEM.get()).setMatchDurability(this.inventory.getStack(), this.getDurabilityMatching());
            ((FilterItem)ItemInit.FILTER_ITEM.get()).setMatchTag(this.inventory.getStack(), this.getTagMatching());
        }
        super.m_6877_(p_38940_);
    }

    public boolean m_6366_(Player player, int index) {
        if (index == 0) {
            this.matchDurability.m_6422_(this.getDurabilityMatching() ? 0 : 1);
        } else if (index == 1) {
            this.matchTag.m_6422_(this.getTagMatching() ? 0 : 1);
        }
        this.m_38946_();
        return true;
    }

    public boolean getDurabilityMatching() {
        return this.matchDurability.m_6501_() == 1;
    }

    public boolean getTagMatching() {
        return this.matchTag.m_6501_() == 1;
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        int mainSlots = 24;
        if (slot != null && slot.m_6657_()) {
            ItemStack shiftClickedStack = slot.m_7993_();
            if (index > mainSlots) {
                this.m_38903_(shiftClickedStack, 0, mainSlots, false);
            }
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean wrap) {
        boolean flag = false;
        int i = startIndex;
        if (wrap) {
            i = endIndex - 1;
        }
        i = wrap ? endIndex - 1 : startIndex;
        while (!(!wrap ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack slotStack = slot.m_7993_();
            if (slotStack.m_41619_() && (slot instanceof GhostSlot || slot.m_5857_(stack))) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                slot.m_5852_(copy);
                slot.m_6654_();
                flag = true;
                break;
            }
            if (wrap) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }
}

