/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui;

import com.mna.api.affinity.Affinity;
import com.mna.api.cantrips.ICantrip;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.resource.ICastingResourceGuiProvider;
import com.mna.api.config.ClientConfigValues;
import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.items.ChargeableItem;
import com.mna.api.items.inventory.ISpellBookInventory;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.cantrips.CantripRegistry;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.magic.resources.CastingResourceGuiRegistry;
import com.mna.effects.EffectInit;
import com.mna.entities.constructs.animated.Construct;
import com.mna.gui.GuiTextures;
import com.mna.gui.widgets.entity.ConstructDiagnosticsDisplay;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.math.MathUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.joml.Matrix4f;
import top.theillusivec4.curios.api.CuriosApi;

public class HUDOverlayRenderer {
    private Minecraft mc = Minecraft.m_91087_();
    private RecipeRendererBase pinnedRecipe;
    private ConstructDiagnosticsDisplay pinnedDiagnostics = new ConstructDiagnosticsDisplay(0, 0, null);
    private int cantripTimer = 0;
    private int cantripTimerMax = 1;
    private int unlockTimer = 0;
    private int unlockTimerMax = 1;
    private boolean showTimerBar = true;
    private String castingCantrip = null;
    private float cantripAlpha = 0.0f;
    public boolean isRenderingSpellBookChords = false;
    private float newEntryUnlockedTextAlpha = 0.0f;
    protected int screenWidth;
    protected int screenHeight;
    public static HUDOverlayRenderer instance;
    private static final int AFFINITIES_TO_DRAW = 2;
    private static final int NUMBER_WIDTH = 6;
    private static final int NUMBER_HEIGHT = 10;

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer entityPlayerSP = HUDOverlayRenderer.instance.mc.f_91074_;
        HUDOverlayRenderer.instance.screenWidth = HUDOverlayRenderer.instance.mc.m_91268_().m_85445_();
        HUDOverlayRenderer.instance.screenHeight = HUDOverlayRenderer.instance.mc.m_91268_().m_85446_();
        if (entityPlayerSP == null) {
            return;
        }
        if (!entityPlayerSP.m_6084_()) {
            instance.setPinnedRecipe(null);
            instance.setTrackedConstruct(null);
        }
        if (entityPlayerSP.m_21023_((MobEffect)EffectInit.MIND_VISION.get()) || entityPlayerSP.m_21023_((MobEffect)EffectInit.POSSESSION.get())) {
            MutableComponent prompt = Component.m_237115_((String)"gui.mna.doublejumptoexitprompt");
            int x = event.getWindow().m_85445_() / 2;
            int n = event.getWindow().m_85446_();
            Objects.requireNonNull(HUDOverlayRenderer.instance.mc.f_91062_);
            int y = n - 9 - 5;
            event.getGuiGraphics().m_280653_(HUDOverlayRenderer.instance.mc.f_91062_, (Component)prompt, x, y, ChatFormatting.GOLD.m_126665_().intValue());
            event.setCanceled(true);
            return;
        }
        if (instance.renderColdDarkFade(event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getGuiGraphics()) || instance.renderTeleportHud(event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getGuiGraphics())) {
            event.setCanceled(true);
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (HUDOverlayRenderer.instance.cantripTimer > 0) {
            --HUDOverlayRenderer.instance.cantripTimer;
            if (HUDOverlayRenderer.instance.cantripTimer <= 10) {
                HUDOverlayRenderer.instance.cantripAlpha -= 0.1f;
            } else if (HUDOverlayRenderer.instance.cantripTimer >= HUDOverlayRenderer.instance.cantripTimerMax - 10) {
                HUDOverlayRenderer.instance.cantripAlpha += 0.1f;
            }
            if (HUDOverlayRenderer.instance.cantripTimer == 0) {
                HUDOverlayRenderer.instance.castingCantrip = null;
            }
        }
        if (HUDOverlayRenderer.instance.unlockTimer > 0) {
            --HUDOverlayRenderer.instance.unlockTimer;
            if (HUDOverlayRenderer.instance.unlockTimer <= 10) {
                HUDOverlayRenderer.instance.newEntryUnlockedTextAlpha -= 0.1f;
            } else if (HUDOverlayRenderer.instance.unlockTimer >= HUDOverlayRenderer.instance.unlockTimerMax - 10) {
                HUDOverlayRenderer.instance.newEntryUnlockedTextAlpha += 0.1f;
            }
        }
    }

    public void renderHUD(GuiGraphics pGuiGraphics, int screenWidth, int screenHeight, float partialTicks) {
        LocalPlayer player = this.mc.f_91074_;
        Font fr = this.mc.f_91062_;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null || !magic.isMagicUnlocked()) {
            return;
        }
        Pair<Integer, Integer> coord = this.getHudCoordinates(screenWidth, screenHeight);
        int yPos = (Integer)coord.getSecond();
        int xPos = (Integer)coord.getFirst();
        RenderSystem.setShader(GameRenderer::m_172649_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiTextures.Hud.BARS);
        this.renderManaBar(pGuiGraphics, xPos, yPos, magic, (Player)this.mc.f_91074_, partialTicks);
        if (ClientConfigValues.HudAffinity) {
            this.renderAffinity(pGuiGraphics, magic, fr, screenWidth, screenHeight);
        }
    }

    private Pair<Integer, Integer> getHudCoordinates(int screenWidth, int screenHeight) {
        int UIWidth = 170;
        int UIHeight = 35;
        switch (ClientConfigValues.HudPosition) {
            case BottomCenter: {
                return new Pair((Object)(screenWidth / 2 - UIWidth / 2), (Object)(screenHeight - UIHeight - 45));
            }
            case BottomLeft: {
                return new Pair((Object)10, (Object)(screenHeight - UIHeight));
            }
            case BottomRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)(screenHeight - UIHeight));
            }
            case MiddleLeft: {
                if (this.pinnedRecipe != null) {
                    return new Pair((Object)-10, (Object)(screenHeight / 2 + (int)((float)this.pinnedRecipe.m_93694_() * this.getPinSizeScale()) / 2));
                }
                return new Pair((Object)-10, (Object)(screenHeight / 2 - UIHeight / 2));
            }
            case MiddleRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)(screenHeight / 2 - UIHeight / 2));
            }
            case TopCenter: {
                return new Pair((Object)(screenWidth / 2 - UIWidth / 2), (Object)1);
            }
            case TopRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)1);
            }
        }
        return new Pair((Object)-10, (Object)1);
    }

    private float getPinSizeScale() {
        return ClientConfigValues.PinnedRecipeScale == ClientConfigValues.PinnedRecipeSize.Small ? 0.35f : (ClientConfigValues.PinnedRecipeScale == ClientConfigValues.PinnedRecipeSize.Medium ? 0.55f : 0.75f);
    }

    public void renderPinnedRecipe(GuiGraphics pGuiGraphics, int screenWidth, int screenHeight) {
        if (this.pinnedRecipe != null && this.mc.f_91074_ != null) {
            float scale = this.getPinSizeScale();
            float yPos = (float)(screenHeight / 2) - (float)this.pinnedRecipe.m_93694_() * scale / 2.0f;
            this.pinnedRecipe.setScale(scale);
            this.pinnedRecipe.m_252865_(0);
            this.pinnedRecipe.m_253211_((int)yPos);
            this.pinnedRecipe.m_88315_(pGuiGraphics, 0, 0, 0.0f);
            RenderSystem.disableDepthTest();
        }
    }

    public void renderPinnedDiagnostics(GuiGraphics pGuiGraphics, int screenWidth, int screenHeight) {
        if (this.pinnedDiagnostics.isValid() && this.mc.f_91074_ != null) {
            float yPos = screenHeight / 2 - this.pinnedDiagnostics.m_93694_() / 2;
            this.pinnedDiagnostics.m_252865_(0);
            this.pinnedDiagnostics.m_253211_((int)yPos);
            this.pinnedDiagnostics.m_88315_(pGuiGraphics, 0, 0, 0.0f);
            RenderSystem.disableDepthTest();
        }
    }

    private void renderManaBar(GuiGraphics pGuiGraphics, int xPos, int yPos, IPlayerMagic magic, Player player, float partialTicks) {
        if (magic.getCastingResource().getMaxAmount() <= 0.0f) {
            return;
        }
        ICastingResourceGuiProvider provider = CastingResourceGuiRegistry.Instance.getGuiProvider(magic.getCastingResource().getRegistryName());
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)xPos, (float)yPos, 0.0f);
        xPos = 14;
        yPos = 6;
        pGuiGraphics.m_280509_(xPos + provider.getFillStartX(), yPos + provider.getFillStartY(), xPos + provider.getFillStartX() + provider.getFillWidth(), yPos + provider.getFillStartY() + provider.getFillHeight(), 0x7F000000);
        int scaledManaBarWidth = (int)(magic.getCastingResource().getAmount() / magic.getCastingResource().getMaxAmount() * (float)provider.getFillWidth());
        pGuiGraphics.m_280168_().m_85836_();
        if (scaledManaBarWidth > 0) {
            float manaCost;
            pGuiGraphics.m_280509_(xPos + provider.getFillStartX(), yPos + provider.getFillStartY(), xPos + provider.getFillStartX() + scaledManaBarWidth, yPos + provider.getFillStartY() + provider.getFillHeight(), provider.getBarColor());
            SpellRecipe mainHand = null;
            SpellRecipe offHand = null;
            mainHand = player.m_21205_().m_41720_() instanceof ItemSpellBook ? SpellRecipe.fromNBT(((ItemSpellBook)player.m_21205_().m_41720_()).getSpellCompound(player.m_21205_(), player)) : SpellRecipe.fromNBT(player.m_21205_().m_41783_());
            offHand = player.m_21206_().m_41720_() instanceof ItemSpellBook ? SpellRecipe.fromNBT(((ItemSpellBook)player.m_21206_().m_41720_()).getSpellCompound(player.m_21206_(), player)) : SpellRecipe.fromNBT(player.m_21206_().m_41783_());
            if (mainHand != null && mainHand.isValid()) {
                SpellCaster.applyAdjusters(player.m_21205_(), (LivingEntity)player, InteractionHand.MAIN_HAND, false, mainHand, SpellCastStage.CALCULATING_MANA_COST);
            }
            if (mainHand != null && offHand.isValid()) {
                SpellCaster.applyAdjusters(player.m_21206_(), (LivingEntity)player, InteractionHand.OFF_HAND, false, offHand, SpellCastStage.CALCULATING_MANA_COST);
            }
            if ((manaCost = mainHand.getManaCost() + offHand.getManaCost()) > 0.0f) {
                float manaCostPct = MathUtils.clamp01(manaCost / magic.getCastingResource().getMaxAmount());
                int color = provider.getBarManaCostEstimateColor();
                if (manaCost > magic.getCastingResource().getAmount()) {
                    color = 0xFF0000;
                }
                int blitWidth = (int)((float)provider.getFrameWidth() * manaCostPct);
                int startX = Math.max(xPos + provider.getFillStartX() + scaledManaBarWidth - blitWidth, xPos + provider.getFillStartX());
                pGuiGraphics.m_280509_(startX, yPos + provider.getFillStartY(), startX + blitWidth, yPos + provider.getFillStartY() + provider.getFillHeight(), color);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.setShader(GameRenderer::m_172649_);
        int m = (int)((float)magic.getMagicXP() / (float)magic.getXPForLevel(magic.getMagicLevel() + 1) * (float)provider.getFillWidth());
        pGuiGraphics.m_280509_(xPos + provider.getXPBarOffsetX(), yPos + provider.getXPBarOffsetY(), xPos + provider.getXPBarOffsetX() + m, yPos + provider.getXPBarOffsetY() + provider.getXPBarHeight(), provider.getXPBarColor());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)provider.getTexture());
        pGuiGraphics.m_280218_(GuiTextures.Hud.BARS, xPos, yPos, provider.getFrameU(), provider.getFrameV(), provider.getFrameWidth(), provider.getFrameHeight());
        int lcs = this.getLowChargeItemStatus();
        if (lcs != 0) {
            int delta = (provider.getFrameHeight() - provider.getFillHeight()) / 2 + provider.getLowChargeOffsetY();
            int v = lcs == 2 ? 18 : 0;
            pGuiGraphics.m_280411_(GuiTextures.Hud.BARS, xPos + provider.getFrameWidth() + 2, yPos + delta, 20, 18, 230.0f, (float)v, 20, 18, 256, 256);
        }
        int digitOffset = 0;
        ArrayList<Integer> digits = new ArrayList<Integer>();
        for (int l = magic.getMagicLevel(); l > 0; l /= 10) {
            int digit = l % 10;
            digits.add(digit);
        }
        int levelXOffset = digits.size() == 1 ? 4 : 0;
        int offsetY = 0;
        switch (ClientConfigValues.HudPosition) {
            case BottomCenter: 
            case BottomLeft: 
            case BottomRight: {
                offsetY = -30;
                break;
            }
        }
        for (int i = digits.size() - 1; i >= 0; --i) {
            int u = 250;
            int v = 10 * (Integer)digits.get(i);
            pGuiGraphics.m_280218_(GuiTextures.Hud.BARS, xPos + provider.getLevelDisplayX() + digitOffset + levelXOffset, yPos + provider.getLevelDisplayY() + offsetY, u, v, 6, 10);
            digitOffset += 7;
        }
        ItemStack deco = provider.getBadgeItem();
        if (!deco.m_41619_()) {
            pGuiGraphics.m_280480_(deco, provider.getBadgeItemOffsetX(), provider.getBadgeItemOffsetY());
        }
        pGuiGraphics.m_280168_().m_85849_();
        Font fr = this.mc.f_91062_;
        String s = String.format("%.2f / %.2f", Float.valueOf(magic.getCastingResource().getAmount()), Float.valueOf(magic.getCastingResource().getMaxAmount()));
        int textWidth = fr.m_92895_(s);
        int textX = xPos + provider.getResourceNumericOffsetX() + provider.getFillWidth() / 2 - textWidth / 2;
        pGuiGraphics.m_280056_(fr, s, textX, yPos + provider.getResourceNumericOffsetY(), provider.getResourceNumericTextColor(), false);
        if (this.newEntryUnlockedTextAlpha > 0.0f) {
            s = Component.m_237115_((String)"gui.mna.codex_entry_unlocked").getString();
            textWidth = fr.m_92895_(s);
            textX = xPos + provider.getLevelDisplayX() + digitOffset + levelXOffset + 4;
            int textY = yPos + provider.getLevelDisplayY() + offsetY + (offsetY < 0 ? 2 : 4);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Objects.requireNonNull(fr);
            pGuiGraphics.m_280509_(textX - 3, textY - 3, textX + textWidth + 2, textY + 9 + 2, 0 | (int)(255.0f * this.newEntryUnlockedTextAlpha / 2.0f) << 24);
            pGuiGraphics.m_280056_(fr, s, textX, textY, 0xE7D7BE | (int)(255.0f * this.newEntryUnlockedTextAlpha) << 24, false);
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    private int getLowChargeItemStatus() {
        MutableFloat lowestPct = new MutableFloat(1.0f);
        this.mc.f_91074_.m_150109_().f_35975_.stream().forEach(is -> lowestPct.setValue(Math.min(lowestPct.getValue().floatValue(), this.getChargePct((ItemStack)is))));
        this.mc.f_91074_.m_150109_().f_35974_.stream().forEach(is -> lowestPct.setValue(Math.min(lowestPct.getValue().floatValue(), this.getChargePct((ItemStack)is))));
        LazyOptional lazyCurios = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)this.mc.f_91074_);
        if (lazyCurios.isPresent()) {
            IItemHandlerModifiable curios = (IItemHandlerModifiable)lazyCurios.resolve().get();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack is2 = curios.getStackInSlot(i);
                lowestPct.setValue(Math.min(lowestPct.getValue().floatValue(), this.getChargePct(is2)));
            }
        }
        if (lowestPct.getValue().floatValue() == 0.0f) {
            return 2;
        }
        if (lowestPct.getValue().floatValue() < 0.1f) {
            return 1;
        }
        return 0;
    }

    private float getChargePct(ItemStack is) {
        if (is.m_41720_() instanceof ChargeableItem) {
            ChargeableItem ci = (ChargeableItem)is.m_41720_();
            return ci.getMana(is) / ci.getMaxMana();
        }
        return 1.0f;
    }

    void renderAffinity(GuiGraphics pGuiGraphics, IPlayerMagic magic, Font fr, int screenWidth, int screenHeight) {
        boolean above;
        Minecraft mc = Minecraft.m_91087_();
        if (fr == null) {
            fr = mc.f_91062_;
        }
        if (magic == null) {
            LocalPlayer p = mc.f_91074_;
            if (p == null) {
                return;
            }
            LazyOptional cap = p.getCapability(PlayerMagicProvider.MAGIC);
            if (!cap.isPresent()) {
                return;
            }
            magic = (IPlayerMagic)cap.resolve().get();
        }
        List affs = magic.getSortedAffinityDepths().entrySet().stream().filter(e -> e.getKey() == ((Affinity)((Object)((Object)e.getKey()))).getShiftAffinity()).limit(3L).collect(Collectors.toList());
        Pair<Integer, Integer> coords = instance.getHudCoordinates(screenWidth, screenHeight);
        int x = (Integer)coords.getFirst() + 35;
        int y = (Integer)coords.getSecond() + 32;
        boolean bl = above = ClientConfigValues.HudPosition == ClientConfigValues.HudPos.BottomCenter || ClientConfigValues.HudPosition == ClientConfigValues.HudPos.BottomLeft || ClientConfigValues.HudPosition == ClientConfigValues.HudPos.BottomRight;
        if (above) {
            y = (Integer)coords.getSecond() - 9;
        }
        if (HUDOverlayRenderer.instance.newEntryUnlockedTextAlpha > 0.0f) {
            Objects.requireNonNull(fr);
            int amt = 9 + 6;
            y = above ? (y -= amt) : (y += amt);
        }
        for (Map.Entry aff : affs) {
            ItemStack affStack = GuiTextures.affinityIcons.get(aff.getKey());
            if (affStack.m_41619_()) continue;
            pGuiGraphics.m_280480_(affStack, x, y);
            String s = String.format("%.1f%%", aff.getValue());
            pGuiGraphics.m_280137_(fr, s, x + 16 + fr.m_92895_(s) / 2, y + 4, 0xE0E0E0);
            x += 45;
        }
    }

    public void setPinnedRecipe(RecipeRendererBase renderer) {
        this.pinnedRecipe = renderer;
    }

    public void setTrackedConstruct(Construct construct) {
        this.pinnedDiagnostics.setConstruct(construct);
    }

    public Construct getTrackedConstruct() {
        return this.pinnedDiagnostics.getConstruct();
    }

    public void setCastingCantrip(String cantrip, int timer) {
        this.castingCantrip = cantrip;
        if (timer == 0) {
            this.cantripTimer = 60;
            this.showTimerBar = false;
        } else {
            this.cantripTimer = timer;
            this.cantripTimerMax = Math.max(timer, 1);
        }
        this.cantripAlpha = 0.0f;
    }

    public void showCodexEntriesUnlocked() {
        this.newEntryUnlockedTextAlpha = 0.0f;
        this.unlockTimer = 200;
        this.unlockTimerMax = 200;
    }

    public void renderCantripTimer(GuiGraphics pGuiGraphics, int screenWidth, int screenHeight, float partialTicks) {
        if (this.castingCantrip == null) {
            return;
        }
        Optional<ICantrip> cantrip = CantripRegistry.INSTANCE.getCantrip(new ResourceLocation(this.castingCantrip));
        if (cantrip == null || !cantrip.isPresent()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172814_);
        int x = screenWidth / 2 - GuiTextures.Cantrip_Icon_Size.x / 2;
        int y = screenHeight / 2 - GuiTextures.Cantrip_Icon_Size.y;
        float alphaF = MathUtils.clamp01(this.cantripAlpha);
        int alpha = (int)(255.0f * alphaF);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaF);
        pGuiGraphics.m_280398_(cantrip.get().getIcon(), x, y, 0, 0.0f, 0.0f, GuiTextures.Cantrip_Icon_Size.x, GuiTextures.Cantrip_Icon_Size.y, GuiTextures.Cantrip_Icon_Size.x, GuiTextures.Cantrip_Icon_Size.y);
        if (this.showTimerBar) {
            float pct = ((float)this.cantripTimer + partialTicks) / (float)this.cantripTimerMax;
            this.renderTimer(pGuiGraphics, pct, alpha, x, y += GuiTextures.Cantrip_Icon_Size.y + 10, GuiTextures.Cantrip_Icon_Size.x, 0, 0, 255);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderCenteredTimer(GuiGraphics pGuiGraphics, float pct, int alpha, int screenWidth, int screenHeight, int width, int r, int g, int b) {
        this.renderTimer(pGuiGraphics, pct, alpha, screenWidth / 2 - width / 2, screenHeight / 2 + 10, width, r, g, b);
    }

    private void renderTimer(GuiGraphics pGuiGraphics, float pct, int alpha, int x, int y, int width, int r, int g, int b) {
        pGuiGraphics.m_280509_(x, y, (int)((float)x + (float)width * pct), y + 3, FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b));
    }

    protected boolean renderColdDarkFade(int width, int height, GuiGraphics pGuiGraphics) {
        if (this.mc.f_91074_.m_21023_((MobEffect)EffectInit.COLD_DARK.get())) {
            int delay = 50;
            int fadeTime = 100;
            int duration = this.mc.f_91074_.m_21124_((MobEffect)EffectInit.COLD_DARK.get()).m_19557_();
            if (duration < delay + fadeTime) {
                RenderSystem.disableDepthTest();
                float opacity = (float)(fadeTime - (duration - delay)) / (float)fadeTime;
                if (opacity > 1.0f) {
                    opacity = 1.0f;
                }
                int color = (int)(255.0f * opacity) << 24 | 0x101020;
                pGuiGraphics.m_280509_(0, 0, width, height, color);
                RenderSystem.enableDepthTest();
            }
            return true;
        }
        return false;
    }

    protected boolean renderTeleportHud(int width, int height, GuiGraphics pGuiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        IPlayerMagic playerMagic = (IPlayerMagic)mc.f_91074_.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (playerMagic == null || playerMagic.getTeleportElapsedTicks() == 0) {
            return false;
        }
        long gameTime = mc.f_91074_.m_9236_().m_46467_();
        int transitionTicks = playerMagic.getTeleportElapsedTicks();
        int transitionDuration = playerMagic.getTeleportTotalTicks();
        int endFadeTicks = Math.max(transitionDuration - 40, transitionDuration);
        float warpPct = (float)transitionTicks / (float)transitionDuration;
        float portalAlpha = (float)Math.max(transitionTicks - (transitionDuration - endFadeTicks), 0) / (float)endFadeTicks;
        long angle = gameTime * 10L;
        float size = (float)Math.max(width, height) * warpPct;
        RenderSystem.disableDepthTest();
        int color = (int)(89.25 * (double)warpPct) << 24;
        pGuiGraphics.m_280509_(0, 0, width, height, color);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)(width / 2), (float)(height / 2), 0.0f);
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252393_.m_252977_((float)angle));
        float pX1 = -size;
        float pY1 = -size;
        float pX2 = size;
        float pY2 = size;
        float pMinU = 0.0f;
        float pMaxU = 1.0f;
        float pMinV = 0.0f;
        float pMaxV = 1.0f;
        float pBlitOffset = 0.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiTextures.Overlay.TELEPORTING);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f - portalAlpha) * 0.5f));
        Matrix4f matrix4f = pGuiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, pX1, pY1, pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX1, pY2, pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY1, pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.m_280168_().m_85849_();
        return true;
    }

    protected void renderTextureOverlay(ResourceLocation pTextureLocation, float pAlpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pAlpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pTextureLocation);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)this.screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)this.screenWidth, (double)this.screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)this.screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderSpellBookChordsHud(Player player, GuiGraphics pGuiGraphics) {
        int i;
        if (!this.isRenderingSpellBookChords) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return;
        }
        ItemStack mhStack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack ohStack = player.m_21120_(InteractionHand.OFF_HAND);
        ISpellBookInventory bookInv = null;
        if (mhStack.m_41720_() instanceof ItemSpellBook) {
            bookInv = ((ItemSpellBook)mhStack.m_41720_()).getInventory(mhStack, magic);
        } else if (ohStack.m_41720_() instanceof ItemSpellBook) {
            bookInv = ((ItemSpellBook)ohStack.m_41720_()).getInventory(ohStack, magic);
        }
        if (bookInv == null) {
            return;
        }
        ItemStack[] spells = bookInv.getActiveSpells();
        if (spells.length == 0) {
            return;
        }
        int loops = Math.min(spells.length, 9);
        int xStep = loops * 4;
        int width = xStep * loops;
        int xStart = (this.screenWidth - width) / 2;
        int xEnd = xStart + width;
        int yStart = 32;
        int height = 24;
        int solidColor = FastColor.ARGB32.m_13660_((int)255, (int)42, (int)42, (int)42);
        pGuiGraphics.m_280024_(xStart, yStart, xEnd, yStart + height, solidColor, FastColor.ARGB32.m_13660_((int)0, (int)42, (int)42, (int)42));
        int xCur = xStart;
        for (i = 0; i < 10; ++i) {
            pGuiGraphics.m_280509_(xCur, yStart, xCur + 2, yStart + height, solidColor);
            xCur += xStep;
        }
        xCur = xStart;
        for (i = 0; i < loops; ++i) {
            pGuiGraphics.m_280480_(spells[i], xCur + xStep / 2 - 8, yStart + height / 2 - 8);
            xCur += xStep;
        }
        xCur = xStart;
        for (i = 1; i < 10; ++i) {
            Font font = this.mc.f_91062_;
            MutableComponent mutableComponent = Component.m_237113_((String)String.format("%d", i));
            int n = xCur + xStep / 2 + 8;
            Objects.requireNonNull(this.mc.f_91062_);
            pGuiGraphics.m_280430_(font, (Component)mutableComponent, n, yStart + height - 9, 0xFFFFFF);
            xCur += xStep;
        }
    }

    public RecipeRendererBase getPinnedrecipe() {
        return this.pinnedRecipe;
    }

    public ConstructDiagnosticsDisplay getConstructDisplay() {
        return this.pinnedDiagnostics;
    }
}

