/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.entities.EntityInit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class RisingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> MAXAGE = SynchedEntityData.m_135353_(RisingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(RisingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(RisingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time;
    public boolean dropItem = true;
    private long removeAtMillis;
    @Nullable
    public CompoundTag blockData;

    public RisingBlock(Level worldIn, double x, double y, double z, BlockState fallingBlockState) {
        super((EntityType)EntityInit.RISING_BLOCK_ENTITY.get(), worldIn);
        this.f_19850_ = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_20183_());
        this.blockState = fallingBlockState;
        this.m_20242_(true);
        this.m_20334_(0.0, 0.5, 0.0);
        this.f_19812_ = true;
    }

    public RisingBlock(EntityType<? extends RisingBlock> type, Level world) {
        super(type, world);
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else if (this.m_9236_().m_5776_() && this.removeAtMillis > 0L) {
            if (System.currentTimeMillis() >= this.removeAtMillis) {
                super.m_142467_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            Block block = this.blockState.m_60734_();
            if (this.time++ == 0) {
                BlockPos blockpos = this.m_20183_();
                if (this.m_9236_().m_8055_(blockpos).m_60713_(block)) {
                    if (block instanceof DoorBlock) {
                        BlockState below = this.m_9236_().m_8055_(blockpos.m_7495_());
                        if (below.m_60734_() == block) {
                            this.m_9236_().m_7731_(blockpos.m_7495_(), Blocks.f_50016_.m_49966_(), 16);
                        }
                        this.m_9236_().m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 16);
                    } else {
                        this.m_9236_().m_46961_(blockpos, false);
                    }
                } else if (!this.m_9236_().m_5776_()) {
                    this.m_146870_();
                    return;
                }
            }
            List entitiesAbove = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(0.0, 1.0, 0.0));
            entitiesAbove.forEach(p -> this.moveEntity((Entity)p));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.m_9236_().m_5776_()) {
                BlockPos myPosition = this.m_20183_();
                if (this.time > (Integer)this.f_19804_.m_135370_(MAXAGE)) {
                    this.f_19863_ = true;
                }
                if (!this.f_19863_) {
                    if (!(this.m_9236_().m_5776_() || (this.time <= 100 || myPosition.m_123342_() >= 1 && myPosition.m_123342_() <= 256) && this.time <= 600)) {
                        if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                } else {
                    this.restoreBlock(myPosition, block);
                }
            }
        }
    }

    private void moveEntity(Entity p) {
        p.m_6853_(true);
        if (p.m_20184_().f_82480_ < this.m_20184_().f_82480_) {
            p.m_20334_(p.m_20184_().f_82479_, this.m_20184_().f_82480_, p.m_20184_().f_82481_);
        }
    }

    private void restoreBlock(BlockPos myPosition, Block block) {
        BlockState blockstate = this.m_9236_().m_8055_(myPosition);
        this.m_20256_(this.m_20184_().m_82542_(0.7, 0.5, 0.7));
        if (!blockstate.m_60713_(Blocks.f_50110_)) {
            this.m_146870_();
            if (block instanceof DoorBlock && this.blockState.m_61138_((Property)DoorBlock.f_52730_)) {
                this.blockState = (BlockState)this.blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER);
            }
            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), myPosition, Direction.UP, ItemStack.f_41583_, Direction.UP));
            boolean flag4 = this.blockState.m_60710_((LevelReader)this.m_9236_(), myPosition);
            if (flag2 && flag4) {
                if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(myPosition).m_76152_() == Fluids.f_76193_) {
                    this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
                if (this.m_9236_().m_7731_(myPosition, this.blockState, 3)) {
                    BlockEntity tileentity;
                    if (this.blockData != null && this.blockState.m_60734_() instanceof EntityBlock && (tileentity = this.m_9236_().m_7702_(myPosition)) != null) {
                        CompoundTag compoundnbt = tileentity.m_187480_();
                        for (String s : this.blockData.m_128431_()) {
                            Tag inbt = this.blockData.m_128423_(s);
                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                            compoundnbt.m_128365_(s, inbt.m_6426_());
                        }
                        tileentity.m_142466_(compoundnbt);
                        tileentity.m_6596_();
                    }
                } else if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)block);
                }
            } else if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)block);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(MAXAGE, (Object)50);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.05f));
    }

    public void setMaxAge(int age) {
        this.f_19804_.m_135381_(MAXAGE, (Object)age);
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
        this.m_20334_(0.0, speed, 0.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int stateId = additionalData.readInt();
        this.blockState = Block.m_49803_((int)stateId);
        if (this.blockState == null) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_7380_(CompoundTag p_31973_) {
        p_31973_.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        p_31973_.m_128405_("Time", this.time);
        p_31973_.m_128379_("DropItem", this.dropItem);
        if (this.blockData != null) {
            p_31973_.m_128365_("TileEntityData", (Tag)this.blockData);
        }
    }

    protected void m_7378_(CompoundTag p_31964_) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)p_31964_.m_128469_("BlockState"));
        this.time = p_31964_.m_128451_("Time");
        if (p_31964_.m_128425_("DropItem", 99)) {
            this.dropItem = p_31964_.m_128471_("DropItem");
        }
        if (p_31964_.m_128425_("TileEntityData", 10)) {
            this.blockData = p_31964_.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory p_31962_) {
        super.m_7976_(p_31962_);
        p_31962_.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket p_149654_) {
        super.m_141965_(p_149654_);
        this.blockState = Block.m_49803_((int)p_149654_.m_131509_());
        this.f_19850_ = true;
        double d0 = p_149654_.m_131500_();
        double d1 = p_149654_.m_131501_();
        double d2 = p_149654_.m_131502_();
        this.m_6034_(d0, d1 + (double)((1.0f - this.m_20206_()) / 2.0f), d2);
        this.setStartPos(this.m_20183_());
    }
}

