/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.api.entities.DamageHelper;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.entities.EntityInit;
import com.mna.items.ItemInit;
import com.mna.tools.InventoryUtilities;
import java.util.Map;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class ImpulseProjectile
extends ThrowableItemProjectile
implements IEntityAdditionalSpawnData {
    ItemStack defaultStack;
    float damage;
    float chanceForItemBack = 0.0f;

    public ImpulseProjectile(EntityType<? extends ImpulseProjectile> p_i50159_1_, Level p_i50159_2_) {
        super(p_i50159_1_, p_i50159_2_);
        this.defaultStack = new ItemStack((ItemLike)ItemInit.RUNE_PATTERN.get());
    }

    public ImpulseProjectile(Level worldIn, LivingEntity throwerIn, ItemStack stack, float damage) {
        super((EntityType)EntityInit.IMPULSE_PROJECTILE.get(), throwerIn, worldIn);
        this.defaultStack = stack.m_41777_();
        this.defaultStack.m_41764_(1);
        this.damage = damage;
    }

    public ImpulseProjectile(Level worldIn, double x, double y, double z, ItemStack stack, float damage) {
        super((EntityType)EntityInit.IMPULSE_PROJECTILE.get(), x, y, z, worldIn);
        this.defaultStack = stack.m_41777_();
        this.defaultStack.m_41764_(1);
        this.damage = damage;
    }

    protected Item m_7881_() {
        return this.defaultStack.m_41720_();
    }

    public void setChanceForRecovery(float chance) {
        this.chanceForItemBack = chance;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ParticleOptions makeParticle() {
        return new ItemParticleOption(ParticleTypes.f_123752_, this.defaultStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            ParticleOptions iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_(iparticledata, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        Entity owner = this.m_19749_();
        if (result instanceof EntityHitResult && owner instanceof LivingEntity) {
            Entity e = ((EntityHitResult)result).m_82443_();
            if (e == owner) {
                return;
            }
            if (e instanceof LivingEntity) {
                ((LivingEntity)e).m_6469_(DamageHelper.createSourcedType((ResourceKey<DamageType>)DamageTypes.f_268513_, e.m_9236_().m_9598_(), owner), this.damage);
            }
        }
        if (result.m_6662_() != HitResult.Type.MISS) {
            if (this.defaultStack.m_41720_() instanceof BlockItem) {
                Block block = ((BlockItem)this.defaultStack.m_41720_()).m_40614_();
                SoundEvent sound = block.m_49966_().getSoundType((LevelReader)this.m_9236_(), this.m_20183_(), (Entity)this).m_56777_();
                this.m_5496_(sound, 1.0f, 1.0f);
            } else {
                this.m_146852_(GameEvent.f_157777_, this.m_19749_());
            }
        }
        ItemStack dropStack = this.defaultStack.m_41777_();
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)dropStack);
        if (owner != null && owner instanceof Player && !((Player)owner).m_7500_() && enchants.containsKey(Enchantments.f_44955_) || enchants.containsKey(EnchantmentInit.RETURNING.get())) {
            dropStack = InventoryUtilities.mergeToPlayerInvPrioritizeOffhand((Player)owner, dropStack);
        }
        if (dropStack.m_41613_() > 0 && ((double)this.chanceForItemBack > Math.random() || result instanceof BlockHitResult) && !this.m_9236_().m_5776_()) {
            ItemEntity returnedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack);
            this.m_9236_().m_7967_((Entity)returnedItem);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        CompoundTag item = new CompoundTag();
        this.defaultStack.m_41739_(item);
        pCompound.m_128365_("item", (Tag)item);
        pCompound.m_128350_("recoveryChance", this.chanceForItemBack);
        pCompound.m_128350_("damage", this.damage);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("item")) {
            this.defaultStack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("item"));
        }
        if (pCompound.m_128441_("recoveryChance")) {
            this.chanceForItemBack = pCompound.m_128457_("recoveryChance");
        }
        if (pCompound.m_128441_("damage")) {
            this.damage = pCompound.m_128457_("damage");
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.defaultStack, true);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.defaultStack = additionalData.m_130267_();
    }
}

