/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.api.config.GeneralConfigValues;
import com.mna.entities.EntityInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class DisplayDamage
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int AGE_TIME = 30;
    public static final int FADE_OUT_START = 10;
    public static final int FADE_OUT_DURATION = 20;
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    float amount = 0.0f;
    int textColor = 0xFFFFFF;

    public DisplayDamage(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DisplayDamage(Level pLevel, DamageSource source, float amount) {
        this((EntityType)EntityInit.DAMAGE_NUMBERS.get(), pLevel);
        this.amount = amount;
        GeneralConfigValues.InsightDamageColors.stream().filter(s -> s.contains(source.m_19385_() + ":")).findFirst().ifPresent(s -> {
            String color = s.split(":")[1];
            try {
                this.textColor = Integer.decode(color.replace("0x", "#"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public void m_8119_() {
        if (++this.f_19797_ >= 30) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.01f, 0.0));
    }

    public float getAmount() {
        return this.amount;
    }

    public int getColor() {
        return this.textColor | this.getTextAlpha() << 24;
    }

    public int getTextAlpha() {
        if (this.f_19797_ < 10) {
            return 255;
        }
        return 255 - 255 * (this.f_19797_ - 10) / 20;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.amount);
        buffer.writeInt(this.textColor);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.amount = additionalData.readFloat();
        this.textColor = additionalData.readInt();
    }
}

