/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.BlockUtils;
import com.mna.tools.EntityUtil;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SpellCone
extends ChanneledSpellEntity {
    public SpellCone(EntityType<? extends SpellCone> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public SpellCone(LivingEntity caster, ISpellDefinition spell, Level world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_CONE.get()), caster, spell, world);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
    }

    @Override
    public void m_8119_() {
        LivingEntity c = this.getCaster();
        if (c != null) {
            Vec3 side = c.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82490_(0.5);
            double offsetX = 0.0;
            HumanoidArm casterHandedness = c.m_5737_();
            offsetX = casterHandedness == HumanoidArm.RIGHT && c.m_7655_() == InteractionHand.MAIN_HAND || casterHandedness == HumanoidArm.LEFT && c.m_7655_() == InteractionHand.OFF_HAND ? side.f_82479_ : -side.f_82479_;
            this.m_6034_(c.m_20185_() + offsetX, c.m_20186_() + (double)c.m_20192_() * 0.75, c.m_20189_());
        }
        super.m_8119_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        float width;
        if (caster == null) {
            return;
        }
        float depth = this.getShapeAttributeByAge(Attribute.DEPTH);
        float r = width = this.getShapeAttributeByAge(Attribute.WIDTH);
        float angle = (float)Math.abs(Math.sin(depth / r) * 180.0 / Math.PI);
        SpellSource source = new SpellSource(caster, caster.m_7655_());
        SpellContext context = new SpellContext((Level)world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            EntityUtil.getEntitiesWithinCone(this.m_9236_(), this.m_20182_(), this.getCaster().m_20156_(), depth, -angle, angle, e -> e.m_6084_() && e != this.getCaster()).forEach(e -> {
                if (this.losCheck((Entity)e)) {
                    SpellCaster.ApplyComponents(recipe, source, new SpellTarget((Entity)e), context);
                }
            });
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            int min = 0;
            int max = (int)depth;
            Vec3 pos = this.m_20182_().m_82492_(0.0, 1.0, 0.0);
            Vec3 step = this.getCaster().m_20156_().m_82541_();
            HashSet<BlockPos> allBlocks = new HashSet<BlockPos>();
            for (int i = min; i < max; ++i) {
                pos = pos.m_82549_(step);
                float radiusAtStep = r * ((float)i / (float)max);
                BlockPos[] positions = this.targetBlocks(pos, radiusAtStep, radiusAtStep);
                allBlocks.addAll(Arrays.asList(positions));
            }
            for (BlockPos bp : allBlocks) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(bp, Direction.UP).doNotOffsetFace(), context);
            }
        }
    }

    protected BlockPos[] targetBlocks(Vec3 pos, float radius_h, float radius_v) {
        double radiusOffsetX = Math.cos(Math.toRadians(this.m_146908_())) * (double)radius_h;
        double radiusOffsetZ = Math.sin(Math.toRadians(this.m_146908_())) * (double)radius_h;
        Vec3 a = new Vec3(pos.m_7096_() + radiusOffsetX, pos.m_7098_(), pos.m_7094_() + radiusOffsetZ);
        Vec3 b = new Vec3(pos.m_7096_() - radiusOffsetX, pos.m_7098_(), pos.m_7094_() - radiusOffsetZ);
        return this.getAllBlockLocationsBetween(a, b, radius_v);
    }

    protected BlockPos[] getAllBlockLocationsBetween(Vec3 a, Vec3 b, float radius_v) {
        ArrayList allPoints = new ArrayList();
        BlockUtils.stepThroughBlocksLinear(BlockUtils.Vector3dToBlockPosRound(a), BlockUtils.Vector3dToBlockPosRound(b), pos -> {
            int i = 0;
            while ((float)i < radius_v) {
                if (!allPoints.contains(pos.m_7918_(0, i, 0))) {
                    allPoints.add(pos.m_7918_(0, i, 0));
                }
                ++i;
            }
        });
        return allPoints.toArray(new BlockPos[0]);
    }

    private void spawnConeParticles(int count, MAParticleType particle) {
        Vec3 forward = Vec3.m_82498_((float)this.getCaster().m_146909_(), (float)this.getCaster().m_6080_()).m_82490_(0.25);
        Vec3 origin = this.m_20182_().m_82520_(forward.f_82479_, forward.f_82480_, forward.f_82481_);
        float depth = this.getShapeAttributeByAge(Attribute.DEPTH);
        for (int i = 0; i < count; ++i) {
            Vector3f direction = new Vector3f((float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
            direction.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
            direction.rotate((Quaternionfc)Axis.f_252495_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
            direction.rotate((Quaternionfc)Axis.f_252393_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
            direction.normalize();
            float speed = (float)(0.5 + Math.random());
            direction.mul(speed);
            this.m_9236_().m_7106_((ParticleOptions)particle.setMaxAge((int)Math.ceil(depth / speed)), origin.f_82479_ + (double)direction.x(), origin.f_82480_ + (double)direction.y(), origin.f_82481_ + (double)direction.z(), (double)direction.x(), (double)direction.y(), (double)direction.z());
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        int count = 25;
        this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        int count = 25;
        this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        int count = 25;
        if (!lightning) {
            this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)(hellfire ? (ParticleType)ParticleInit.HELLFIRE.get() : (ParticleType)ParticleInit.FLAME.get())), (Entity)this.getCaster()));
        } else {
            Vec3 forward = Vec3.m_82498_((float)this.getCaster().m_146909_(), (float)this.getCaster().m_6080_()).m_82490_(0.25);
            Vec3 origin = this.m_20182_().m_82520_(forward.f_82479_, forward.f_82480_, forward.f_82481_);
            float depth = this.getShapeAttributeByAge(Attribute.DEPTH);
            for (int i = 0; i < 5; ++i) {
                Vector3f direction = new Vector3f((float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
                direction.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
                direction.rotate((Quaternionfc)Axis.f_252495_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
                direction.rotate((Quaternionfc)Axis.f_252393_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
                direction.normalize();
                direction.mul(depth);
                this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getCaster()).setMaxAge(1 + (int)depth * 2), origin.f_82479_, origin.f_82480_, origin.f_82481_, origin.f_82479_ + (double)direction.x(), origin.f_82480_ + (double)direction.y(), origin.f_82481_ + (double)direction.z());
            }
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean frost) {
        int count = 25;
        this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)(frost ? (ParticleType)ParticleInit.FROST.get() : (ParticleType)ParticleInit.WATER.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe) {
        int count = 25;
        this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        int count = 25;
        this.spawnConeParticles(count, recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (Entity)this.getCaster()));
    }
}

