/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.ManaAndArtifice;
import com.mna.entities.rituals.FlatLandsProjectile;
import com.mna.items.ItemInit;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class FlatLands
extends Entity {
    private static final EntityDataAccessor<Vector3f> DATA_ID_TARGET = SynchedEntityData.m_135353_(FlatLands.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private BlockPos AABB1;
    private BlockPos AABB2;
    private BlockPos[] targets;
    private int curIndex;
    private int age;
    Player caster_reference;
    UUID casterID;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float nextPageAngle;
    public float pageAngle;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public int ticks;
    public int ticksSinceTargetChange;
    public float yaw;

    public FlatLands(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            ++this.ticks;
            this.updatePageTurning();
            return;
        }
        if (this.curIndex >= this.targets.length) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        ++this.age;
        if (this.getCaster() == null) {
            if (this.age > 20) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (this.age % 10 == 0) {
            BlockPos me = this.m_20183_();
            BlockPos target = this.targets[this.curIndex++];
            if (this.curIndex < this.targets.length) {
                this.f_19804_.m_135381_(DATA_ID_TARGET, (Object)new Vector3f((float)this.targets[this.curIndex].m_123341_() + 0.5f, (float)this.targets[this.curIndex].m_123342_() + 0.5f, (float)this.targets[this.curIndex].m_123343_() + 0.5f));
            }
            FlatLandsProjectile proj = new FlatLandsProjectile(this.m_9236_());
            proj.setPoints(Vec3.m_82512_((Vec3i)me), target);
            proj.setCaster(this.getCaster());
            this.m_9236_().m_7967_((Entity)proj);
        }
    }

    public void setBounds(AABB bounds) {
        this.AABB1 = BlockPos.m_274561_((double)bounds.f_82288_, (double)bounds.f_82289_, (double)bounds.f_82290_);
        this.AABB2 = BlockPos.m_274561_((double)bounds.f_82291_, (double)bounds.f_82292_, (double)bounds.f_82293_);
        double xDim = bounds.m_82362_();
        double yDim = bounds.m_82376_();
        double zDim = bounds.m_82385_();
        ArrayList<BlockPos> allPoints = new ArrayList<BlockPos>();
        int x = 1;
        while ((double)x <= xDim - 1.0) {
            for (int y = (int)(yDim - 1.0); y > 0; y -= 3) {
                int z = 1;
                while ((double)z <= zDim - 1.0) {
                    allPoints.add(BlockPos.m_274561_((double)(bounds.f_82288_ + (double)x), (double)(bounds.f_82289_ + (double)y), (double)(bounds.f_82290_ + (double)z)));
                    if (!((double)(z += 3) >= zDim) || !((double)z < zDim + 2.0) || (zDim - 2.0) % 3.0 == 0.0) continue;
                    z = (int)(zDim - 1.0);
                }
            }
            if (!((double)(x += 3) > xDim - 1.0) || !((double)x < xDim + 2.0) || (xDim - 2.0) % 3.0 == 0.0) continue;
            x = (int)(xDim - 1.0);
        }
        this.targets = new BlockPos[allPoints.size()];
        this.targets = allPoints.toArray(this.targets);
        this.curIndex = 0;
    }

    private Vector3f target() {
        return (Vector3f)this.f_19804_.m_135370_(DATA_ID_TARGET);
    }

    public void setCaster(Player caster) {
        this.caster_reference = caster;
    }

    private Player getCaster() {
        if (this.caster_reference == null && this.casterID != null) {
            this.caster_reference = this.m_9236_().m_46003_(this.casterID);
        }
        return this.caster_reference;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_TARGET, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("min_x") && compound.m_128441_("min_y") && compound.m_128441_("min_z")) {
            this.AABB1 = new BlockPos(compound.m_128451_("min_x"), compound.m_128451_("min_y"), compound.m_128451_("min_z"));
        }
        if (compound.m_128441_("max_x") && compound.m_128441_("max_y") && compound.m_128441_("max_z")) {
            this.AABB2 = new BlockPos(compound.m_128451_("max_x"), compound.m_128451_("max_y"), compound.m_128451_("max_z"));
        }
        if (this.AABB1 != null && this.AABB2 != null) {
            AABB bb = MathUtils.createInclusiveBB(this.AABB1, this.AABB2);
            this.setBounds(bb);
        }
        if (compound.m_128441_("curIndex")) {
            this.curIndex = compound.m_128451_("curIndex");
        }
        if (compound.m_128441_("age")) {
            this.age = compound.m_128451_("age");
        }
        if (compound.m_128441_("caster_uuid")) {
            try {
                this.casterID = UUID.fromString(compound.m_128461_("caster_uuid"));
            }
            catch (Exception e) {
                ManaAndArtifice.LOGGER.error("Error loading caster UUID for flat lands projectile!");
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("min_x", this.AABB1.m_123341_());
        compound.m_128405_("min_y", this.AABB1.m_123342_());
        compound.m_128405_("min_z", this.AABB1.m_123343_());
        compound.m_128405_("max_x", this.AABB2.m_123341_());
        compound.m_128405_("max_y", this.AABB2.m_123342_());
        compound.m_128405_("max_z", this.AABB2.m_123343_());
        compound.m_128405_("curIndex", this.curIndex);
        compound.m_128405_("age", this.age);
        compound.m_128359_("caster_uuid", this.caster_reference != null ? this.caster_reference.m_20148_().toString() : "");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.m_9236_().m_5776_()) {
            ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.FLAT_LANDS_BOOK.get()));
            this.m_9236_().m_7967_((Entity)item);
        }
    }

    private void updatePageTurning() {
        float f2;
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        this.pageAngle = this.nextPageAngle;
        if (this.target() != null) {
            double d0 = (double)this.target().x - this.m_20185_();
            double d1 = (double)this.target().z() - this.m_20189_();
            this.yaw = (float)Mth.m_14136_((double)d1, (double)d0);
            this.nextPageTurningSpeed += 0.1f;
            if (this.nextPageTurningSpeed < 0.5f || this.f_19796_.m_188503_(40) == 0) {
                float f1 = this.flipT;
                do {
                    this.flipT += (float)(this.f_19796_.m_188503_(4) - this.f_19796_.m_188503_(4));
                } while (f1 == this.flipT);
            }
        } else {
            this.yaw += 0.02f;
            this.nextPageTurningSpeed -= 0.1f;
        }
        while (this.nextPageAngle >= (float)Math.PI) {
            this.nextPageAngle -= (float)Math.PI * 2;
        }
        while (this.nextPageAngle < (float)(-Math.PI)) {
            this.nextPageAngle += (float)Math.PI * 2;
        }
        while (this.yaw >= (float)Math.PI) {
            this.yaw -= (float)Math.PI * 2;
        }
        while (this.yaw < (float)(-Math.PI)) {
            this.yaw += (float)Math.PI * 2;
        }
        for (f2 = this.yaw - this.nextPageAngle; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.nextPageAngle += f2 * 0.4f;
        this.nextPageTurningSpeed = Mth.m_14036_((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++this.ticks;
        ++this.ticksSinceTargetChange;
        this.oFlip = this.flip;
        float f = (this.flipT - this.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

