/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.EntityInit;
import com.mna.entities.UtilityEntityBase;
import com.mna.entities.boss.FaerieQueen;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FeyLight
extends UtilityEntityBase {
    private static final EntityDataAccessor<String> CASTER_UUID = SynchedEntityData.m_135353_(FeyLight.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<BlockPos> TARGET_POSITION = SynchedEntityData.m_135353_(FeyLight.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private float angle = 0.0f;
    private int growTicks = 0;
    private static int maxGrowTicks = 40;

    public FeyLight(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.age == 1 && this.m_9236_().m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_() - 9.0, this.m_20189_(), SFX.Event.Ritual.FAERIE_SUMMON, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
        if (this.updateMovement()) {
            ++this.growTicks;
            if (this.growTicks > maxGrowTicks && !this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                FaerieQueen efq = new FaerieQueen((EntityType<? extends Monster>)((EntityType)EntityInit.FAERIE_QUEEN.get()), this.m_9236_());
                efq.m_146884_(this.m_20182_().m_82492_(0.0, 1.0, 0.0));
                UUID casterUUID = this.getCasterUUID();
                Player player = null;
                if (casterUUID != null) {
                    player = this.m_9236_().m_46003_(casterUUID);
                }
                efq.setSummoner(player);
                this.m_9236_().m_7967_((Entity)efq);
            }
        } else if (this.m_9236_().m_5776_()) {
            float r = 0.25f;
            float r2 = r * 2.0f;
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_STATIONARY.get())), this.m_20185_() - (double)r + Math.random() * (double)r2, this.m_20186_() - (double)r + Math.random() * (double)r2, this.m_20189_() - (double)r + Math.random() * (double)r2, 0.0, 0.0, 0.0);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        double radius = 1.0;
        double velocity = 0.5;
        if (this.m_9236_().m_5776_()) {
            RandomSource random = this.m_9236_().m_213780_();
            for (int i = 0; i < 100; ++i) {
                Vec3 pos = new Vec3(random.m_188583_(), random.m_188583_(), random.m_188583_()).m_82541_();
                Vec3 vel = pos.m_82490_(velocity);
                pos = pos.m_82490_(radius);
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), this.m_20185_() + pos.f_82479_, this.m_20186_() + pos.f_82480_, this.m_20189_() + pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        }
    }

    private boolean updateMovement() {
        Vec3 me;
        Vec3 target = new Vec3((double)this.getTargetPos().m_123341_(), (double)this.getTargetPos().m_123342_(), (double)this.getTargetPos().m_123343_()).m_82520_(0.5, 0.0, 0.5);
        if (target.m_82554_(me = this.m_20182_()) < (double)0.2f || me.f_82480_ < target.f_82480_) {
            return true;
        }
        Vec3 diff = me.m_82546_(target);
        float radius = (float)diff.f_82480_ / 2.0f;
        this.angle = (float)((double)this.angle + 0.08726646324990228);
        Vec3 newPos = new Vec3(target.f_82479_ + (double)radius * Math.cos(this.angle), target.f_82480_ + diff.f_82480_ - (double)0.09f, target.f_82481_ + (double)radius * Math.sin(this.angle));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CASTER_UUID, (Object)"");
        this.f_19804_.m_135372_(TARGET_POSITION, (Object)this.m_20183_());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("caster")) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)compound.m_128461_("caster"));
        }
        if (compound.m_128441_("target_position")) {
            CompoundTag targetPos = compound.m_128469_("target_position");
            this.f_19804_.m_135381_(TARGET_POSITION, (Object)BlockPos.m_274561_((double)targetPos.m_128457_("x"), (double)targetPos.m_128457_("y"), (double)targetPos.m_128457_("z")));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("caster", (String)this.f_19804_.m_135370_(CASTER_UUID));
        CompoundTag targetPos = new CompoundTag();
        targetPos.m_128350_("x", (float)((BlockPos)this.f_19804_.m_135370_(TARGET_POSITION)).m_123341_());
        targetPos.m_128350_("y", (float)((BlockPos)this.f_19804_.m_135370_(TARGET_POSITION)).m_123342_());
        targetPos.m_128350_("z", (float)((BlockPos)this.f_19804_.m_135370_(TARGET_POSITION)).m_123343_());
        compound.m_128365_("target_position", (Tag)targetPos);
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.f_19804_.m_135370_(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(TARGET_POSITION);
    }

    public void setTargetPos(BlockPos target) {
        this.f_19804_.m_135381_(TARGET_POSITION, (Object)target);
    }

    public float getGrowthAmount() {
        return (float)this.growTicks / (float)maxGrowTicks;
    }
}

