/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.sorcery;

import com.mna.api.affinity.Affinity;
import com.mna.entities.renderers.sorcery.SpellProjectileRenderer;
import com.mna.entities.sorcery.targeting.Smite;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SmiteProjectileRenderer
extends EntityRenderer<Smite> {
    final Minecraft mc = Minecraft.m_91087_();

    public SmiteProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Smite entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!Minecraft.m_91087_().m_91104_()) {
            entityIn.spawnParticles(10, partialTicks);
        }
        ArrayList<Affinity> affs = entityIn.getAffinity();
        Affinity aff = Affinity.UNKNOWN;
        if (affs != null) {
            aff = affs.get(0);
        }
        int[] clr = aff.getColor();
        int[] sec = aff.getSecondaryColor();
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
        int override = entityIn.getOverrideColor();
        if (override != -1) {
            clr = new int[]{FastColor.ARGB32.m_13665_((int)override), FastColor.ARGB32.m_13667_((int)override), FastColor.ARGB32.m_13669_((int)override)};
            sec = clr;
        }
        switch (aff) {
            case ARCANE: {
                this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, sec);
                matrixStackIn.m_85837_(0.0, 0.0, 0.01);
                this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
                break;
            }
            case LIGHTNING: {
                break;
            }
            default: {
                this.renderWaterProjectile(entityIn, builder, matrixStackIn, packedLightIn, clr);
            }
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderWaterProjectile(Smite entityIn, VertexConsumer builder, PoseStack matrixStackIn, int packedLightIn, int[] color) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, SpellProjectileRenderer.model_water, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}, 0.75f);
        ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, SpellProjectileRenderer.model_water2, matrixStackIn, packedLightIn, OverlayTexture.f_118083_, new float[]{1.0f, 1.0f, 1.0f}, 0.5f);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(Smite entity) {
        return null;
    }
}

