/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction.util;

import com.mna.Registries;
import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.FactionRaidRegistry;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.tools.math.MathUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class FactionWar
extends Mob {
    public static final int MAXIMUM_STRENGTH = 300;
    public static final int MINIMUM_STRENGTH = 30;
    int strength_first = 0;
    int strength_second = 0;
    boolean calculatedStrength = false;
    IFaction first;
    IFaction second;

    public FactionWar(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public void m_8119_() {
        if (!this.calculatedStrength) {
            this.calculateStrength();
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.first == null || this.second == null || this.strength_first <= 0 && this.strength_second <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_9236_().m_46467_() % 10L != 0L) {
            return;
        }
        if (this.strength_first > 0) {
            this.strength_first = this.spawnRaidEntity(this.first, this.strength_first);
        }
        if (this.strength_second > 0) {
            this.strength_second = this.spawnRaidEntity(this.second, this.strength_second);
        }
    }

    public static boolean checkMonsterSpawnRules(EntityType<FactionWar> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && FactionWar.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    private int spawnRaidEntity(IFaction faction, int strength) {
        Pair<EntityType<? extends IFactionEnemy<? extends Mob>>, Integer> soldier = FactionRaidRegistry.getSoldier(faction, strength);
        if (soldier == null) {
            return 0;
        }
        IFactionEnemy entity = (IFactionEnemy)((EntityType)soldier.getFirst()).m_20615_(this.m_9236_());
        entity.setTier((Integer)soldier.getSecond());
        Vec3 spawnPos = this.m_20182_();
        for (int i = 0; i < 10; ++i) {
            BlockPos testSpawnPos = this.m_20183_().m_7918_((int)(-8.0 + Math.random() * 16.0), (int)(-8.0 + Math.random() * 16.0), (int)(-8.0 + Math.random() * 16.0));
            int adjustCount = 0;
            while (this.m_9236_().m_46859_(testSpawnPos) && adjustCount++ < 10) {
                testSpawnPos = testSpawnPos.m_7495_();
            }
            if (this.m_9236_().m_46859_(testSpawnPos)) continue;
            adjustCount = 0;
            while (!this.m_9236_().m_46859_(testSpawnPos) && adjustCount++ < 10) {
                testSpawnPos = testSpawnPos.m_7494_();
            }
            if (!this.m_9236_().m_46859_(testSpawnPos)) continue;
            spawnPos = Vec3.m_82539_((Vec3i)testSpawnPos);
            break;
        }
        LivingEntity living = (LivingEntity)entity;
        living.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 3));
        if (living.m_6336_() == MobType.f_21641_ && this.m_9236_().m_46461_()) {
            living.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SOAKED.get(), 300, 0));
        }
        this.m_9236_().m_7967_((Entity)entity);
        int entity_strength_rating = FactionRaidRegistry.getStrengthRating(faction, (EntityType<? extends IFactionEnemy<? extends Mob>>)((EntityType)soldier.getFirst()), (Integer)soldier.getSecond());
        if (entity_strength_rating == -1) {
            return 0;
        }
        return strength - entity_strength_rating;
    }

    private void calculateStrength() {
        this.calculatedStrength = true;
        MutableInt totalNearbyTier = new MutableInt(0);
        MutableInt totalNearbyLevel = new MutableInt(0);
        AABB bb = this.m_20191_().m_82400_(128.0);
        this.m_9236_().m_6907_().forEach(player -> {
            if (bb.m_82381_(player.m_20191_())) {
                player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> totalNearbyLevel.add(m.getMagicLevel()));
                player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> totalNearbyTier.add(p.getTier()));
            }
        });
        if (totalNearbyTier.getValue() == 0 || totalNearbyLevel.getValue() == 0) {
            this.strength_first = 0;
            this.strength_second = 0;
            return;
        }
        this.strength_first = totalNearbyLevel.getValue() / 3 * totalNearbyTier.getValue();
        this.strength_second = this.strength_first = MathUtils.clamp(this.strength_first, 30, 300);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.calculatedStrength) {
            this.calculateStrength();
            List<IFaction> allFactions = ManaAndArtificeMod.getFactionHelper().getAllFactions();
            this.first = allFactions.get((int)(Math.random() * (double)allFactions.size()));
            List<IFaction> otherFactions = ManaAndArtificeMod.getFactionHelper().getFactionsExcept(this.first);
            this.second = otherFactions.get((int)(Math.random() * (double)otherFactions.size()));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag pCompound) {
        this.strength_first = pCompound.m_128451_("strength_first");
        this.strength_second = pCompound.m_128451_("strength_second");
        if (pCompound.m_128441_("first") && pCompound.m_128441_("second")) {
            this.first = ManaAndArtificeMod.getFactionHelper().getFaction(new ResourceLocation(pCompound.m_128461_("first")));
            this.second = ManaAndArtificeMod.getFactionHelper().getFaction(new ResourceLocation(pCompound.m_128461_("second")));
            this.calculatedStrength = this.first != null && this.second != null;
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("strength_first", this.strength_first);
        pCompound.m_128405_("strength_second", this.strength_second);
        if (this.first != null) {
            pCompound.m_128359_("first", Registries.Factions.get().getKey((Object)this.first).toString());
        }
        if (this.second != null) {
            pCompound.m_128359_("second", Registries.Factions.get().getKey((Object)this.second).toString());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_142065_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_20254_(int pSeconds) {
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }
}

