/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction.util;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.entities.FactionRaidRegistry;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.FactionIDs;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.EntityInit;
import com.mna.factions.Factions;
import com.mna.tools.SummonUtils;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class FactionRaid
extends Entity {
    private static final EntityDataAccessor<String> FACTION = SynchedEntityData.m_135353_(FactionRaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Player player;
    private UUID playerUUID;
    private int strength;
    private boolean isProtective;
    private MobEffectInstance[] additionalEffects;
    private IFaction __cachedFaction;

    public FactionRaid(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FactionRaid(Level world, Player target, int strength) {
        super((EntityType)EntityInit.FACTION_RAID_ENTITY.get(), world);
        this.player = target;
        this.strength = strength;
    }

    public void setProtective(Player guard) {
        this.player = guard;
        this.isProtective = true;
    }

    public void setAdditionalEffects(MobEffectInstance[] effects) {
        this.additionalEffects = effects;
    }

    public void m_8119_() {
        IFaction faction;
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0 && !this.spawnRaidEntity()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_9236_().m_5776_()) {
            if (this.getFaction().is(FactionIDs.DEMONS)) {
                this.spawnDemonParticles();
            } else if (this.getFaction().is(FactionIDs.UNDEAD)) {
                this.spawnUndeadParticles();
            }
        } else if (this.f_19797_ == 20 && (faction = this.getFaction()) != null) {
            this.m_5496_(faction.getRaidSound(), 1.0f, 1.0f);
        }
    }

    private void spawnDemonParticles() {
        int i;
        for (i = 0; i < 15; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)-0.05f + Math.random() * (double)0.1f, (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() - 0.5 + Math.random() * 1.0, this.m_20186_(), this.m_20189_() - 0.5 + Math.random() * 1.0, 0.0, (double)0.05f, 0.0);
        for (i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123802_, this.m_20185_() - 1.5 + Math.random() * 3.0, this.m_20186_(), this.m_20189_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
    }

    private void spawnUndeadParticles() {
        int i;
        for (i = 0; i < 15; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)-0.05f + Math.random() * (double)0.1f, (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
        }
        for (i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BONE.get())), this.m_20185_() - 1.5 + Math.random() * 3.0, this.m_20186_(), this.m_20189_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
    }

    private Player getPlayer() {
        if (this.player == null && this.playerUUID != null) {
            this.player = this.m_9236_().m_46003_(this.playerUUID);
        }
        return this.player;
    }

    private boolean spawnRaidEntity() {
        if (this.getPlayer() == null) {
            return false;
        }
        Pair<EntityType<? extends IFactionEnemy<? extends Mob>>, Integer> soldier = FactionRaidRegistry.getSoldier(this.getFaction(), this.strength);
        if (soldier == null) {
            return false;
        }
        IFactionEnemy entity = (IFactionEnemy)((EntityType)soldier.getFirst()).m_20615_(this.m_9236_());
        if (!this.isProtective) {
            entity.setRaidTarget(this.getPlayer());
        } else {
            SummonUtils.setSummon((Mob)entity, (LivingEntity)this.player, 1200);
        }
        entity.setTier((Integer)soldier.getSecond());
        ((LivingEntity)entity).m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 3));
        if (this.additionalEffects != null) {
            for (MobEffectInstance inst : this.additionalEffects) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(inst.m_19544_(), inst.m_19557_(), inst.m_19564_(), inst.m_19571_(), inst.m_19572_(), inst.m_19575_()));
            }
        }
        this.m_9236_().m_7967_((Entity)entity);
        int entity_strength_rating = FactionRaidRegistry.getStrengthRating(this.getFaction(), (EntityType<? extends IFactionEnemy<? extends Mob>>)((EntityType)soldier.getFirst()), (Integer)soldier.getSecond());
        if (entity_strength_rating == -1) {
            return false;
        }
        this.strength -= entity_strength_rating;
        return this.strength > 0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FACTION, (Object)FactionIDs.COUNCIL.toString());
    }

    protected void m_7378_(CompoundTag compound) {
        ListTag nbt;
        if (compound.m_128441_("strength")) {
            this.strength = compound.m_128451_("strength");
        }
        if (compound.m_128441_("protecting")) {
            this.isProtective = compound.m_128471_("protecting");
        }
        if (compound.m_128441_("faction")) {
            this.f_19804_.m_135381_(FACTION, (Object)compound.m_128461_("faction"));
        }
        if (compound.m_128441_("afx") && (nbt = compound.m_128437_("afx", 10)) != null) {
            this.additionalEffects = new MobEffectInstance[nbt.size()];
            MutableInt idx = new MutableInt(0);
            nbt.forEach(n -> {
                this.additionalEffects[idx.intValue()] = MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)n));
            });
        }
        if (compound.m_128441_("target")) {
            try {
                this.playerUUID = UUID.fromString(compound.m_128461_("target"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load player UUID when loading faction raid.  Skipping and despawning the raid.");
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("strength", this.strength);
        compound.m_128359_("faction", (String)this.f_19804_.m_135370_(FACTION));
        compound.m_128379_("protecting", this.isProtective);
        if (this.additionalEffects != null) {
            ListTag afx = new ListTag();
            for (MobEffectInstance inst : this.additionalEffects) {
                CompoundTag instSaved = inst.m_19555_(new CompoundTag());
                afx.add((Object)instSaved);
            }
            compound.m_128365_("afx", (Tag)afx);
        }
        if (this.player != null) {
            compound.m_128359_("target", this.player.m_20148_().toString());
        }
    }

    public IFaction getFaction() {
        if (this.__cachedFaction == null) {
            ResourceLocation factionID = new ResourceLocation((String)this.f_19804_.m_135370_(FACTION));
            this.__cachedFaction = Factions.INSTANCE.getFaction(factionID);
        }
        return this.__cachedFaction;
    }

    public void setFaction(IFaction faction) {
        this.f_19804_.m_135381_(FACTION, (Object)Registries.Factions.get().getKey((Object)faction).toString());
    }

    public void setFaction(ResourceLocation factionID) {
        this.f_19804_.m_135381_(FACTION, (Object)factionID.toString());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (pKey == FACTION) {
            this.__cachedFaction = null;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

