/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.entities.faction.util.WitchHunterArrow;
import com.mna.entities.projectile.WitchhunterTrickshot;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.entities.sorcery.targeting.Smite;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class WitchHunter
extends BaseFactionMob<WitchHunter>
implements RangedAttackMob,
AnimationController.CustomKeyframeHandler<WitchHunter> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_TRICKSHOT = "trickshot";
    private static final int TRICKSHOT_CD = 200;
    private static final int ROLL_CD = 60;
    private boolean isAttacking = false;
    private boolean isTrickshotting = false;
    private boolean isRolling = false;
    private int trickshotCooldown = 0;
    private HashMap<String, Integer> trickshotCooldowns = new HashMap();
    private int rollCooldown = 0;
    private int nextTrickshotDuration = 200;
    private int nextTrickshotMagnitude = 200;
    private MobEffect nextTrickshotEffect = null;
    private boolean instantTransition = false;

    public WitchHunter(EntityType<WitchHunter> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        for (String e : this.trickshotCooldowns.keySet()) {
            this.trickshotCooldowns.put(e, this.trickshotCooldowns.get(e) - 1);
        }
        --this.trickshotCooldown;
        --this.rollCooldown;
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    @Override
    protected void addControllerListeners(AnimationController<WitchHunter> controller) {
        controller.setCustomInstructionKeyframeHandler((AnimationController.CustomKeyframeHandler)this);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        if (!this.isAttacking) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.run"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.idle"));
        }
        if (this.isTrickshotting) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.throw"));
        }
        if (this.isRolling) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.roll_short").thenLoop("animation.model.idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.shoot"));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DodgeGoal());
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(2, this, new TrickshotGoal((MobEffect)EffectInit.SILENCE.get(), 100, 0, 8.0f, 16.0f)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(1, this, new TrickshotGoal((MobEffect)EffectInit.MANA_STUNT.get(), 400, 4, 8.0f, 16.0f)));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(1, this, new TrickshotGoal(MobEffects.f_19602_, 1, 1, 8.0f, 16.0f)));
        this.f_21345_.m_25352_(3, (Goal)new FactionTierWrapperGoal(0, this, new TrickshotGoal(MobEffects.f_19597_, 160, 3, 1.0f, 16.0f)));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, p -> {
            IPlayerProgression progression;
            return !(p instanceof Player) || (progression = (IPlayerProgression)((Player)p).getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) == null || progression.getAlliedFaction() != Factions.COUNCIL && progression.getAlliedFaction() != null;
        }, 6.0f, this.m_21133_(Attributes.f_22279_), this.m_21133_(Attributes.f_22279_) * 1.5, EntitySelector.f_20406_::test));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, p -> {
            if (p instanceof IFactionEnemy && !SummonUtils.isSummon((Entity)this)) {
                return ((IFactionEnemy)p).getFaction() != Factions.COUNCIL;
            }
            return false;
        }, 6.0f, this.m_21133_(Attributes.f_22279_), this.m_21133_(Attributes.f_22279_) * 1.5, EntitySelector.f_20406_::test));
        this.f_21345_.m_25352_(4, (Goal)new ShootGoal(this, this.m_21133_(Attributes.f_22279_), 20, 30, 12.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, 10, true, false, e -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_DAMAGE, 10, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean spawnBolt(Entity target) {
        Vec3 direction = target == this ? Vec3.m_82503_((Vec2)this.m_20155_()).m_82541_() : target.m_20182_().m_82520_(0.0, (double)(target.m_20192_() / 2.0f), 0.0).m_82546_(this.m_20182_()).m_82541_();
        WitchHunterArrow arrow = new WitchHunterArrow(this.m_9236_(), this.m_20185_() + direction.f_82479_, this.m_20186_() + 1.0 + direction.f_82480_, this.m_20189_() + direction.f_82481_);
        arrow.m_5602_((Entity)this);
        arrow.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.6f, 0.0f);
        this.m_9236_().m_7967_((Entity)arrow);
        this.m_5496_(SoundEvents.f_11847_, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public void spawnTrickshot(MobEffect effect, int duration, int magnitude) {
        if (this.m_5448_() == null) {
            return;
        }
        WitchhunterTrickshot trick = new WitchhunterTrickshot(this.m_9236_(), this.m_20182_().m_82520_(0.0, 1.0, 0.0), this.m_5448_().m_20182_().m_82520_(0.0, 3.0, 0.0), effect, duration, magnitude);
        this.m_9236_().m_7967_((Entity)trick);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 20.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "damage": {
                    this.spawnBolt((Entity)entity);
                    break;
                }
                case "trickshot": {
                    this.spawnTrickshot(this.nextTrickshotEffect, this.nextTrickshotDuration, this.nextTrickshotMagnitude);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isAttacking = false;
            if (this.isTrickshotting) {
                this.isTrickshotting = false;
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(data));
                if (effect != null) {
                    this.trickshotCooldowns.put(data, 600);
                }
                this.trickshotCooldown = 200;
            } else if (this.isRolling) {
                this.isRolling = false;
                this.rollCooldown = 60;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void handle(CustomInstructionKeyframeEvent<WitchHunter> event) {
        if (event.getKeyframeData().getInstructions().contains("sound:woosh")) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Entity.Generic.WOOSH, SoundSource.HOSTILE, 0.05f, (float)(0.9 + Math.random() * 0.2), false);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isAttacking);
        nbt.m_128379_(INSTRUCTION_TRICKSHOT, this.isTrickshotting);
        nbt.m_128379_("roll", this.isRolling);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isAttacking = nbt.m_128471_("attacking");
        this.isTrickshotting = nbt.m_128471_(INSTRUCTION_TRICKSHOT);
        boolean wasRolling = this.isRolling;
        this.isRolling = nbt.m_128471_("roll");
        if (!this.isRolling && wasRolling) {
            this.instantTransition = true;
        }
    }

    public class DodgeGoal
    extends Goal {
        private Vec3 dodgeDirection;
        private Entity dodgeEntity;

        public DodgeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            if (WitchHunter.this.rollCooldown > 0) {
                return false;
            }
            Vec3 rt_startVec = WitchHunter.this.m_20182_();
            Vec3 thisFwd = Vec3.m_82503_((Vec2)WitchHunter.this.m_20155_());
            Vec3 rt_endVec = rt_startVec.m_82549_(thisFwd.m_82490_(10.0));
            List potentials = WitchHunter.this.m_9236_().m_45933_((Entity)WitchHunter.this, WitchHunter.this.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof SpellProjectile || e instanceof Smite || e instanceof ChanneledSpellEntity).filter(e -> {
                AABB axisalignedbb = e.m_20191_().m_82400_(2.0);
                Optional optional = axisalignedbb.m_82371_(rt_startVec, rt_endVec);
                return optional.isPresent();
            }).collect(Collectors.toList());
            if (potentials.size() == 0) {
                return false;
            }
            potentials.sort(new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    Double d1 = o1.m_20280_((Entity)WitchHunter.this);
                    Double d2 = o2.m_20280_((Entity)WitchHunter.this);
                    return d1.compareTo(d2);
                }
            });
            this.dodgeEntity = (Entity)potentials.get(0);
            Vec3 fwd = this.dodgeEntity.m_20184_();
            this.dodgeDirection = new Vec3(fwd.f_82479_, 0.0, fwd.f_82481_).m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            float angle = (float)(Math.acos(this.dodgeDirection.m_82526_(thisFwd.m_82541_())) * 180.0 / Math.PI);
            if (angle > 90.0f) {
                this.dodgeDirection.m_82490_(-1.0);
            }
            return true;
        }

        public void m_8056_() {
            WitchHunter.this.m_21573_().m_26573_();
            WitchHunter.this.isRolling = true;
            WitchHunter.this.isAttacking = true;
            WitchHunter.this.m_21563_().m_24950_(this.dodgeDirection.f_82479_, this.dodgeDirection.f_82480_, this.dodgeDirection.f_82481_, 30.0f, 30.0f);
            WitchHunter.this.m_20256_(this.dodgeDirection);
            DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 80, "", WitchHunter.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(WitchHunter.this);
        }

        public void m_8037_() {
            WitchHunter.this.m_21563_().m_24950_(this.dodgeDirection.f_82479_, this.dodgeDirection.f_82480_, this.dodgeDirection.f_82481_, 30.0f, 30.0f);
        }

        public boolean m_8045_() {
            return WitchHunter.this.isRolling;
        }

        protected EntityHitResult rayTraceEntity(Vec3 startVec, Vec3 endVec, float size, Entity searchEntity) {
            return ProjectileUtil.m_37304_((Level)WitchHunter.this.m_9236_(), (Entity)WitchHunter.this, (Vec3)startVec, (Vec3)endVec, (AABB)WitchHunter.this.m_20191_().m_82400_((double)size), entity -> searchEntity == entity);
        }
    }

    public class TrickshotGoal
    extends Goal {
        private MobEffect potionEffect;
        private int potionDuration;
        private int potionMagnitude;
        private float minDistance;
        private float maxDistance;
        private boolean startedAction;

        public TrickshotGoal(MobEffect effect, int duration, int magnitude, float minDistance, float maxDistance) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.potionEffect = effect;
            this.potionDuration = duration;
            this.potionMagnitude = magnitude;
            this.minDistance = minDistance * minDistance;
            this.maxDistance = maxDistance * maxDistance;
            this.startedAction = false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            return WitchHunter.this.trickshotCooldown <= 0 && WitchHunter.this.trickshotCooldowns.getOrDefault(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.potionEffect).toString(), 0) <= 0 && !WitchHunter.this.isTrickshotting && !WitchHunter.this.isRolling && WitchHunter.this.m_5448_() != null && !WitchHunter.this.m_5448_().m_21023_(this.potionEffect) && WitchHunter.this.m_20280_((Entity)WitchHunter.this.m_5448_()) >= (double)this.minDistance;
        }

        public void m_8056_() {
            this.startedAction = false;
        }

        public void m_8037_() {
            LivingEntity at = WitchHunter.this.m_5448_();
            if (at == null) {
                return;
            }
            if (!WitchHunter.this.isTrickshotting) {
                if (this.tryMove(at)) {
                    this.startAction();
                }
            } else {
                WitchHunter.this.m_21563_().m_24960_((Entity)at, 30.0f, 30.0f);
            }
        }

        private void startAction() {
            WitchHunter.this.m_21573_().m_26573_();
            WitchHunter.this.isTrickshotting = true;
            WitchHunter.this.isAttacking = true;
            WitchHunter.this.nextTrickshotDuration = this.potionDuration;
            WitchHunter.this.nextTrickshotMagnitude = this.potionMagnitude;
            WitchHunter.this.nextTrickshotEffect = this.potionEffect;
            DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(WitchHunter.INSTRUCTION_TRICKSHOT, 50, (LivingEntity)WitchHunter.this, WitchHunter.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(WitchHunter.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 100, ForgeRegistries.MOB_EFFECTS.getKey((Object)this.potionEffect).toString(), WitchHunter.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(WitchHunter.this);
            this.startedAction = true;
        }

        private boolean tryMove(LivingEntity at) {
            double distance = WitchHunter.this.m_20275_(at.m_20185_(), at.m_20186_(), at.m_20189_());
            boolean canSeeTarget = WitchHunter.this.m_21574_().m_148306_((Entity)at);
            if (distance <= (double)this.maxDistance && canSeeTarget) {
                WitchHunter.this.m_21573_().m_26573_();
                return true;
            }
            WitchHunter.this.m_21573_().m_5624_((Entity)at, WitchHunter.this.m_21133_(Attributes.f_22279_));
            WitchHunter.this.m_21563_().m_24960_((Entity)at, 30.0f, 30.0f);
            return false;
        }

        public boolean m_8045_() {
            return !this.startedAction || WitchHunter.this.isTrickshotting;
        }
    }

    public class ShootGoal
    extends Goal {
        private int rangedAttackTime = -1;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public ShootGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public ShootGoal(RangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = WitchHunter.this.m_5448_();
            return livingentity != null && livingentity.m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_() || !WitchHunter.this.m_21573_().m_26577_();
        }

        public void m_8041_() {
            this.rangedAttackTime = -1;
        }

        public void m_8037_() {
            LivingEntity e = WitchHunter.this.m_5448_();
            if (e == null) {
                return;
            }
            double distance = WitchHunter.this.m_20275_(e.m_20185_(), e.m_20186_(), e.m_20189_());
            boolean canSeeTarget = WitchHunter.this.m_21574_().m_148306_((Entity)e);
            if (distance <= (double)this.maxAttackDistance && canSeeTarget) {
                WitchHunter.this.m_21573_().m_26573_();
            } else {
                WitchHunter.this.m_21573_().m_5624_((Entity)e, WitchHunter.this.m_21133_(Attributes.f_22279_));
            }
            WitchHunter.this.m_21563_().m_24960_((Entity)e, 30.0f, 30.0f);
            int tier = MathUtils.clamp(WitchHunter.this.getTier() + 1, 1, 3);
            if (--this.rangedAttackTime == 0) {
                if (!canSeeTarget) {
                    return;
                }
                float f = Mth.m_14116_((float)((float)distance)) / this.attackRadius;
                float lvt_5_1_ = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                WitchHunter.this.m_6504_(e, lvt_5_1_);
                this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin)) / tier;
            } else if (this.rangedAttackTime < 0) {
                float f2 = Mth.m_14116_((float)((float)distance)) / this.attackRadius;
                this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin)) / tier;
            }
        }
    }
}

