/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.math.MathUtils;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HulkingZombie
extends BaseFactionMob<HulkingZombie> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_ROAR = "roar";
    private static final int LEAP_ATTACK_CD = 300;
    private static final int ROAR_CD = 300;
    private int leapAttackCooldown = 0;
    private int roarCooldown = 0;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean leftHandPunch = false;
    private boolean isLeapAttacking = false;
    private boolean isRoaring = false;

    public HulkingZombie(EntityType<HulkingZombie> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public float getStepHeight() {
        return 1.2f;
    }

    public HulkingZombie(Level worldIn) {
        this((EntityType<HulkingZombie>)((EntityType)EntityInit.HULKING_ZOMBIE.get()), worldIn);
    }

    public static boolean canSpawnPredicate(EntityType<HulkingZombie> p_234351_0_, LevelAccessor p_234351_1_, MobSpawnType p_234351_2_, BlockPos p_234351_3_, RandomSource p_234351_4_) {
        if (p_234351_1_ instanceof ServerLevelAccessor) {
            return p_234351_3_.m_123342_() <= 45 && Monster.m_219013_(p_234351_0_, (ServerLevelAccessor)((ServerLevelAccessor)p_234351_1_), (MobSpawnType)p_234351_2_, (BlockPos)p_234351_3_, (RandomSource)p_234351_4_);
        }
        return false;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        if (!this.isActing) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.hulking_zombie.run"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.hulking_zombie.idle"));
        }
        if (this.isLeapAttacking) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.hulking_zombie.ground_slam_loop"));
        }
        if (this.isRoaring) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.hulking_zombie.roar"));
        }
        if (this.leftHandPunch) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.hulking_zombie.punch_left"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.hulking_zombie.punch_right"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.leapAttackCooldown;
        --this.roarCooldown;
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    @Override
    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(1, this, new LerpLeap(16.0f, 1, 10)));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(2, this, new RoarGoal()));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public SoundEvent m_7515_() {
        return SFX.Entity.HulkingZombie.IDLE;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.HulkingZombie.DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SFX.Entity.HulkingZombie.HURT;
    }

    public void m_21011_(InteractionHand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isActing = true;
        this.isMeleeAttacking = true;
        this.leftHandPunch = Math.random() < 0.5;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.m_5496_(SFX.Entity.HulkingZombie.ATTACK, 1.0f, (float)(0.9 + Math.random() * 0.2));
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
        this.m_21011_(InteractionHand.MAIN_HAND, true);
        this.isMeleeAttacking = false;
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268419_)) {
            amount *= 0.75f;
        }
        return super.m_6469_(source, amount);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.m_5448_() == null) {
            return false;
        }
        double dist = this.m_20280_((Entity)this.m_5448_());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (this.isLeapAttacking) {
            f += 4.0f;
        }
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0 || this.m_6060_()) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                if (!this.leftHandPunch && this.getTier() > 0) {
                    ((LivingEntity)entityIn).m_5997_(0.0, 1.0, 0.0);
                }
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                this.m_21424_(playerentity, this.m_21205_(), playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.2f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_2_.m_41720_() instanceof AxeItem && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.8f);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                    break;
                }
                case "roar": {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false));
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, false, false));
                    this.m_7292_(new MobEffectInstance((MobEffect)EffectInit.ENLARGE.get(), 200, 4, false, false));
                    this.m_5496_(SFX.Entity.HulkingZombie.ROAR, 1.0f, 1.0f);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isActing = false;
            if (this.isLeapAttacking) {
                this.leapAttackCooldown = 20;
                this.isLeapAttacking = false;
            } else if (this.isRoaring) {
                this.roarCooldown = 300;
                this.isRoaring = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isActing);
        nbt.m_128379_("leap_attacking", this.isLeapAttacking);
        nbt.m_128379_("left_hand_punch", this.leftHandPunch);
        nbt.m_128379_("roaring", this.isRoaring);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isActing = nbt.m_128471_("attacking");
        this.isLeapAttacking = nbt.m_128471_("leap_attacking");
        this.leftHandPunch = nbt.m_128471_("left_hand_punch");
        this.isRoaring = nbt.m_128471_("roaring");
    }

    public class LerpLeap
    extends Goal {
        private float maxDist;
        private int lerpTicks;
        private int initialDelay;
        private int lerpCount = 0;
        private Vec3 start;
        private Vec3 end;
        private Vec3 control_1;
        private Vec3 control_2;

        public LerpLeap(float maxDist, int initialDelay, int lerpTime) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.maxDist = maxDist;
            this.lerpTicks = lerpTime;
            this.initialDelay = initialDelay;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            LivingEntity livingentity;
            if (HulkingZombie.this.m_5448_() == null || !HulkingZombie.this.m_6084_() || !HulkingZombie.this.m_5448_().m_6084_() || HulkingZombie.this.leapAttackCooldown > 0) {
                return false;
            }
            double dist = HulkingZombie.this.m_20280_((Entity)HulkingZombie.this.m_5448_());
            return dist >= 4.0 && dist <= (double)(this.maxDist * this.maxDist) && (livingentity = HulkingZombie.this.m_5448_()) != null && livingentity.m_6084_() && (livingentity instanceof FlyingMob || livingentity.f_19812_ || !livingentity.m_20096_() || livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35935_) && this.getEntityHeightOffGround(livingentity) > 2.0f;
        }

        private float getEntityHeightOffGround(LivingEntity living) {
            BlockPos livingPos = living.m_20183_();
            int count = 0;
            while (count < 10 && living.m_9236_().m_46859_(livingPos)) {
                ++count;
                livingPos = livingPos.m_7495_();
            }
            return count;
        }

        public void m_8041_() {
            this.lerpCount = 0;
            HulkingZombie.this.m_20242_(false);
            HulkingZombie.this.isActing = false;
            HulkingZombie.this.isLeapAttacking = false;
            ServerMessageDispatcher.sendEntityStateMessage(HulkingZombie.this);
        }

        public boolean m_8045_() {
            return HulkingZombie.this.m_5448_() != null && this.lerpCount < this.lerpTicks + this.initialDelay;
        }

        public void m_8056_() {
            HulkingZombie.this.m_20242_(true);
            HulkingZombie.this.m_21573_().m_26573_();
            HulkingZombie.this.m_20256_(Vec3.f_82478_);
            HulkingZombie.this.isActing = true;
            HulkingZombie.this.isLeapAttacking = true;
            ServerMessageDispatcher.sendEntityStateMessage(HulkingZombie.this);
        }

        public void m_8037_() {
            if (HulkingZombie.this.m_5448_() == null) {
                return;
            }
            LivingEntity ent = HulkingZombie.this.m_5448_();
            float lerpPct = (float)(this.lerpCount++ - this.initialDelay) / (float)this.lerpTicks;
            if (this.lerpCount == this.initialDelay) {
                this.start = HulkingZombie.this.m_20182_();
                HulkingZombie.this.m_5496_(SFX.Entity.HulkingZombie.LEAP, 1.0f, (float)(0.9 + Math.random() * 0.2));
            }
            if (this.lerpCount > this.initialDelay && this.lerpCount - this.initialDelay <= this.lerpTicks) {
                Vec3 direction = ent.m_20182_().m_82546_(this.start).m_82541_();
                this.end = ent.m_20182_().m_82549_(ent.m_20184_()).m_82546_(direction);
                Vec3 difference = this.end.m_82546_(this.start);
                this.control_1 = this.start.m_82549_(difference.m_82490_(0.3)).m_82520_(0.0, 1.0, 0.0);
                this.control_2 = this.start.m_82549_(difference.m_82490_(0.6)).m_82520_(0.0, 1.0, 0.0);
                Vec3 position = MathUtils.bezierVector3d(this.start, this.end, this.control_1, this.control_2, lerpPct);
                HulkingZombie.this.m_7618_(EntityAnchorArgument.Anchor.FEET, ent.m_20182_());
                HulkingZombie.this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                if (this.lerpCount - this.initialDelay == this.lerpTicks) {
                    HulkingZombie.this.leapAttackCooldown = 300;
                    double dist = HulkingZombie.this.m_20280_((Entity)ent);
                    if (dist < 16.0) {
                        HulkingZombie.this.damageEntity((Entity)ent);
                        ent.m_7292_(new MobEffectInstance((MobEffect)EffectInit.GRAVITY_WELL.get(), 20));
                    }
                }
            }
        }
    }

    public class RoarGoal
    extends Goal {
        public RoarGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return HulkingZombie.this.roarCooldown <= 0 && HulkingZombie.this.m_5448_() != null && HulkingZombie.this.m_21223_() < HulkingZombie.this.m_21233_() * 0.75f && !HulkingZombie.this.m_21023_(MobEffects.f_19596_) && !HulkingZombie.this.m_21023_(MobEffects.f_19606_) && !HulkingZombie.this.m_21023_(MobEffects.f_19600_) && !HulkingZombie.this.isActing;
        }

        public void m_8056_() {
            HulkingZombie.this.m_21573_().m_26573_();
            HulkingZombie.this.isRoaring = true;
            HulkingZombie.this.isActing = true;
            DelayedEventQueue.pushEvent(HulkingZombie.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(HulkingZombie.INSTRUCTION_ROAR, 20, (LivingEntity)HulkingZombie.this, HulkingZombie.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(HulkingZombie.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", HulkingZombie.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(HulkingZombie.this);
        }

        public boolean m_8045_() {
            return HulkingZombie.this.isRoaring;
        }
    }
}

