/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.EntityInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.ai.LerpLeap;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DemonImp
extends BaseFactionMob<DemonImp> {
    private static final int ACTION_LEAP = 1000;

    public DemonImp(EntityType<DemonImp> type, Level worldIn) {
        super(type, worldIn);
    }

    public DemonImp(Level worldIn) {
        this((EntityType<DemonImp>)((EntityType)EntityInit.DEMON_IMP.get()), worldIn);
    }

    public static boolean canSpawnPredicate(EntityType<DemonImp> mobType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && levelAccessor.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50451_;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.getAction() != Action.IDLE) {
            block0 : switch (this.getAction()) {
                case ATTACKING: {
                    switch (this.getAttackAction()) {
                        case LEFT: {
                            builder.thenPlay("animation.model.swipe_left");
                            break block0;
                        }
                        case RIGHT: {
                            builder.thenPlay("animation.model.swipe_right");
                            break block0;
                        }
                    }
                    builder.thenPlay("animation.model.bite");
                    break;
                }
                case LEAP_START: {
                    builder.thenPlay("animation.model.leap_start");
                    break;
                }
                case LEAPING: {
                    builder.thenPlay("animation.model.leap_loop");
                    break;
                }
                case LEAP_LANDING: {
                    builder.thenPlay("animation.model.leap_land");
                    break;
                }
            }
        }
        if (builder.getAnimationStages().size() == 0) {
            double movementSpeed = this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_();
            if (movementSpeed > 0.1) {
                builder.thenLoop("animation.model.run");
            } else if (movementSpeed > 0.02) {
                builder.thenLoop("animation.model.walk");
            } else {
                builder.thenLoop("animation.model.idle");
            }
        }
        return state.setAndContinue(builder);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), -0.5 + this.m_20185_() + Math.random(), this.m_20186_() + Math.random() * (double)this.m_20192_(), -0.5 + this.m_20189_() + Math.random(), this.m_20184_().f_82479_, (double)0.1f, this.m_20184_().f_82481_);
            }
        }
    }

    @Override
    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    private AttackAction getAttackAction() {
        int ordinal = (this.getStateFlag() & 0xFFFF) >> 12 & 0xF;
        if (ordinal >= AttackAction.values().length) {
            return AttackAction.NONE;
        }
        return AttackAction.values()[ordinal];
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    private void setAttackAction(AttackAction action) {
        int ordinal = (action.ordinal() & 0xF) << 12;
        int flag = this.getStateFlag();
        flag &= 0xFFFF0FFF;
        this.setState(flag |= ordinal);
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.getAction() != Action.IDLE) {
            return false;
        }
        ArrayList<AttackAction> actionPool = new ArrayList<AttackAction>();
        actionPool.add(AttackAction.LEFT);
        actionPool.add(AttackAction.RIGHT);
        actionPool.add(AttackAction.BITE);
        AttackAction selected = (AttackAction)((Object)actionPool.get((int)((double)actionPool.size() * Math.random())));
        this.setAction(Action.ATTACKING);
        this.setAttackAction(selected);
        this.setTimer("", selected.animLength, () -> {
            this.damageEntity(entityIn);
            this.m_5496_(SFX.Entity.Imp.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
        });
        this.setTimer("resetattack", selected.resetTime, () -> {
            this.setAttackAction(AttackAction.NONE);
            this.setAction(Action.IDLE);
        });
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.m_5496_(SFX.Entity.Imp.ATTACK, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(1, this, new LerpLeap<DemonImp>(this, 10, 3, t -> this.m_5448_() != null && !this.isOnCooldown(1000) && this.m_20270_((Entity)this.m_5448_()) > 8.0f, e -> {
            switch (e) {
                case DAMAGE: {
                    this.setAction(Action.LEAP_LANDING);
                    if (this.m_5448_() == null) break;
                    this.damageEntity((Entity)this.m_5448_());
                    break;
                }
                case LEAP: {
                    this.setAction(Action.LEAPING);
                    break;
                }
                case START: {
                    this.setAction(Action.LEAP_START);
                    this.m_5496_(SFX.Entity.Imp.LEAP, 1.0f, 1.0f);
                    break;
                }
                case STOP: {
                    this.setAction(Action.IDLE);
                    this.setCooldown(1000, 300);
                    break;
                }
            }
        }).setLeapSpeed(4.0f).setEndWaitTicks(4)));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    @Override
    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_() && cause.m_7639_() instanceof LivingEntity && this.tier >= 3) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public SoundEvent m_7515_() {
        return SFX.Entity.Imp.IDLE;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.Imp.DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SFX.Entity.Imp.ATTACK;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268419_) || source.m_269533_(DamageTypeTags.f_268725_)) {
            amount *= 0.5f;
        }
        amount = this.applyDamageResists(source, amount);
        return super.m_6469_(source, amount);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.m_5448_() == null) {
            return false;
        }
        double dist = this.m_20280_((Entity)this.m_5448_());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (this.getAction() == Action.LEAP_LANDING) {
            f += 4.0f;
        }
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                this.m_21424_(playerentity, this.m_21205_(), playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.2f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_2_.m_41720_() instanceof AxeItem && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
    }

    public static enum Action {
        IDLE,
        ATTACKING,
        LEAP_START,
        LEAPING,
        LEAP_LANDING;

    }

    public static enum AttackAction {
        NONE(0, 0),
        LEFT(10, 14),
        RIGHT(10, 14),
        BITE(10, 14);

        public final int animLength;
        public final int resetTime;

        private AttackAction(int animLength, int resetTime) {
            this.animLength = animLength;
            this.resetTime = resetTime;
        }
    }
}

