/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.animated;

import com.google.common.collect.Maps;
import com.mna.ManaAndArtifice;
import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.construct.Animations;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.FluidParameterRegistry;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructFleeTarget;
import com.mna.api.entities.construct.ai.ConstructTask;
import com.mna.api.events.construct.ConstructSprayEffectEvent;
import com.mna.api.events.construct.ConstructSprayTargetingEvent;
import com.mna.api.items.DynamicItemFilter;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.IAnimPacketSync;
import com.mna.entities.ai.LerpLeap;
import com.mna.entities.attributes.AttributeInit;
import com.mna.entities.constructs.ai.ConstructCollectItems;
import com.mna.entities.constructs.ai.ConstructCommandFollowAndGuard;
import com.mna.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.mna.entities.constructs.ai.ConstructCommandReturnToTable;
import com.mna.entities.constructs.ai.ConstructDuel;
import com.mna.entities.constructs.ai.ConstructMove;
import com.mna.entities.constructs.ai.base.ConstructDoorInteractGoal;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.entities.constructs.animated.ConstructConstruction;
import com.mna.entities.constructs.animated.ConstructDiagnostics;
import com.mna.entities.constructs.animated.ConstructMoodlets;
import com.mna.entities.constructs.movement.ConstructMoveControl;
import com.mna.entities.constructs.movement.ConstructPathNavigator;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.items.ItemInit;
import com.mna.items.constructs.parts.arms.ConstructPartAxeArmLeft;
import com.mna.items.constructs.parts.arms.ConstructPartAxeArmRight;
import com.mna.items.constructs.parts.arms.ConstructPartBladeArmLeft;
import com.mna.items.constructs.parts.arms.ConstructPartBladeArmRight;
import com.mna.items.constructs.parts.arms.ConstructPartFluidNozzleLeft;
import com.mna.items.constructs.parts.arms.ConstructPartFluidNozzleRight;
import com.mna.items.constructs.parts.arms.ConstructPartHammerArmLeft;
import com.mna.items.constructs.parts.arms.ConstructPartHammerArmRight;
import com.mna.items.constructs.parts.arms.ConstructPartManaCannonLeft;
import com.mna.items.constructs.parts.arms.ConstructPartManaCannonRight;
import com.mna.items.constructs.parts.head.ConstructPartHornHead;
import com.mna.network.ClientMessageDispatcher;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.to_client.SpawnParticleEffectMessage;
import com.mna.particles.types.movers.ParticleVelocityMover;
import com.mna.spells.SpellCaster;
import com.mna.spells.components.ComponentFling;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.EntityUtil;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Construct
extends AbstractGolem
implements IAnimPacketSync<Construct>,
GeoEntity,
AnimationController.CustomKeyframeHandler<Construct>,
PlayerRideableJumping,
IFluidHandler,
IConstruct<Construct>,
IItemHandlerModifiable,
OwnableEntity {
    private static final String NBT_OWNER = "owner";
    private static final float PART_DROP_CHANCE = 0.85f;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> MANA = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAX_MANA = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BUOYANCY = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STEERABLE = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> FLUIDTYPE = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> FLUIDAMT = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLUID_CAP = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AWAY_TYPE = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> FISHING_POS = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> FORCED_ANIMATION = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FORCED_ANIMATION_IDLE_ONLY = SynchedEntityData.m_135353_(Construct.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int COOLDOWN_HAMMER_LEAP = 0;
    private static final int COOLDOWN_AXE_LEAP = 0;
    private static final int COOLDOWN_DUAL_SHOT = 0;
    public static final int AWAY_TYPE_NONE = 0;
    public static final int AWAY_TYPE_MINING = 1;
    public static final int AWAY_TYPE_ADVENTURING = 2;
    public static final int AWAY_TYPE_HUNTING = 3;
    public static final float REQUIRED_INTELLIGENCE_FOR_PLAYER_LOOT = 36.0f;
    public static final float REQUIRED_PERCEPTION_FOR_PLAYER_LOOT = 28.0f;
    IConstructConstruction constructCapabilities;
    ConstructDiagnostics constructDiagnostics;
    private boolean needsSync = true;
    private boolean requestingDiagnostics = false;
    private Player cached_owner;
    protected AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean constructJumping;
    private ConstructMoodlets moodlets;
    private NonNullList<ItemStack> inventory;
    private String cached_team_name;
    private final Map<Integer, Integer> cooldowns = Maps.newHashMap();
    private ConstructAITask<?> current;
    private Animations forcedAnimation;
    private boolean forcedAnimationIdleOnly;
    private static final float MANA_PER_RANGED_ATTACK = 50.0f;
    private static final int FLUID_PER_RANGED_ATTACK = 20;
    private static final float FLUID_SPRAY_RANGE = 10.0f;
    private int chargeCounter = 0;
    private int attackDelay = 0;
    protected float jumpPower;
    private int hornDelay = 0;
    private double lastYd;
    private Fluid __cachedFluid = Fluids.f_76191_;
    private boolean clearAnimCache;
    public final float yaw_rnd;
    public final float pitch_rnd;
    public final float roll_rnd;
    private boolean dancing = false;
    private int danceTicks = 0;
    private int danceIndex = 0;
    private int defeatedCounter = 0;
    private ISpellDefinition currentSpell;
    private boolean ANIM_PACKET = false;
    private int actionFlags = 0;
    private boolean adventure_leave_pfx = false;
    private boolean adventure_return_pfx = false;
    private boolean mine_leave_pfx = false;
    private boolean mine_return_pfx = false;
    private int pfxCounter = 0;
    private boolean redirectingDamage = false;

    public Construct(EntityType<? extends AbstractGolem> type, Level worldIn) {
        super(type, worldIn);
        this.constructCapabilities = new ConstructConstruction();
        this.constructDiagnostics = new ConstructDiagnostics();
        this.moodlets = new ConstructMoodlets();
        this.inventory = NonNullList.m_182647_((int)0);
        this.f_21342_ = new ConstructMoveControl(this, 85, 10, 1.0f, 1.0f, true);
        this.yaw_rnd = worldIn.f_46441_.m_188501_() * 360.0f;
        this.pitch_rnd = -2.0f + worldIn.f_46441_.m_188501_() * 4.0f;
        this.roll_rnd = -2.0f + worldIn.f_46441_.m_188501_() * 4.0f;
    }

    public Construct(Level worldIn) {
        this((EntityType<? extends AbstractGolem>)((EntityType)EntityInit.ANIMATED_CONSTRUCT.get()), worldIn);
    }

    private void recalculateAll() {
        if (this.constructCapabilities != null) {
            int i;
            this.m_21051_(Attributes.f_22276_).m_22100_((double)this.constructCapabilities.calculateMaxHealth());
            this.m_21051_(Attributes.f_22279_).m_22100_((double)this.constructCapabilities.calculateSpeed());
            this.m_21051_(Attributes.f_22280_).m_22100_(this.canFly() ? 1.0 : (double)this.constructCapabilities.calculateSpeed());
            this.m_21051_(Attributes.f_22281_).m_22100_((double)this.constructCapabilities.calculateDamage());
            this.m_21051_(Attributes.f_22283_).m_22100_((double)this.constructCapabilities.calculateAttackRate());
            this.m_21051_(Attributes.f_22282_).m_22100_((double)this.constructCapabilities.calculateKnockback());
            this.m_21051_(Attributes.f_22278_).m_22100_((double)this.constructCapabilities.calculateKnockbackResistance());
            this.m_21051_(Attributes.f_22284_).m_22100_((double)this.constructCapabilities.calculateArmor());
            this.m_21051_(Attributes.f_22285_).m_22100_((double)this.constructCapabilities.calculateToughness());
            this.m_21051_(Attributes.f_22277_).m_22100_(32.0);
            this.m_21051_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).m_22100_((double)this.constructCapabilities.calculatePerception());
            this.m_21051_((Attribute)AttributeInit.INTELLIGENCE.get()).m_22100_((double)this.constructCapabilities.calculateIntelligence());
            this.m_21051_((Attribute)AttributeInit.RANGED_DAMAGE.get()).m_22100_((double)this.constructCapabilities.calculateRangedDamage());
            this.f_19804_.m_135381_(MAX_MANA, (Object)Float.valueOf(this.constructCapabilities.calculateMana()));
            this.f_19804_.m_135381_(BUOYANCY, (Object)Float.valueOf(this.constructCapabilities.calculateBuoyancy()));
            this.f_19804_.m_135381_(FLUID_CAP, (Object)this.constructCapabilities.calculateFluidCapacity());
            this.f_21344_.m_7008_(this.canSwim());
            if (this.f_21344_ instanceof ConstructPathNavigator) {
                ((ConstructPathNavigator)this.f_21344_).setEvaluatorFlags(this.canFly(), this.canSwim());
                if (this.canSwim()) {
                    this.m_21441_(BlockPathTypes.WATER, 8.0f);
                    this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
                } else {
                    this.m_21441_(BlockPathTypes.WATER, 16.0f);
                    this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
                }
            }
            int inventorySize = this.constructCapabilities.calculateInventorySize();
            NonNullList newInv = NonNullList.m_182647_((int)inventorySize);
            for (i = 0; i < inventorySize; ++i) {
                newInv.add(i, (Object)ItemStack.f_41583_);
            }
            for (i = 0; i < Math.min(this.inventory.size(), newInv.size()); ++i) {
                newInv.set(i, (Object)((ItemStack)this.inventory.get(i)).m_41777_());
            }
            this.inventory = newInv;
            if (this.canSwim()) {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_((double)this.constructCapabilities.calculateSpeed());
            }
            this.registerHammerLeap();
            this.registerAxeLeap();
        }
    }

    public void setConstructParts(@Nonnull ItemStack head, @Nonnull ItemStack torso, @Nonnull ItemStack left_arm, @Nonnull ItemStack right_arm, @Nonnull ItemStack legs) {
        this.constructCapabilities.setPart(head, false);
        this.constructCapabilities.setPart(torso, false);
        this.constructCapabilities.setPart(left_arm, false);
        this.constructCapabilities.setPart(right_arm, false);
        this.constructCapabilities.setPart(legs, true);
        this.recalculateAll();
    }

    public void setConstructParts(IConstructConstruction construction) {
        this.constructCapabilities = construction.copy();
        this.recalculateAll();
    }

    protected PathNavigation m_6037_(Level world) {
        return new ConstructPathNavigator(this, world);
    }

    public void m_8119_() {
        if (this.f_19794_) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        this.cooldowns.keySet().forEach(c -> {
            int cd = this.cooldowns.get(c);
            if (cd > 0) {
                this.cooldowns.put((Integer)c, cd - 1);
            }
        });
        super.m_8119_();
        this.m_21203_();
        this.moodlets.tick();
        if (this.hornDelay > 0) {
            --this.hornDelay;
        }
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (this.defeatedCounter > 0) {
            --this.defeatedCounter;
            if (this.m_9236_().m_46467_() % 5L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.defeatedCounter == 15) {
                this.actionFlags = ActionFlags.DEFEATED.clear(this.actionFlags);
                this.actionFlags = ActionFlags.DEFEATED_END.set(this.actionFlags);
            } else if (this.defeatedCounter == 1) {
                this.resetActions();
                this.m_21557_(false);
            }
        }
        if (!ManaAndArtifice.instance.proxy.checkConstructDanceMixPlaying()) {
            if (this.dancing) {
                this.dancing = false;
                this.danceTicks = 0;
                this.getMoodlets().clearMoodlet(8);
            }
        } else {
            this.dancing = true;
            this.setHappy(10000);
            ++this.danceTicks;
            if (this.danceTicks % 200 == 0) {
                this.danceIndex = (int)(Math.random() * 3.0);
            }
        }
        if (this.f_19797_ % 40 == 0) {
            int numWickerParts;
            int totalParts;
            int numWoodParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.WOOD).size();
            int numBoneParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.BONE).size();
            this.m_5634_(1.0f + 0.5f * (float)(numWoodParts + numBoneParts));
            if (!this.m_9236_().m_5776_() && this.m_9236_().m_6042_().f_63857_() && (totalParts = numWoodParts + (numWickerParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.WICKERWOOD).size())) > 1) {
                this.m_20254_(totalParts * 5);
            }
        }
        Player owner = this.getOwner();
        if (this.m_21223_() < this.m_21233_() * 0.25f || owner != null && this.m_21574_().m_148306_((Entity)owner) && owner.m_21223_() < owner.m_21233_() * 0.25f) {
            this.setConcerned(250);
        } else {
            this.getMoodlets().clearMoodlet(2);
        }
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (this.m_9236_().m_5776_()) {
            if (this.mine_leave_pfx) {
                this.spawnMineLeaveParticles();
            } else if (this.mine_return_pfx) {
                this.spawnMineReturnParticles();
            } else if (this.adventure_leave_pfx) {
                this.spawnAdventureLeaveParticles();
            } else if (this.adventure_return_pfx) {
                this.spawnAdventureReturnParticles();
            }
            this.spawnSmoothParticles(ManaAndArtifice.instance.proxy.getPartialTick());
            if (!ActionFlags.MINE_ENTER.isFlagSet(this.actionFlags)) {
                this.mine_leave_pfx = false;
            }
            if (!ActionFlags.MINE_LEAVE.isFlagSet(this.actionFlags)) {
                this.mine_return_pfx = false;
            }
            if (!ActionFlags.ADVENTURE_ENTER.isFlagSet(this.actionFlags)) {
                this.adventure_leave_pfx = false;
            }
            if (!ActionFlags.ADVENTURE_LEAVE.isFlagSet(this.actionFlags)) {
                this.adventure_return_pfx = false;
            }
            if (ActionFlags.EAT.isFlagSet(this.actionFlags) && ManaAndArtifice.instance.proxy.getGameTicks() % 5L == 0L) {
                this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, this.m_5720_(), 1.0f, 1.0f);
            }
            if (this.canFly() && !this.m_20096_() && !this.isAway() && !ActionFlags.ADVENTURE_LEAVE.isFlagSet(this.actionFlags)) {
                this.spawnRocketParticles();
            }
        }
        if (this.needsSync) {
            this.needsSync = false;
            if (!this.m_9236_().m_5776_()) {
                ServerMessageDispatcher.sendEntityStateMessage(this);
            } else {
                ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, false);
            }
        }
        if (this.m_9236_().m_5776_() && this.requestingDiagnostics && (this.f_19797_ % 20 == 0 || this.getDiagnostics().needsUpdate())) {
            ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, true);
        }
    }

    protected void m_8024_() {
        if (!this.m_9236_().m_5776_() && this.getCurrentCommand() != null && this.getCurrentCommand().isFinished() && this.getCurrentCommand().isOneOff()) {
            ConstructCommandFollowAndGuard cmd = (ConstructCommandFollowAndGuard)ConstructTasks.FOLLOW_DEFEND.instantiateTask(this);
            UUID follow = this.getCurrentCommand().getOneOffFollowTarget();
            Player followTarget = follow != null ? this.m_9236_().m_46003_(follow) : this.getOwner();
            cmd.setFollowTarget((LivingEntity)followTarget);
            this.setCurrentCommand(followTarget, cmd, true);
        }
        super.m_8024_();
    }

    public void m_6818_(BlockPos position, boolean playing) {
        if (playing && !this.dancing) {
            this.dancing = true;
            this.danceTicks = 0;
            this.setHappy(10000);
        } else if (!playing) {
            this.dancing = false;
            this.getMoodlets().clearMoodlet(8);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.canRiderInteract()) {
                if (this.m_20069_() && (double)this.getWaterLevelAbove() - this.m_20186_() > (double)0.2f) {
                    if (this.m_5842_()) {
                        if (this.m_20184_().m_7098_() < 0.0) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(0.01f * this.getBuoyancy()), 0.0));
                        }
                    } else {
                        double depth = this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get());
                        float yCap = depth > 0.25 || this.f_19862_ ? 0.05f : 0.001f;
                        Vec3 newDelta = this.m_20184_().m_82520_(0.0, 0.01 * (double)this.getBuoyancy(), 0.0);
                        if (newDelta.f_82480_ > (double)yCap) {
                            newDelta = new Vec3(newDelta.f_82479_, (double)yCap, newDelta.f_82481_);
                        }
                        this.m_20256_(newDelta);
                    }
                    this.lastYd = 0.0;
                }
                LivingEntity livingentity = this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.jumpPower > 0.0f && !this.isJumping() && this.m_20096_()) {
                    double d0 = this.getJumpStrength() * (double)this.jumpPower * (double)this.m_20098_();
                    double d1 = this.m_21023_(MobEffects.f_19603_) ? d0 + (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f) : d0;
                    float horizontalScale = 1.8f;
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_ * (double)horizontalScale, d1, vector3d.f_82481_ * (double)horizontalScale);
                    this.m_6862_(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                if (this.m_6109_()) {
                    if (!this.m_20096_()) {
                        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.05f);
                    } else {
                        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.35f);
                    }
                    super.m_7023_(new Vec3((double)f, travelVector.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.jumpPower = 0.0f;
                    this.m_6862_(false);
                }
                this.m_267651_(false);
            } else {
                this.jumpPower = 0.02f;
                super.m_7023_(travelVector);
            }
        }
    }

    protected float m_274460_() {
        return this.m_6688_() instanceof Player ? this.m_6113_() * 0.1f : 0.04f;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        this.setRiderPosition(pPassenger, pCallback);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.m_20184_().f_82480_;
        super.m_7840_(y, onGroundIn, state, pos);
    }

    public Vec3 m_21074_(Vec3 deltaMovement, float pFriction) {
        float frictionInfluencedSpeed = this.m_20096_() ? this.m_6113_() * (0.21600002f / (pFriction * pFriction * pFriction)) : this.m_274460_();
        this.m_19920_(frictionInfluencedSpeed, deltaMovement);
        this.m_20256_(this.m_21297_(this.m_20184_()));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if ((this.f_19862_ || this.f_20899_) && (this.m_6147_() || this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this))) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3;
    }

    private Vec3 m_21297_(Vec3 p_21298_) {
        if (this.m_6147_()) {
            this.m_183634_();
            double d0 = Mth.m_14008_((double)p_21298_.f_82479_, (double)-0.15f, (double)0.15f);
            double d1 = Mth.m_14008_((double)p_21298_.f_82481_, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(p_21298_.f_82480_, (double)-0.15f);
            p_21298_ = new Vec3(d0, d2, d1);
        }
        return p_21298_;
    }

    public float getStepHeight() {
        return 1.5f;
    }

    public boolean isAway() {
        return ActionFlags.AWAY.isFlagSet(this.actionFlags);
    }

    public int getAwayType() {
        return (Integer)this.f_19804_.m_135370_(AWAY_TYPE);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity p_20303_) {
        if (this.isAway()) {
            return false;
        }
        if (p_20303_ instanceof Player) {
            if (this.playerCanCommand((Player)p_20303_)) {
                return false;
            }
            return this.current instanceof ConstructCommandFollowAndGuard;
        }
        return false;
    }

    public void m_7334_(Entity pEntity) {
        if (this.isAway()) {
            return;
        }
        super.m_7334_(pEntity);
    }

    public void m_5997_(double pX, double pY, double pZ) {
        if (this.isAway()) {
            return;
        }
        super.m_5997_(pX, pY, pZ);
    }

    public float m_6108_() {
        return this.canSwim() ? 0.98f : super.m_6108_();
    }

    public boolean m_6129_() {
        if (((Float)this.f_19804_.m_135370_(BUOYANCY)).floatValue() < 0.0f) {
            return false;
        }
        return super.m_6129_();
    }

    public void jumpInFluid(FluidType type) {
        if (this.canFly() && this.m_20069_()) {
            this.m_6135_();
        }
        super.jumpInFluid(type);
    }

    protected float m_6118_() {
        if (this.canFly() && this.m_20069_()) {
            return 0.12f * this.m_20098_();
        }
        return 0.42f * this.m_20098_();
    }

    protected boolean m_7310_(Entity entityIn) {
        if (this.isAway() || ActionFlags.MINE_ENTER.isFlagSet(this.actionFlags) || ActionFlags.MINE_LEAVE.isFlagSet(this.actionFlags) || ActionFlags.ADVENTURE_ENTER.isFlagSet(this.actionFlags) || ActionFlags.ADVENTURE_LEAVE.isFlagSet(this.actionFlags)) {
            return false;
        }
        if (this.m_20197_().size() != 0) {
            return false;
        }
        if (entityIn instanceof Player) {
            return this.getConstructData().isCapabilityEnabled(ConstructCapability.CARRY_PLAYER) && this.playerCanCommand((Player)entityIn);
        }
        return false;
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 p_30562_, LivingEntity p_30563_) {
        double d0 = this.m_20185_() + p_30562_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_30562_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_30563_.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB aabb = p_30563_.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)p_30563_, (AABB)aabb.m_82383_(vec3))) {
                        p_30563_.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity p_30576_) {
        Vec3 vec3 = Construct.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, p_30576_);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = Construct.m_19903_((double)this.m_20205_(), (double)p_30576_.m_20205_(), (float)(this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, p_30576_);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return ((Float)this.f_19804_.m_135370_(BUOYANCY)).floatValue() >= 1.0f;
    }

    public boolean canRiderInteract() {
        return (Boolean)this.f_19804_.m_135370_(STEERABLE);
    }

    public boolean m_6094_() {
        if (this.isAway()) {
            return false;
        }
        return !this.m_20160_();
    }

    public boolean m_6063_() {
        if (this.isAway()) {
            return false;
        }
        return this.getConstructData().getAffinityScore(Affinity.WATER) < 4;
    }

    protected boolean m_6107_() {
        if (this.isAway()) {
            return false;
        }
        return super.m_6107_() && this.m_20160_();
    }

    public boolean m_7132_() {
        return true;
    }

    public double m_6048_() {
        float actualScale;
        double output = 0.75;
        if (this.canSwim()) {
            BlockPos bp = this.m_20183_();
            FluidState flState = this.m_9236_().m_6425_(bp);
            FluidState flStateBelow = this.m_9236_().m_6425_(bp.m_7495_());
            if ((double)flState.m_76182_() > 0.8 || (double)flStateBelow.m_76182_() > 0.8) {
                return -0.5;
            }
        }
        if ((actualScale = this.getPersistentData().m_128457_("mna_entity_scale")) < 1.0f) {
            return output - (double)(0.21f / actualScale);
        }
        return output + (double)(actualScale - 1.0f);
    }

    public boolean isJumping() {
        return this.constructJumping;
    }

    public double getJumpStrength() {
        return 1.25;
    }

    @Override
    @Nullable
    public Player getOwner() {
        if (this.f_19804_.m_135370_(OWNER_UUID) == null || !((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            return null;
        }
        if (this.cached_owner == null || !this.cached_owner.m_6084_()) {
            this.cached_owner = this.m_9236_().m_46003_((UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get());
        }
        return this.cached_owner;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        if (this.f_19804_.m_135370_(OWNER_UUID) == null || !((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            return null;
        }
        return (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get();
    }

    public String m_6302_() {
        Player owner;
        if (this.cached_team_name == null) {
            this.cached_team_name = super.m_6302_();
        }
        if ((owner = this.getOwner()) != null) {
            this.cached_team_name = owner.m_6302_();
        }
        return this.cached_team_name;
    }

    @Override
    public ConstructAITask<?> getCurrentCommand() {
        return this.current;
    }

    @Override
    public int getCarrySize() {
        return Math.max(1, 2 * this.constructCapabilities.getAffinityScore(Affinity.ENDER));
    }

    @Override
    public int getIntelligence() {
        return (int)this.m_21051_((Attribute)AttributeInit.INTELLIGENCE.get()).m_22135_();
    }

    @Override
    public InteractionHand[] getEmptyHands() {
        ArrayList emptyHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                emptyHands.add(InteractionHand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                emptyHands.add(InteractionHand.OFF_HAND);
            }
        });
        return emptyHands.toArray(new InteractionHand[0]);
    }

    @Override
    public InteractionHand[] getCarryingHands() {
        return this.getCarryingHands((Predicate<ItemStack>)null);
    }

    @Override
    public InteractionHand[] getCarryingHands(Predicate<ItemStack> filter) {
        ArrayList carryingHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            ItemStack left;
            if (p.getModelTypeMutex() == 1 && !(left = this.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (filter == null || filter.test(left))) {
                carryingHands.add(InteractionHand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            ItemStack right;
            if (p.getModelTypeMutex() == 1 && !(right = this.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && (filter == null || filter.test(right))) {
                carryingHands.add(InteractionHand.OFF_HAND);
            }
        });
        return carryingHands.toArray(new InteractionHand[0]);
    }

    @Override
    public InteractionHand[] getCarryingHands(DynamicItemFilter filter) {
        return this.getCarryingHands((ItemStack is) -> filter.matches((ItemStack)is));
    }

    @Override
    public boolean hasItem(DynamicItemFilter _filter) {
        InteractionHand[] hands = this.getCarryingHands((ItemStack is) -> _filter.matches((ItemStack)is));
        if (hands.length > 0) {
            return true;
        }
        return InventoryUtilities.hasStackInInventory(_filter, (IItemHandler)this);
    }

    @Override
    public boolean hasItem(ItemStack stack, boolean checkDurability, boolean compareNBT) {
        InteractionHand[] hands = this.getCarryingHands((ItemStack is) -> {
            if (checkDurability && is.m_41773_() != stack.m_41773_()) {
                return false;
            }
            if (compareNBT && !ManaAndArtificeMod.getItemHelper().AreTagsEqual((ItemStack)is, stack)) {
                return false;
            }
            return is.m_41720_() == stack.m_41720_();
        });
        if (hands.length > 0) {
            return true;
        }
        return InventoryUtilities.hasStackInInventory(stack, checkDurability, compareNBT, (IItemHandler)this);
    }

    @Override
    public boolean hasItem(ResourceLocation tag, int quantity) {
        List<Item> items = MATags.getItemTagContents(tag);
        if (items.size() == 0) {
            return false;
        }
        int count = 0;
        ItemStack stack = this.m_21120_(InteractionHand.MAIN_HAND);
        if (items.contains(stack.m_41720_())) {
            count += stack.m_41613_();
        }
        if (items.contains((stack = this.m_21120_(InteractionHand.OFF_HAND)).m_41720_())) {
            count += stack.m_41613_();
        }
        if (count >= quantity) {
            return true;
        }
        if (!this.constructCapabilities.areCapabilitiesEnabled(ConstructCapability.ITEM_STORAGE)) {
            return false;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            stack = this.getStackInSlot(i);
            if (!items.contains(stack.m_41720_()) || (count += stack.m_41613_()) < quantity) continue;
            return true;
        }
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_21254_() {
        return this.getConstructData().isCapabilityEnabled(ConstructCapability.BLOCK) && !this.f_20911_;
    }

    public void onShieldBlock() {
        this.attackDelay -= 20;
    }

    @Override
    public IConstructConstruction getConstructData() {
        return this.constructCapabilities;
    }

    public boolean canSwim() {
        return ((Float)this.f_19804_.m_135370_(BUOYANCY)).floatValue() >= 1.0f;
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        if (this.ANIM_PACKET) {
            nbt.m_128344_("anim", (byte)1);
            if (this.f_20912_ != null) {
                nbt.m_128344_("hand", (byte)this.f_20912_.ordinal());
            }
            nbt.m_128405_("actionFlags", this.actionFlags);
            nbt.m_128405_("defeatedCounter", this.defeatedCounter);
        } else if (!this.requestingDiagnostics) {
            this.constructCapabilities.WriteNBT(nbt);
        } else {
            if (this.constructDiagnostics.needsUpdate()) {
                nbt.m_128365_("diag", (Tag)this.constructDiagnostics.writeToNBT());
            }
            nbt.m_128365_("inv", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inventory));
            nbt.m_128365_("hat", (Tag)this.constructCapabilities.getHat().m_41739_(new CompoundTag()));
            nbt.m_128365_("banner", (Tag)this.constructCapabilities.getBanner().m_41739_(new CompoundTag()));
        }
        this.moodlets.writeToNBT(nbt);
        return nbt;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    @Override
    public ConstructDiagnostics getDiagnostics() {
        return this.constructDiagnostics;
    }

    @Override
    public Optional<InteractionHand> getHandWithCapability(ConstructCapability capability) {
        ArrayList hands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(InteractionHand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(InteractionHand.OFF_HAND);
            }
        });
        if (hands.size() > 0) {
            Random r = new Random();
            InteractionHand h = (InteractionHand)hands.get(r.nextInt(hands.size()));
            return Optional.of(h);
        }
        return Optional.empty();
    }

    public boolean handHasCapability(InteractionHand hand, ConstructCapability capability) {
        Optional<Object> part = Optional.empty();
        part = hand == InteractionHand.MAIN_HAND ? this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM) : this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM);
        if (!part.isPresent()) {
            return false;
        }
        return Arrays.asList(((ItemConstructPart)part.get()).getEnabledCapabilities()).contains((Object)capability);
    }

    @Override
    public boolean canManaCannonAttack() {
        return this.getMana() >= 50.0f && this.getConstructData().areCapabilitiesEnabled(ConstructCapability.RANGED_ATTACK, ConstructCapability.STORE_MANA) && this.m_5448_() != null;
    }

    @Override
    public boolean canFluidSpray() {
        boolean baseline;
        boolean bl = baseline = this.getStoredFluidAmount() >= 20 && this.getConstructData().areCapabilitiesEnabled(ConstructCapability.FLUID_STORE, ConstructCapability.FLUID_DISPENSE);
        return baseline && FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).checkPredicate((Entity)this.m_5448_(), SummonUtils.isTargetFriendly((Entity)this.m_5448_(), (LivingEntity)this.getOwner()), this);
    }

    @Override
    public boolean canDualSweep() {
        if (this.getIntelligence() < 16) {
            return false;
        }
        Optional<ItemConstructPart> leftArm = this.getConstructData().getPart(ConstructSlot.LEFT_ARM);
        Optional<ItemConstructPart> rightArm = this.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
        return leftArm.isPresent() && rightArm.isPresent() && leftArm.get() instanceof ConstructPartBladeArmLeft && rightArm.get() instanceof ConstructPartBladeArmRight;
    }

    @Override
    public boolean expandFluidRange() {
        if (this.getIntelligence() < 16) {
            return false;
        }
        Optional<ItemConstructPart> leftArm = this.getConstructData().getPart(ConstructSlot.LEFT_ARM);
        Optional<ItemConstructPart> rightArm = this.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
        return leftArm.isPresent() && rightArm.isPresent() && leftArm.get() instanceof ConstructPartFluidNozzleLeft && rightArm.get() instanceof ConstructPartFluidNozzleRight;
    }

    @Override
    public Optional<LivingEntity> getDualCannonTarget() {
        if (this.m_5448_() == null || this.getIntelligence() < 16 || this.isOnCooldown(0)) {
            return Optional.empty();
        }
        if (this.getMana() < 100.0f) {
            return Optional.empty();
        }
        Optional<ItemConstructPart> leftArm = this.getConstructData().getPart(ConstructSlot.LEFT_ARM);
        Optional<ItemConstructPart> rightArm = this.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
        if (leftArm.isPresent() && rightArm.isPresent() && leftArm.get() instanceof ConstructPartManaCannonLeft && rightArm.get() instanceof ConstructPartManaCannonRight) {
            return this.m_9236_().m_6249_((Entity)this, this.m_5448_().m_20191_().m_82400_(6.0), e -> e != this.m_5448_() && e.m_6084_() && e instanceof LivingEntity && this.m_21574_().m_148306_(e) && !this.m_7307_((Entity)e)).stream().map(e -> (LivingEntity)e).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public boolean canSpellCast() {
        ISpellDefinition[] spells = this.getCastableSpells();
        if (spells.length == 0) {
            return false;
        }
        float minManaCost = Float.MAX_VALUE;
        for (ISpellDefinition spell : spells) {
            if (!(spell.getManaCost() < minManaCost)) continue;
            minManaCost = spell.getManaCost();
        }
        return this.getMana() >= minManaCost && this.getConstructData().areCapabilitiesEnabled(ConstructCapability.STORE_MANA, ConstructCapability.CAST_SPELL);
    }

    @Override
    public ISpellDefinition[] getCastableSpells() {
        return this.getConstructData().getCastableSpells();
    }

    @Override
    public float getMaxMana() {
        return ((Float)this.f_19804_.m_135370_(MAX_MANA)).floatValue();
    }

    @Override
    public boolean isFishing() {
        return ActionFlags.FISH.isFlagSet(this.actionFlags);
    }

    @Override
    public boolean isRangedAttacking() {
        return ActionFlags.RANGED_ATTACK.isFlagSet(this.actionFlags);
    }

    @Override
    public float getMana() {
        return ((Float)this.f_19804_.m_135370_(MANA)).floatValue();
    }

    @Override
    public float getManaPct() {
        if (this.getMaxMana() == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp01(this.getMana() / Math.max(this.getMaxMana(), 1.0f));
    }

    public float getBuoyancy() {
        return ((Float)this.f_19804_.m_135370_(BUOYANCY)).floatValue();
    }

    public float getWaterLevelAbove() {
        AABB axisalignedbb = this.m_20191_();
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82292_);
        int l = Mth.m_14165_((double)(axisalignedbb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutable);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.m_123342_() + f;
        }
        return l + 1;
    }

    public ConstructMoodlets getMoodlets() {
        return this.moodlets;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance inst) {
        if (inst.m_19544_() == MobEffects.f_19615_ || inst.m_19544_() == MobEffects.f_19594_ || inst.m_19544_() == MobEffects.f_19614_ || inst.m_19544_() == MobEffects.f_19615_ || inst.m_19544_() == MobEffects.f_19612_ || inst.m_19544_() == EffectInit.ASPHYXIATE.get() || inst.m_19544_() == EffectInit.CHOOSING_WELLSPRING.get() || inst.m_19544_() == EffectInit.CHRONO_ANCHOR.get() || inst.m_19544_() == EffectInit.COLD_DARK.get() || inst.m_19544_() == EffectInit.ELDRIN_FLIGHT.get() || inst.m_19544_() == EffectInit.LIFT.get() || inst.m_19544_() == EffectInit.MIST_FORM.get() || inst.m_19544_() == EffectInit.WELLSPRING_SIGHT.get() || inst.m_19544_() == EffectInit.EARTHQUAKE.get() || inst.m_19544_() == EffectInit.LACERATE.get() || inst.m_19544_() == EffectInit.SOAR.get() || inst.m_19544_() == EffectInit.SPIDER_CLIMBING.get()) {
            return false;
        }
        return super.m_7301_(inst);
    }

    @Nullable
    public BlockPos getFishingTarget() {
        return (BlockPos)this.f_19804_.m_135370_(FISHING_POS);
    }

    public boolean canFly() {
        if (this.constructCapabilities == null) {
            return false;
        }
        return this.constructCapabilities.isCapabilityEnabled(ConstructCapability.FLY);
    }

    public boolean m_7066_(ItemStack stack) {
        if (!this.m_21531_()) {
            return false;
        }
        return InventoryUtilities.hasRoomFor((IItemHandler)this, stack);
    }

    public boolean isRenderDisabled() {
        return this.isAway();
    }

    public boolean playerCanCommand(Player player) {
        if (player == null) {
            return false;
        }
        if (((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent() && !((UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get()).equals(player.m_20148_())) {
            return this.m_7307_((Entity)player);
        }
        return true;
    }

    @Override
    public boolean isDefeated() {
        return this.defeatedCounter > 0;
    }

    @Override
    public boolean isDueling() {
        return this.f_21345_.m_25386_().anyMatch(g -> {
            Optional<ConstructAITask<?>> cur;
            return g.m_26015_() instanceof ConstructCommandFollowLodestar && (cur = ((ConstructCommandFollowLodestar)g.m_26015_()).currentCommand()).isPresent() && cur.get() instanceof ConstructDuel;
        });
    }

    @Override
    public int getAttackDelay() {
        return this.attackDelay;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected boolean isOnCooldown(int id) {
        return this.cooldowns.getOrDefault(id, 0) > 0;
    }

    protected void setCooldown(int id, int ticks) {
        this.cooldowns.put(id, ticks);
    }

    @Override
    public void setHat(ItemStack stack) {
        ItemStack curHat = this.constructCapabilities.getHat();
        if (!curHat.m_41619_() && !this.m_9236_().m_5776_()) {
            ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), curHat);
            this.m_9236_().m_7967_((Entity)item);
        }
        this.constructCapabilities.setHat(stack);
        this.setHappy(200);
        this.needsSync = true;
    }

    @Override
    public void setBanner(ItemStack stack) {
        this.constructCapabilities.setBanner(stack);
        this.needsSync = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7888_(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public void setOwner(UUID playerID) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.of(playerID));
    }

    @Override
    public boolean setCurrentCommand(Player player, ConstructAITask<?> cmd) {
        return this.setCurrentCommand(player, cmd, false);
    }

    public boolean setCurrentCommand(Player player, ConstructAITask<?> cmd, boolean skipOwnershipCheck) {
        if (!skipOwnershipCheck && !this.playerCanCommand(player)) {
            this.pushDiagnosticMessage(Component.m_237110_((String)"mna.constructs.feedback.notowner", (Object[])new Object[]{player != null ? player.m_5446_().getString() : "UNKNOWN"}).getString(), null);
            return false;
        }
        if (cmd == null) {
            return false;
        }
        if (this.current != null) {
            this.current.m_8041_();
            this.f_21345_.m_25363_(this.current);
        }
        this.resetActions();
        Construct myCommand = cmd.duplicate();
        if (cmd.isOneOff()) {
            ((ConstructAITask)((Object)myCommand)).setOneOff(player);
        }
        ((ConstructAITask)((Object)myCommand)).setConstruct(this);
        ((ConstructAITask)((Object)myCommand)).copyConnections(cmd);
        ((ConstructAITask)((Object)myCommand)).onTaskSet();
        this.current = myCommand;
        this.f_21345_.m_25352_(4, myCommand);
        if (this.current != null && this.current.allowSteeringMountedConstructsDuringTask()) {
            this.f_19804_.m_135381_(STEERABLE, (Object)true);
        } else {
            this.f_19804_.m_135381_(STEERABLE, (Object)false);
        }
        return true;
    }

    public void setRequestingDiagnostics(boolean requesting) {
        this.requestingDiagnostics = requesting;
    }

    public void m_6862_(boolean jumping) {
        this.constructJumping = jumping;
        this.f_20899_ = jumping;
    }

    public void adjustMana(float amount) {
        float mana = this.getMana();
        if ((mana += amount) > this.getMaxMana()) {
            mana = this.getMaxMana();
        }
        this.f_19804_.m_135381_(MANA, (Object)Float.valueOf(mana));
    }

    @Override
    public void setMining(boolean mining) {
        if (mining) {
            this.m_20153_();
            this.actionFlags = ActionFlags.MINE_ENTER.set(this.actionFlags);
            this.actionFlags = ActionFlags.MINE_LEAVE.clear(this.actionFlags);
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("away", 120, true, this::setAwayCallback));
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("flag", 60, true, (s, b) -> this.f_19804_.m_135381_(AWAY_TYPE, (Object)1)));
        } else {
            this.actionFlags = ActionFlags.MINE_ENTER.clear(this.actionFlags);
            this.actionFlags = ActionFlags.MINE_LEAVE.set(this.actionFlags);
            this.setAwayCallback("away", false);
        }
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void setAdventuring(boolean adventuring) {
        if (adventuring) {
            this.m_20153_();
            this.actionFlags = ActionFlags.ADVENTURE_ENTER.set(this.actionFlags);
            this.actionFlags = ActionFlags.ADVENTURE_LEAVE.clear(this.actionFlags);
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("away", 140, true, this::setAwayCallback));
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("flag", 100, true, (s, b) -> this.f_19804_.m_135381_(AWAY_TYPE, (Object)2)));
        } else {
            this.actionFlags = ActionFlags.ADVENTURE_ENTER.clear(this.actionFlags);
            this.actionFlags = ActionFlags.ADVENTURE_LEAVE.set(this.actionFlags);
            this.setAwayCallback("away", false);
        }
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void setHunting(boolean hunting) {
        if (hunting) {
            this.m_20153_();
            this.actionFlags = ActionFlags.ADVENTURE_ENTER.set(this.actionFlags);
            this.actionFlags = ActionFlags.ADVENTURE_LEAVE.clear(this.actionFlags);
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("away", 140, true, this::setAwayCallback));
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Boolean>("flag", 100, true, (s, b) -> this.f_19804_.m_135381_(AWAY_TYPE, (Object)3)));
        } else {
            this.actionFlags = ActionFlags.ADVENTURE_ENTER.clear(this.actionFlags);
            this.actionFlags = ActionFlags.ADVENTURE_LEAVE.set(this.actionFlags);
            this.setAwayCallback("away", false);
        }
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    public void setAwayCallback(String identifier, boolean away) {
        if (away) {
            this.m_20153_();
            this.actionFlags = ActionFlags.AWAY.set(this.actionFlags);
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
        } else {
            this.actionFlags = ActionFlags.AWAY.clear(this.actionFlags);
            this.f_19804_.m_135381_(AWAY_TYPE, (Object)0);
        }
    }

    protected void m_6138_() {
        if (this.isAway()) {
            return;
        }
        super.m_6138_();
    }

    @Override
    public void setWatering() {
        if (!ActionFlags.WATER.isFlagSet(this.actionFlags)) {
            this.actionFlags = ActionFlags.WATER.set(this.actionFlags);
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
        }
    }

    @Override
    public void resetActions() {
        this.actionFlags = 0;
        this.f_19804_.m_135381_(AWAY_TYPE, (Object)0);
        if (!this.m_9236_().m_5776_()) {
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
        }
    }

    public void m_6710_(LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null && !this.m_9236_().m_5776_()) {
            this.resetAttackState();
        }
        if (entitylivingbaseIn == this) {
            return;
        }
        if (entitylivingbaseIn != null && entitylivingbaseIn == this.getOwner() && !FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).checkPredicate((Entity)entitylivingbaseIn, true, this)) {
            return;
        }
        if (entitylivingbaseIn == null) {
            this.getMoodlets().clearMoodlet(1);
            this.needsSync = true;
        } else if (SummonUtils.isTargetFriendly((Entity)entitylivingbaseIn, (LivingEntity)this.getOwner())) {
            this.setConcerned(9999);
        } else {
            this.setAngry(9999);
        }
        super.m_6710_(entitylivingbaseIn);
    }

    @Override
    public void setHappy(int strength) {
        this.moodlets.addMoodlet(8, strength);
        this.needsSync = true;
    }

    @Override
    public void setAngry(int strength) {
        this.moodlets.addMoodlet(1, strength);
        this.needsSync = true;
    }

    @Override
    public void setConcerned(int strength) {
        this.moodlets.addMoodlet(2, strength);
        this.needsSync = true;
    }

    @Override
    public void setConfused(int strength) {
        this.moodlets.addMoodlet(4, strength);
        this.needsSync = true;
    }

    @Override
    public void setUnimpressed(int strength) {
        this.moodlets.addMoodlet(32, strength);
        this.needsSync = true;
    }

    @Override
    public void setFishing(BlockPos pos) {
        this.f_19804_.m_135381_(FISHING_POS, (Object)pos);
        this.actionFlags = ActionFlags.FISH.set(this.actionFlags);
        Optional<InteractionHand> fishHand = this.getHandWithCapability(ConstructCapability.FISH);
        if (fishHand.isPresent()) {
            this.f_20912_ = fishHand.get();
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(SoundEvents.f_11941_, 1.0f, 1.0f);
        }
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), pSound, this.m_5720_(), pVolume, pPitch, false);
        } else {
            this.m_9236_().m_5594_(null, this.m_20183_(), pSound, this.m_5720_(), pVolume, pPitch);
        }
    }

    @Override
    public void setEating(InteractionHand hand) {
        this.actionFlags = ActionFlags.EAT.set(this.actionFlags);
        this.f_20912_ = hand;
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void stopFishing() {
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(SoundEvents.f_11939_, 1.0f, 1.0f);
        }
        this.actionFlags = ActionFlags.FISH.clear(this.actionFlags);
        this.actionFlags = ActionFlags.FISH_END.set(this.actionFlags);
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void setDefeated(int duration) {
        this.f_21345_.m_25386_().forEach(g -> {
            if (g.m_26015_() instanceof ConstructDuel) {
                ((ConstructDuel)g.m_26015_()).forceFail();
            }
        });
        this.m_21557_(true);
        this.m_6710_(null);
        this.defeatedCounter = duration;
        this.actionFlags = ActionFlags.DEFEATED.set(this.actionFlags);
        this.moodlets.addMoodlet(4, duration);
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void setDualSweeping() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.actionFlags = ActionFlags.DUAL_SWEEP.set(this.actionFlags);
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    @Override
    public void forceAnimation(Animations animation, boolean onlyWhenIdle) {
        this.forcedAnimation = animation;
        this.forcedAnimationIdleOnly = onlyWhenIdle;
        this.f_19804_.m_135381_(FORCED_ANIMATION, (Object)animation.ordinal());
        this.f_19804_.m_135381_(FORCED_ANIMATION_IDLE_ONLY, (Object)onlyWhenIdle);
    }

    @Override
    public void clearForcedAnimation() {
        this.f_19804_.m_135381_(FORCED_ANIMATION, (Object)-1);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public void spawnRocketParticles() {
        Vec3 jitter;
        int i;
        Vec3 particleVelocity;
        double speed = this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_();
        Vec3 particlePosition = this.m_20182_().m_82520_(0.0, (double)0.025f, 0.0);
        Vec3 forward = this.m_20156_();
        Vec3 offset = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_((double)0.3f);
        if (speed > (double)0.1f && this.m_20184_().f_82480_ < speed / 4.0) {
            particleVelocity = this.m_20184_().m_82490_(-1.0);
            particlePosition = particlePosition.m_82520_(-forward.f_82479_ * (double)0.7f, 0.55, -forward.f_82481_ * (double)0.7f);
        } else {
            particleVelocity = new Vec3(0.0, (double)-0.05f, 0.0);
        }
        MAParticleType particleType = (MAParticleType)((Object)ParticleInit.FLAME.get());
        float particleScale = 0.15f;
        if (this.m_20069_()) {
            particleType = (MAParticleType)((Object)ParticleInit.WATER.get());
            particleScale = 0.05f;
        }
        Vec3i color = new Vec3i(10, 30, 65);
        if (this.constructCapabilities.getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.FLY) == ConstructMaterial.OBSIDIAN) {
            color = new Vec3i(170, 60, 10);
        }
        int numParticles = 2;
        for (i = 0; i < numParticles; ++i) {
            jitter = new Vec3(this.m_9236_().m_213780_().m_188583_(), 0.0, this.m_9236_().m_213780_().m_188583_()).m_82541_().m_82490_((double)0.0125f);
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType(particleType).setColor(color.m_123341_(), color.m_123342_(), color.m_123343_()).setScale(particleScale), particlePosition.f_82479_ + offset.f_82479_ + jitter.f_82479_ * 3.0, particlePosition.f_82480_, particlePosition.f_82481_ + offset.f_82481_ + jitter.f_82481_ * 3.0, particleVelocity.f_82479_ + jitter.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_ + jitter.f_82481_);
        }
        for (i = 0; i < numParticles; ++i) {
            jitter = new Vec3(this.m_9236_().m_213780_().m_188583_(), 0.0, this.m_9236_().m_213780_().m_188583_()).m_82541_().m_82490_((double)0.0125f);
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType(particleType).setColor(color.m_123341_(), color.m_123342_(), color.m_123343_()).setScale(particleScale), particlePosition.f_82479_ - offset.f_82479_ + jitter.f_82479_ * 3.0, particlePosition.f_82480_, particlePosition.f_82481_ - offset.f_82481_ + jitter.f_82481_ * 3.0, particleVelocity.f_82479_ + jitter.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_ + jitter.f_82481_);
        }
    }

    public void spawnMineReturnParticles() {
        BlockState bp = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if (bp.m_60795_()) {
            return;
        }
        Vec3 feetPos = this.m_20182_();
        for (int i = 0; i < 20; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(new ItemStack((ItemLike)bp.m_60734_())).setMover(new ParticleVelocityMover(-0.2 + Math.random() * 0.4, 0.2f, -0.2 + Math.random() * 0.4, true)).setGravity(0.05f), feetPos.f_82479_ - 0.5 + Math.random(), feetPos.f_82480_, feetPos.f_82481_ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public void spawnMineLeaveParticles() {
        BlockState bp = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if (bp.m_60795_()) {
            return;
        }
        Vec3 feetPos = this.m_20182_();
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(new ItemStack((ItemLike)bp.m_60734_())).setMover(new ParticleVelocityMover(-0.2 + Math.random() * 0.4, 0.2f, -0.2 + Math.random() * 0.4, true)).setGravity(0.05f), feetPos.f_82479_ - 0.5 + Math.random(), feetPos.f_82480_, feetPos.f_82481_ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public void spawnAdventureLeaveParticles() {
        ++this.pfxCounter;
        Vec3 fwd = this.m_20156_();
        Vec3 feetPos = this.m_20182_().m_82549_(fwd.m_82490_((double)this.pfxCounter));
        if (this.pfxCounter > 25) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            Vec3 particleOffset = fwd.m_82490_(Math.random());
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.COZY_SMOKE.get())), feetPos.f_82479_ + particleOffset.f_82479_, feetPos.f_82480_ + particleOffset.f_82480_, feetPos.f_82481_ + particleOffset.f_82481_, 0.0, 0.02, 0.0);
        }
    }

    public void spawnAdventureReturnParticles() {
        ++this.pfxCounter;
        Vec3 fwd = this.m_20156_();
        Vec3 feetPos = this.m_20182_().m_82549_(fwd.m_82490_((double)Math.min(-25 + this.pfxCounter, 0)));
        if (this.pfxCounter > 25) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            Vec3 particleOffset = fwd.m_82490_(Math.random());
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.COZY_SMOKE.get())), feetPos.f_82479_ + particleOffset.f_82479_, feetPos.f_82480_ + particleOffset.f_82480_, feetPos.f_82481_ + particleOffset.f_82481_, 0.0, 0.02, 0.0);
        }
    }

    public void m_7199_(int jumpPower) {
    }

    public void m_8012_() {
    }

    private void setRiderPosition(Entity entity, Entity.MoveFunction callback) {
        if (this.m_20363_(entity)) {
            Vec3 fwd = Vec3.m_82503_((Vec2)this.m_20155_()).m_82541_().m_82490_(-0.25);
            double d0 = this.m_20186_() + this.m_6048_();
            callback.m_20372_(entity, this.m_20185_() + fwd.f_82479_, d0, this.m_20189_() + fwd.f_82481_);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (offHand.m_41720_() == ItemInit.BELL_OF_BIDDING.get() || mainHand.m_41720_() == ItemInit.BELL_OF_BIDDING.get() || offHand.m_41720_() == ItemInit.__DEBUG.get() || mainHand.m_41720_() == ItemInit.__DEBUG.get()) {
            return InteractionResult.PASS;
        }
        if (mainHand.m_41720_() instanceof BannerItem) {
            this.getConstructData().setBanner(mainHand);
            return InteractionResult.m_19078_((!player.m_9236_().m_5776_() ? 1 : 0) != 0);
        }
        if (offHand.m_41720_() instanceof BannerItem) {
            this.getConstructData().setBanner(offHand);
            return InteractionResult.m_19078_((!player.m_9236_().m_5776_() ? 1 : 0) != 0);
        }
        if (this.getOwner() == player && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this)) {
            return InteractionResult.m_19078_((!player.m_9236_().m_5776_() ? 1 : 0) != 0);
        }
        if (this.getOwner() == player && player.m_21120_(hand).m_41720_() == Items.f_42446_ && !this.getFluidInTank(0).isEmpty()) {
            if (player.m_6047_()) {
                this.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                return InteractionResult.m_19078_((!player.m_9236_().m_5776_() ? 1 : 0) != 0);
            }
            if (player.m_9236_().m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"mna.constructs.feedback.bucket_void"));
            }
        }
        if (this.m_7310_((Entity)player)) {
            this.mountTo(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void mountTo(Player player) {
        if (!this.m_9236_().m_5776_()) {
            player.m_146926_(this.m_146909_());
            player.m_146922_(this.m_146908_());
            player.m_20329_((Entity)this);
            if (this.current != null && this.current.allowSteeringMountedConstructsDuringTask()) {
                this.f_19804_.m_135381_(STEERABLE, (Object)true);
            } else {
                this.f_19804_.m_135381_(STEERABLE, (Object)false);
            }
        }
    }

    protected void m_7324_(Entity entityIn) {
        if (entityIn instanceof Construct || this.isAway()) {
            return;
        }
        super.m_7324_(entityIn);
    }

    public void soundHorn() {
        if (this.hornDelay > 0) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            ClientMessageDispatcher.dispatchConstructHorn(this.m_19879_());
        } else {
            Optional<ItemConstructPart> head = this.getConstructData().getPart(ConstructSlot.HEAD);
            if (head.isPresent() && head.get() instanceof ConstructPartHornHead) {
                this.m_5496_(SFX.Entity.Construct.HORN, 1.0f, (float)(0.9 + Math.random() * 0.2));
                this.hornDelay = 100;
            }
        }
    }

    protected void m_6668_(DamageSource damageSourceIn) {
        super.m_6668_(damageSourceIn);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            ArrayList drops = new ArrayList();
            for (ConstructSlot slot : ConstructSlot.values()) {
                this.constructCapabilities.getPart(slot).ifPresent(p -> {
                    if (!this.m_9236_().m_5776_()) {
                        if (Math.random() > (double)0.85f) {
                            drops.add(new ItemStack((ItemLike)p));
                        } else {
                            drops.addAll(p.getMaterial().getDeathLootMaterialDrops(this, damageSourceIn));
                        }
                    }
                });
            }
            drops.forEach(drop -> {
                ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), drop);
                if (damageSourceIn.m_269533_(DamageTypeTags.f_268415_)) {
                    itementity.m_20334_(-0.5 + Math.random(), Math.random() * 0.5, -0.5 + Math.random());
                }
                itementity.m_32060_();
                this.m_9236_().m_7967_((Entity)itementity);
            });
            this.dropAllItems();
        }
    }

    protected void m_21203_() {
        int i = 16;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public void resetAttackState() {
        this.chargeCounter = 0;
        this.actionFlags = 0;
        this.m_5810_();
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    public boolean isFollowing(Player player) {
        ConstructCommandFollowAndGuard cmd;
        return this.current instanceof ConstructCommandFollowAndGuard && (cmd = (ConstructCommandFollowAndGuard)this.current).getFollowTarget() != null && cmd.getFollowTarget().m_19879_() == player.m_19879_();
    }

    public void moveTo(Vec3 position, Player player) {
        if (!this.playerCanCommand(player)) {
            this.pushDiagnosticMessage(Component.m_237110_((String)"mna.constructs.feedback.notowner", (Object[])new Object[]{player.m_5446_().getString()}).getString(), null);
            return;
        }
        ConstructAITask<?> inst = ConstructTasks.MOVE.instantiateTask(this);
        ((ConstructMove)inst).setDesiredLocation(BlockPos.m_274446_((Position)position));
        this.setCurrentCommand(player, inst);
    }

    public void eatItem(Player player) {
        if (!this.playerCanCommand(player)) {
            this.pushDiagnosticMessage(Component.m_237110_((String)"mna.constructs.feedback.notowner", (Object[])new Object[]{player.m_5446_().getString()}).getString(), null);
            return;
        }
        ConstructAITask<?> inst = ConstructTasks.EAT_ITEM.instantiateTask(this);
        inst.setOneOff(player);
        this.setCurrentCommand(player, inst);
    }

    public void pickupItem(BlockPos target, Player player) {
        if (!this.playerCanCommand(player)) {
            this.pushDiagnosticMessage(Component.m_237110_((String)"mna.constructs.feedback.notowner", (Object[])new Object[]{player.m_5446_().getString()}).getString(), null);
            return;
        }
        ConstructAITask<?> inst = ConstructTasks.GATHER_ITEMS.instantiateTask(this);
        inst.setOneOff(player);
        ((ConstructCollectItems)inst).setArea(new AABB(target));
        this.setCurrentCommand(player, inst);
    }

    @Override
    public void lookTowards(Vec3 pos) {
        this.lookTowards(pos, 15.0f);
    }

    @Override
    public void lookTowards(Vec3 pos, float maxAngle) {
        Vec3 myPos = this.m_20182_();
        Vec3 desiredHeading = pos.m_82546_(myPos).m_82541_();
        Vec3 offset = MathUtils.rotateTowards(this.m_20184_(), desiredHeading, maxAngle).m_82541_();
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(offset));
    }

    @Override
    public List<LivingEntity> getValidAttackTargets(@Nullable LivingEntity defending) {
        double targetRange = this.m_21051_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).m_22135_();
        return this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(targetRange, targetRange, targetRange)).stream().filter(e -> {
            LivingEntity guardTarget;
            Player owner = this.getOwner();
            if (e == this || !e.m_6084_()) {
                return false;
            }
            if (!this.m_21574_().m_148306_((Entity)e)) {
                return false;
            }
            if (owner != null && e == owner || this.isAlliedTo(defending, (Entity)e)) {
                return FluidParameterRegistry.INSTANCE.forFluid(this.getStoredFluid()).checkPredicate((Entity)e, true, this);
            }
            if (e instanceof Creeper && !this.getFluidInTank(0).getFluid().m_205067_(FluidTags.f_13131_)) {
                return false;
            }
            if (e instanceof IFactionEnemy && owner != null) {
                IPlayerProgression progression = (IPlayerProgression)owner.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                if (progression != null && progression.getAlliedFaction() != null && progression.getAlliedFaction() == ((IFactionEnemy)e).getFaction()) {
                    return false;
                }
                return progression.getAlliedFaction() != null;
            }
            if (e instanceof Player && !this.isAlliedTo(defending, (Entity)e)) {
                return true;
            }
            Object object = guardTarget = defending != null ? defending : owner;
            if (e instanceof Mob && guardTarget != null) {
                Mob mob = (Mob)e;
                LivingEntity target = mob.m_5448_();
                if (!(target == null || target != guardTarget && target.m_7307_((Entity)guardTarget))) {
                    return true;
                }
                LivingEntity lastHurtBy = mob.m_21188_();
                if (!(lastHurtBy == null || lastHurtBy != guardTarget && lastHurtBy.m_7307_((Entity)guardTarget))) {
                    return true;
                }
            }
            if (e instanceof Enemy && !(e instanceof IFactionEnemy)) {
                return true;
            }
            return FluidParameterRegistry.INSTANCE.forFluid(this.getStoredFluid()).checkPredicate((Entity)e, true, this);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean validateFriendlyTarget(LivingEntity target) {
        if (this.__cachedFluid != null) {
            return FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).checkPredicate((Entity)target, true, this);
        }
        if (this.currentSpell != null) {
            return !this.currentSpell.isHarmful();
        }
        return false;
    }

    public void consumeManaForRangedAttack() {
        this.adjustMana(-50.0f);
    }

    public void consumeFluidForSpray() {
        this.drain(20, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean performRangedAttack(LivingEntity attackTarget) {
        if (!this.m_21574_().m_148306_((Entity)attackTarget)) {
            this.m_21573_().m_5624_((Entity)attackTarget, this.m_21133_(Attributes.f_22279_));
            return false;
        }
        this.f_19804_.m_135381_(STEERABLE, (Object)false);
        this.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
        ++this.chargeCounter;
        this.m_21573_().m_26573_();
        boolean isFriendly = SummonUtils.isTargetFriendly((Entity)attackTarget, (LivingEntity)this.getOwner());
        if (this.chargeCounter == 1) {
            this.actionFlags = ActionFlags.RANGED_ATTACK.set(this.actionFlags);
            if (this.canSpellCast()) {
                this.setupSpellCast(Math.random() < 0.5);
            } else if (this.canManaCannonAttack()) {
                if (this.getDualCannonTarget().isPresent()) {
                    this.actionFlags = ActionFlags.DUAL_SHOOT.set(this.actionFlags);
                } else {
                    this.getHandWithCapability(ConstructCapability.RANGED_ATTACK).ifPresent(h -> {
                        this.f_20912_ = h;
                    });
                }
            } else if (this.canFluidSpray() && FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).checkPredicate((Entity)attackTarget, isFriendly, this)) {
                this.actionFlags = ActionFlags.SPRAY.set(this.actionFlags);
                if (this.expandFluidRange()) {
                    this.actionFlags = ActionFlags.DUAL_SPRAY.set(this.actionFlags);
                } else {
                    this.getHandWithCapability(ConstructCapability.FLUID_DISPENSE).ifPresent(h -> {
                        this.f_20912_ = h;
                    });
                }
            }
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
            return false;
        }
        if (isFriendly && !this.validateFriendlyTarget(attackTarget)) {
            this.m_6710_(null);
            return true;
        }
        if (ActionFlags.SPRAY.isFlagSet(this.actionFlags)) {
            return this.performFluidAttack(attackTarget);
        }
        if (ActionFlags.CAST_SPELL_SWING.isFlagSet(this.actionFlags) || ActionFlags.CAST_SPELL_CHANNEL.isFlagSet(this.actionFlags)) {
            --this.chargeCounter;
            return this.performSpellAttack(attackTarget);
        }
        return this.performManaCannonAttack(attackTarget);
    }

    @Override
    public boolean setupSpellCast(boolean mainHand) {
        this.actionFlags = ActionFlags.RANGED_ATTACK.set(this.actionFlags);
        ISpellDefinition[] spells = this.getCastableSpells();
        if (!this.canSpellCast() || spells.length == 0) {
            this.resetSpellCast();
            return false;
        }
        int idx = mainHand ? 0 : 1;
        ISpellDefinition selection = spells[idx % spells.length];
        if (this.getMana() < selection.getManaCost()) {
            this.resetSpellCast();
            return false;
        }
        List<SpellReagent> reagents = selection.getReagents(null, this.f_20912_, null);
        HashMap<Item, Boolean> missing = new HashMap<Item, Boolean>();
        for (SpellReagent reagent : reagents) {
            if (this.hasItem(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT())) continue;
            missing.put(reagent.getReagentStack().m_41720_(), reagent.getOptional());
        }
        List missingRequired = missing.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).collect(Collectors.toList());
        if (missingRequired.size() > 0) {
            this.pushDiagnosticMessage(Component.m_237115_((String)"mna.constructs.feedback.cast.missing_reagent").getString(), ConstructTasks.CAST_SPELL_AT_TARGET.getIconTexture());
            this.resetSpellCast();
            return false;
        }
        CompoundTag tmp = new CompoundTag();
        selection.writeToNBT(tmp);
        this.currentSpell = SpellRecipe.fromNBT(tmp);
        this.actionFlags = this.currentSpell.isChanneled() ? ActionFlags.CAST_SPELL_CHANNEL.set(this.actionFlags) : ActionFlags.CAST_SPELL_SWING.set(this.actionFlags);
        this.getHandWithCapability(ConstructCapability.CAST_SPELL).ifPresent(h -> {
            this.f_20912_ = h;
        });
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
        return true;
    }

    @Override
    public boolean startSpellCast(@Nullable SpellTarget targetHint) {
        SpellSource source = new SpellSource((LivingEntity)this, this.f_20912_);
        ItemStack spellStack = new ItemStack((ItemLike)ItemInit.SPELL.get());
        this.currentSpell.writeToNBT(spellStack.m_41784_());
        SpellCaster.applyAdjusters(spellStack, (LivingEntity)this, this.f_20912_, false, this.currentSpell, SpellCastStage.CALCULATING_MANA_COST);
        List<SpellReagent> reagents = this.currentSpell.getReagents(null, this.f_20912_, null);
        HashMap<Item, Boolean> missing = new HashMap<Item, Boolean>();
        boolean allReagentsConsumed = true;
        ArrayList<Pair<IItemHandler, Direction>> myInv = new ArrayList<Pair<IItemHandler, Direction>>();
        myInv.add(new Pair((Object)this, (Object)Direction.UP));
        for (SpellReagent reagent : reagents) {
            if (!this.hasItem(reagent.getReagentStack(), !reagent.getIgnoreDurability(), reagent.getCompareNBT())) {
                missing.put(reagent.getReagentStack().m_41720_(), reagent.getOptional());
                continue;
            }
            if (!reagent.getConsume()) continue;
            boolean found = false;
            InteractionHand[] hands = this.getCarryingHands((ItemStack is) -> {
                if (!reagent.getIgnoreDurability() && is.m_41773_() != reagent.getReagentStack().m_41773_()) {
                    return false;
                }
                if (reagent.getCompareNBT() && !ManaAndArtificeMod.getItemHelper().AreTagsEqual((ItemStack)is, reagent.getReagentStack())) {
                    return false;
                }
                return is.m_41720_() == reagent.getReagentStack().m_41720_();
            });
            if (hands.length > 0) {
                ItemStack handStack = this.m_21120_(hands[0]);
                handStack.m_41774_(1);
                if (handStack.m_41619_()) {
                    this.m_21008_(hands[0], ItemStack.f_41583_);
                } else {
                    this.m_21008_(hands[0], handStack);
                }
                found = true;
            } else {
                found = InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), false, myInv);
            }
            allReagentsConsumed &= found;
        }
        if (!allReagentsConsumed) {
            this.resetSpellCast();
            return false;
        }
        float discountFactor = 1.0f - 0.1f * (float)this.getConstructData().getAffinityScore(Affinity.ARCANE);
        this.adjustMana(-this.currentSpell.getManaCost() * discountFactor);
        if (this.currentSpell.isChanneled()) {
            this.m_21008_(this.f_20912_, spellStack);
            this.m_6672_(this.f_20912_);
        }
        SpellCaster.Affect(spellStack, this.currentSpell, this.m_9236_(), source, targetHint);
        return true;
    }

    @Override
    public boolean tickSpellCast() {
        ++this.chargeCounter;
        if (this.chargeCounter > 80) {
            this.resetSpellCast();
            return false;
        }
        if (this.currentSpell.isChanneled()) {
            if (this.chargeCounter >= 60) {
                this.resetSpellCast();
                return false;
            }
            if (this.chargeCounter >= 5) {
                float discountFactor = 1.0f - 0.1f * (float)this.getConstructData().getAffinityScore(Affinity.ARCANE);
                this.adjustMana(-this.currentSpell.getManaCost() * discountFactor);
            }
        } else if (this.chargeCounter >= 20) {
            this.resetSpellCast();
            return false;
        }
        return true;
    }

    @Override
    public void resetSpellCast() {
        this.m_5810_();
        this.resetAttackState();
        this.f_19804_.m_135381_(STEERABLE, (Object)true);
    }

    private boolean performFluidAttack(LivingEntity attackTarget) {
        if (this.chargeCounter == 2) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).spraySound(), SoundSource.NEUTRAL, 0.25f, (float)(0.9 + Math.random() * 0.1));
        } else {
            if (this.chargeCounter == 15) {
                this.consumeFluidForSpray();
                this.resetAttackState();
                this.f_19804_.m_135381_(STEERABLE, (Object)true);
                return true;
            }
            if (this.chargeCounter >= 5 && this.chargeCounter % 5 == 0) {
                float range = 10.0f;
                float angle = 45.0f;
                if (this.expandFluidRange()) {
                    range *= 1.5f;
                    angle = 60.0f;
                }
                Vec3 forward = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
                EntityUtil.getEntitiesWithinCone(this.m_9236_(), this.m_20182_(), forward, range, -angle, angle, e -> {
                    if (!(e instanceof LivingEntity)) {
                        return false;
                    }
                    boolean isFriendly = this.m_7307_((Entity)e);
                    if (e == this.getOwner() && !FluidParameterRegistry.INSTANCE.forFluid(this.__cachedFluid).checkPredicate((Entity)e, isFriendly, this)) {
                        return false;
                    }
                    ConstructSprayTargetingEvent targetEvt = new ConstructSprayTargetingEvent((Entity)this, (Entity)e, this.__cachedFluid, e == this.getOwner(), isFriendly);
                    MinecraftForge.EVENT_BUS.post((Event)targetEvt);
                    return !targetEvt.isCanceled();
                }).stream().map(e -> e).forEach(e -> {
                    ConstructSprayEffectEvent effectEvt = new ConstructSprayEffectEvent((LivingEntity)this, (LivingEntity)e, this.__cachedFluid, e == this.getOwner(), SummonUtils.isTargetFriendly((Entity)e, (LivingEntity)this.getOwner()));
                    MinecraftForge.EVENT_BUS.post((Event)effectEvt);
                });
            }
        }
        return false;
    }

    private boolean performSpellAttack(LivingEntity attackTarget) {
        if (this.chargeCounter > 80) {
            this.resetAttackState();
            this.m_5810_();
            this.f_19804_.m_135381_(STEERABLE, (Object)true);
            return true;
        }
        if (this.chargeCounter == 2) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, attackTarget.m_146892_());
            this.startSpellCast(new SpellTarget((Entity)attackTarget));
            return false;
        }
        this.tickSpellCast();
        return false;
    }

    private boolean performManaCannonAttack(LivingEntity attackTarget) {
        if (this.chargeCounter == 20) {
            this.getDualCannonTarget().ifPresent(eTgt -> {
                this.spawnManaCannonShot((LivingEntity)eTgt);
                this.setCooldown(0, (int)(500.0f * this.getConstructData().getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.RANGED_ATTACK).getCooldownMultiplierFor(ConstructCapability.RANGED_ATTACK)));
            });
            this.spawnManaCannonShot(attackTarget);
        } else if (this.chargeCounter == 40) {
            this.resetAttackState();
            this.f_19804_.m_135381_(STEERABLE, (Object)true);
            return true;
        }
        return false;
    }

    private void spawnManaCannonShot(LivingEntity target) {
        Affinity aff = this.getConstructData().getRandomContainedAffinity();
        SpellProjectile esp = new SpellProjectile((LivingEntity)this, this.m_9236_());
        esp.setForcedDamageAffinityAndTarget(aff, (float)this.m_21051_((Attribute)AttributeInit.RANGED_DAMAGE.get()).m_22135_(), (Entity)target);
        esp.setHomingStrength(MathUtils.clamp01((float)(this.getIntelligence() - 16) / 24.0f));
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
        esp.shoot((Entity)this, this.m_20156_(), 1.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)esp);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Spell.Cast.ForAffinity(aff), SoundSource.NEUTRAL, 0.25f, (float)(0.9 + Math.random() * 0.1));
        this.consumeManaForRangedAttack();
    }

    public boolean m_7307_(Entity pEntity) {
        if (pEntity instanceof Construct) {
            Optional theirOwnerID = (Optional)((Construct)pEntity).f_19804_.m_135370_(OWNER_UUID);
            Optional myOwnerID = (Optional)this.f_19804_.m_135370_(OWNER_UUID);
            if (theirOwnerID.isPresent() && myOwnerID.isPresent()) {
                Player myOwner = this.getOwner();
                Player theirOwner = ((Construct)pEntity).getOwner();
                if (myOwner != null && theirOwner != null) {
                    return myOwner.m_7307_((Entity)theirOwner);
                }
                if (((UUID)myOwnerID.get()).equals(theirOwnerID.get())) {
                    return true;
                }
            }
        }
        return SummonUtils.isTargetFriendly(pEntity, (LivingEntity)this.getOwner());
    }

    public boolean isAlliedTo(@Nullable LivingEntity defending, Entity pEntity) {
        if (defending == null) {
            return this.m_7307_(pEntity);
        }
        return SummonUtils.isTargetFriendly(pEntity, defending);
    }

    public void m_6667_(DamageSource cause) {
        if (this.isDueling()) {
            Component opponentName;
            this.m_21153_(1.0f);
            Component component = opponentName = cause.m_7639_() != null ? cause.m_7639_().m_7770_() : null;
            if (opponentName == null) {
                opponentName = Component.m_237115_((String)"mna.constructs.feedback.target.no_name");
            }
            this.pushDiagnosticMessage((Component)Component.m_237110_((String)"mna.constructs.feedback.duel.defeat", (Object[])new Object[]{opponentName}), ConstructTasks.DUEL.getIconTexture());
            this.setDefeated(600);
            return;
        }
        super.m_6667_(cause);
        if (this.current instanceof ConstructCommandReturnToTable) {
            this.constructDiagnostics.pushDiagnosticMessage(Component.m_237115_((String)"mna.constructs.feedback.return_to_table").getString(), null, false);
        } else {
            this.constructDiagnostics.pushDiagnosticMessage(Component.m_237115_((String)"mna.constructs.feedback.death").getString(), null, false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        int numBoneParts;
        int numWickerwoodParts;
        if (this.isAway()) {
            return false;
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_IMMUNE)) {
            return false;
        }
        if (this.m_6688_() != null && source.m_7639_() == this.m_6688_()) {
            return false;
        }
        if (source.m_7639_() != null && this.getOwner() != null && (source.m_7639_() == this.getOwner() || this.m_7307_(source.m_7639_()))) {
            this.setUnimpressed(60);
            return false;
        }
        if (this.m_6688_() != null && !this.redirectingDamage) {
            this.redirectingDamage = true;
            this.m_6688_().m_6469_(source, amount);
            this.redirectingDamage = false;
            return false;
        }
        if (this.defeatedCounter > 0) {
            return false;
        }
        int numWoodParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.WOOD).size();
        int burnableParts = numWoodParts + (numWickerwoodParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.WICKERWOOD).size());
        if (burnableParts > 0 && source.m_269533_(DamageTypeTags.f_268745_)) {
            amount *= 1.0f + (float)burnableParts * 0.2f;
        }
        if ((numBoneParts = this.constructCapabilities.getPartsForMaterial(ConstructMaterial.BONE).size()) > 0 && source.m_269533_(DamageTypeTags.f_268419_)) {
            amount *= 1.0f - (float)numBoneParts * 0.2f;
        }
        float resistance = 0.0f;
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            resistance += this.constructCapabilities.calculateExplosionResistance();
        }
        amount -= amount * resistance;
        resistance = 0.0f;
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_EARTH)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.EARTH);
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_WIND)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.WIND);
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_FIRE)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.FIRE);
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_WATER)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.WATER);
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_ARCANE)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.ARCANE);
        }
        if (source.m_269533_(MATags.DamageTypes.CONSTRUCT_RESIST_ENDER)) {
            resistance += (float)this.getConstructData().getAffinityScore(Affinity.ENDER);
        }
        amount -= resistance;
        if (this.getConstructData().isCapabilityEnabled(ConstructCapability.BLOCK) && source.m_7639_() == this.m_5448_()) {
            this.attackDelay += 20;
        }
        if (amount <= 0.0f) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            LivingEntity living;
            int water;
            if (this.constructCapabilities.getAffinityScore(Affinity.FIRE) > 0) {
                entityIn.m_20254_(this.constructCapabilities.getAffinityScore(Affinity.FIRE));
            }
            if ((water = this.constructCapabilities.getAffinityScore(Affinity.WATER)) > 0 && entityIn instanceof LivingEntity) {
                living = (LivingEntity)entityIn;
                int amp = (int)Math.ceil((float)water / 2.0f);
                int dur = water * 20;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, dur, amp));
            }
            if (this.constructCapabilities.isCapabilityEnabled(ConstructCapability.TAUNT) && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
                if (Math.random() < 0.01) {
                    this.m_5496_(SFX.Entity.Construct.HORN, 1.0f, (float)(0.9 + Math.random() * 0.2));
                }
            }
            if (this.getConstructData().isCapabilityEnabled(ConstructCapability.BLOCK)) {
                this.attackDelay = 10 + (int)(20.0 * Math.random());
            }
            if (!this.m_9236_().m_5776_() && (float)this.constructCapabilities.calculateIntelligence() >= 36.0f && (float)this.constructCapabilities.calculatePerception() >= 28.0f && entityIn instanceof LivingEntity) {
                living = (LivingEntity)entityIn;
                living.m_6598_((Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_9236_())));
            }
            return true;
        }
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.constructCapabilities != null) {
            this.constructCapabilities.WriteNBT(compound);
        }
        compound.m_128359_(NBT_OWNER, this.f_19804_.m_135370_(OWNER_UUID) != null && ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent() ? ((UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get()).toString() : "");
        if (this.current != null) {
            compound.m_128365_("currentGoal", (Tag)this.current.writeNBT());
        }
        compound.m_128350_("mana", ((Float)this.f_19804_.m_135370_(MANA)).floatValue());
        compound.m_128359_("fluidType", (String)this.f_19804_.m_135370_(FLUIDTYPE));
        compound.m_128405_("fluidAmt", ((Integer)this.f_19804_.m_135370_(FLUIDAMT)).intValue());
        if (this.cached_team_name != null) {
            compound.m_128359_("alliedTeam", this.cached_team_name);
        }
    }

    public void m_7378_(CompoundTag compound) {
        CompoundTag goalData;
        ConstructTask action;
        ConstructAITask<?> inst;
        super.m_7378_(compound);
        this.constructCapabilities.ReadNBT(compound);
        if (compound.m_128441_(NBT_OWNER)) {
            try {
                this.f_19804_.m_135381_(OWNER_UUID, Optional.of(UUID.fromString(compound.m_128461_(NBT_OWNER))));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Error loading construct owner UUID.  It is now unclaimed and can be claimed by any player.");
            }
        }
        this.recalculateAll();
        if (compound.m_128441_("mana")) {
            this.f_19804_.m_135381_(MANA, (Object)Float.valueOf(compound.m_128457_("mana")));
        }
        if (compound.m_128441_("fluidType")) {
            String fluidType = compound.m_128461_("fluidType");
            ResourceLocation fLoc = new ResourceLocation(fluidType);
            this.setStoredFluid((Fluid)ForgeRegistries.FLUIDS.getValue(fLoc));
        }
        if (compound.m_128441_("fluidAmt")) {
            this.setStoredFluidAmount(compound.m_128451_("fluidAmt"));
        }
        if (compound.m_128441_("alliedTeam")) {
            this.cached_team_name = compound.m_128461_("alliedTeam");
        }
        if (compound.m_128441_("currentGoal") && (inst = (action = ConstructAITask.getTypeFromNBT(goalData = compound.m_128469_("currentGoal"))).instantiateTask(this)) != null) {
            this.current = inst;
            this.current.setConstruct(this);
            this.current.readNBT(goalData);
            if (this.current != null && this.current.allowSteeringMountedConstructsDuringTask()) {
                this.f_19804_.m_135381_(STEERABLE, (Object)true);
            } else {
                this.f_19804_.m_135381_(STEERABLE, (Object)false);
            }
            this.f_21345_.m_25352_(4, this.current);
        }
        this.m_21557_(false);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22280_, (double)0.35f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 20.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get(), 8.0).m_22268_((Attribute)AttributeInit.INTELLIGENCE.get(), 8.0).m_22268_((Attribute)AttributeInit.RANGED_DAMAGE.get(), 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(MANA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_MANA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STEERABLE, (Object)false);
        this.f_19804_.m_135372_(BUOYANCY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FLUID_CAP, (Object)0);
        this.f_19804_.m_135372_(FLUIDAMT, (Object)0);
        this.f_19804_.m_135372_(AWAY_TYPE, (Object)0);
        this.f_19804_.m_135372_(FLUIDTYPE, (Object)"");
        this.f_19804_.m_135372_(FISHING_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(FORCED_ANIMATION, (Object)-1);
        this.f_19804_.m_135372_(FORCED_ANIMATION_IDLE_ONLY, (Object)true);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        String id = (String)this.f_19804_.m_135370_(FLUIDTYPE);
        if (id != null && !id.isEmpty()) {
            ResourceLocation rLoc = new ResourceLocation(id);
            this.__cachedFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rLoc);
        } else {
            this.__cachedFluid = null;
        }
        this.forcedAnimationIdleOnly = (Boolean)this.f_19804_.m_135370_(FORCED_ANIMATION_IDLE_ONLY);
        int forcedAnimIdx = (Integer)this.f_19804_.m_135370_(FORCED_ANIMATION);
        this.forcedAnimation = forcedAnimIdx == -1 ? null : Animations.values()[forcedAnimIdx % Animations.values().length];
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ConstructSwimGoal());
        this.f_21345_.m_25352_(0, (Goal)new ConstructOpenDoors(this, true));
        this.f_21345_.m_25352_(0, (Goal)new ConstructFleeTarget(this, 12.0f, 0.5, 0.5));
    }

    private void registerHammerLeap() {
        Optional<ItemConstructPart> leftArm = this.getConstructData().getPart(ConstructSlot.LEFT_ARM);
        if (!leftArm.isPresent() || !(leftArm.get() instanceof ConstructPartHammerArmLeft)) {
            return;
        }
        Optional<ItemConstructPart> rightArm = this.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
        if (!rightArm.isPresent() || !(rightArm.get() instanceof ConstructPartHammerArmRight)) {
            return;
        }
        if (this.getIntelligence() < 16) {
            return;
        }
        float speed = this.getConstructData().getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.SMITH).getCooldownMultiplierFor(ConstructCapability.SMITH) * 0.65f;
        float damage = this.getConstructData().calculateDamage() / 2.0f;
        this.f_21345_.m_25352_(1, new LerpLeap<Construct>(this, 10, 5, e -> {
            if (this.m_5448_() == null || this.m_7307_((Entity)this.m_5448_()) || !this.m_5448_().m_20096_()) {
                return false;
            }
            if (this.isOnCooldown(0)) {
                return false;
            }
            int yCount = 0;
            BlockPos pos = this.m_20183_().m_7494_();
            while (this.m_9236_().m_46859_(pos) && yCount < 5) {
                ++yCount;
                pos = pos.m_7494_();
            }
            if (yCount < 5) {
                return false;
            }
            return this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_20270_((Entity)this) < 4.0f && this.m_21574_().m_148306_((Entity)this.m_5448_());
        }, evt -> {
            boolean sendFlags = false;
            switch (evt) {
                case DAMAGE: {
                    this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(4.0), tgt -> tgt instanceof LivingEntity && tgt.m_6084_() && tgt != this && !this.m_7307_((Entity)tgt)).stream().map(e -> (LivingEntity)e).forEach(target -> {
                        float mX = (float)(this.m_20185_() - target.m_20185_());
                        float mZ = (float)(this.m_20189_() - target.m_20189_());
                        float speed2 = this.getConstructData().getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.SMITH).getCooldownMultiplierFor(ConstructCapability.SMITH) * 0.65f;
                        ComponentFling.flingTarget(target, new Vec3((double)mX, (double)speed, (double)mZ), speed2, 3.0f);
                        target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
                    });
                    if (this.m_9236_().m_5776_()) break;
                    ServerMessageDispatcher.sendParticleEffect((ResourceKey<Level>)this.m_9236_().m_46472_(), 32.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), SpawnParticleEffectMessage.ParticleTypes.CONSTRUCT_HAMMER_SMASH);
                    break;
                }
                case LAND: {
                    this.actionFlags = ActionFlags.LEAP_LAND.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                case LEAP: {
                    this.actionFlags = ActionFlags.LEAP_AIRBORNE.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                case START: {
                    this.actionFlags = ActionFlags.LEAP_START.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                default: {
                    this.actionFlags = 0;
                    sendFlags = true;
                    this.setCooldown(0, (int)(500.0f * this.getConstructData().getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.SMITH).getCooldownMultiplierFor(ConstructCapability.SMITH)));
                }
            }
            if (sendFlags && !this.m_9236_().m_5776_()) {
                this.ANIM_PACKET = true;
                ServerMessageDispatcher.sendEntityStateMessage(this);
                this.ANIM_PACKET = false;
            }
        }));
    }

    private void registerAxeLeap() {
        Optional<ItemConstructPart> leftArm = this.getConstructData().getPart(ConstructSlot.LEFT_ARM);
        if (!leftArm.isPresent() || !(leftArm.get() instanceof ConstructPartAxeArmLeft)) {
            return;
        }
        Optional<ItemConstructPart> rightArm = this.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
        if (!rightArm.isPresent() || !(rightArm.get() instanceof ConstructPartAxeArmRight)) {
            return;
        }
        if (this.getIntelligence() < 16) {
            return;
        }
        float damage = this.getConstructData().calculateDamage() * 3.0f;
        this.f_21345_.m_25352_(1, new LerpLeap<Construct>(this, 10, 5, e -> {
            if (this.m_5448_() == null || this.m_7307_((Entity)this.m_5448_())) {
                return false;
            }
            if (this.isOnCooldown(0)) {
                return false;
            }
            int yCount = 0;
            BlockPos pos = this.m_20183_();
            while (this.m_9236_().m_46859_(pos) && yCount < 5) {
                ++yCount;
                pos = pos.m_7494_();
            }
            if (yCount < 3) {
                return false;
            }
            double dist = this.m_5448_().m_20270_((Entity)this);
            return this.m_5448_() != null && this.m_5448_().m_6084_() && dist >= 4.0 && dist <= 16.0 && this.m_21574_().m_148306_((Entity)this.m_5448_());
        }, evt -> {
            boolean sendFlags = false;
            switch (evt) {
                case DAMAGE: {
                    if (this.m_5448_() == null) break;
                    this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
                    CompoundTag meta = new CompoundTag();
                    meta.m_128405_("entityID", this.m_5448_().m_19879_());
                    ServerMessageDispatcher.sendParticleEffect((ResourceKey<Level>)this.m_9236_().m_46472_(), 32.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), SpawnParticleEffectMessage.ParticleTypes.CONSTRUCT_AXE_SMASH, meta);
                    break;
                }
                case LAND: {
                    this.actionFlags = ActionFlags.LEAP_LAND.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                case LEAP: {
                    this.actionFlags = ActionFlags.LEAP_AIRBORNE.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                case START: {
                    this.actionFlags = ActionFlags.LEAP_START.set(this.actionFlags);
                    sendFlags = true;
                    break;
                }
                default: {
                    this.actionFlags = 0;
                    sendFlags = true;
                    this.setCooldown(0, (int)(500.0f * this.getConstructData().getLowestMaterialCooldownMultiplierForCapability(ConstructCapability.CHOP_WOOD).getCooldownMultiplierFor(ConstructCapability.CHOP_WOOD)));
                }
            }
            if (sendFlags && !this.m_9236_().m_5776_()) {
                this.ANIM_PACKET = true;
                ServerMessageDispatcher.sendEntityStateMessage(this);
                this.ANIM_PACKET = false;
            }
        }));
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        if (nbt.m_128441_("anim")) {
            if (nbt.m_128441_("hand")) {
                this.f_20912_ = InteractionHand.values()[nbt.m_128445_("hand")];
            }
            this.clearAnimCache = ActionFlags.ADVENTURE_ENTER.isFlagSet(this.actionFlags);
            this.actionFlags = nbt.m_128451_("actionFlags");
            this.defeatedCounter = nbt.m_128451_("defeatedCounter");
        } else {
            this.constructCapabilities.ReadNBT(nbt);
            this.recalculateAll();
        }
        if (nbt.m_128441_("diag")) {
            this.constructDiagnostics.readFromNBT(nbt.m_128469_("diag"));
        }
        if (nbt.m_128441_("inv")) {
            for (int i = 0; i < 9; ++i) {
                this.setStackInSlot(i, ItemStack.f_41583_);
            }
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("inv"), this.inventory);
        }
        if (nbt.m_128441_("hat")) {
            this.constructCapabilities.setHat(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("hat")));
        }
        if (nbt.m_128441_("banner")) {
            this.constructCapabilities.setBanner(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("banner")));
        }
        this.moodlets.readFromNBT(nbt);
        if (ManaAndArtifice.instance.proxy.checkConstructDanceMixPlaying()) {
            this.setHappy(10000);
        }
        if (this.isAway()) {
            this.mine_leave_pfx = false;
            this.mine_return_pfx = false;
            this.adventure_leave_pfx = false;
            this.adventure_return_pfx = false;
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.m_9236_().m_5776_() && this.getCurrentCommand() instanceof ConstructCommandFollowLodestar) {
            ((ConstructCommandFollowLodestar)this.getCurrentCommand()).releaseMutexes();
        }
    }

    @Nullable
    public Fluid getStoredFluid() {
        return this.__cachedFluid;
    }

    public void setStoredFluid(Fluid fluid) {
        if (fluid == null) {
            fluid = Fluids.f_76191_;
        }
        if (this.__cachedFluid != fluid) {
            this.f_19804_.m_135381_(FLUIDTYPE, (Object)ForgeRegistries.FLUIDS.getKey((Object)fluid).toString());
            this.__cachedFluid = fluid;
        }
    }

    @Override
    public int getStoredFluidAmount() {
        return (Integer)this.f_19804_.m_135370_(FLUIDAMT);
    }

    @Override
    public float getFluidPct() {
        int capacity = this.getTankCapacity(1);
        int amount = this.getStoredFluidAmount();
        return (float)amount / (float)capacity;
    }

    public void setStoredFluidAmount(int amount) {
        amount = Math.max(0, Math.min(amount, this.getTankCapacity(1)));
        this.f_19804_.m_135381_(FLUIDAMT, (Object)amount);
    }

    public boolean hasStoredFluid() {
        return this.__cachedFluid.m_6212_(Fluids.f_76191_);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.__cachedFluid == null || this.__cachedFluid.m_6212_(Fluids.f_76191_)) {
            return new FluidStack(Fluids.f_76191_, 0);
        }
        int amountRemoved = maxDrain;
        int fluidAmount = this.getStoredFluidAmount();
        Fluid fluid = this.__cachedFluid;
        if (fluidAmount < maxDrain) {
            amountRemoved = fluidAmount;
        }
        if ((fluidAmount -= amountRemoved) <= 0) {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.setStoredFluidAmount(0);
                this.setStoredFluid(Fluids.f_76191_);
                this.needsSync = true;
            }
        } else if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.setStoredFluidAmount(fluidAmount);
            this.needsSync = true;
        }
        return new FluidStack(fluid, amountRemoved);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.__cachedFluid != null && !this.__cachedFluid.m_6212_(Fluids.f_76191_) && !this.__cachedFluid.m_6212_(resource.getFluid())) {
            return 0;
        }
        int amountAdded = resource.getAmount();
        int resultingAmount = this.getStoredFluidAmount();
        if (resultingAmount + amountAdded > this.getTankCapacity(1)) {
            amountAdded = this.getTankCapacity(1) - resultingAmount;
        }
        resultingAmount += amountAdded;
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.setStoredFluid(resource.getFluid());
            this.setStoredFluidAmount(resultingAmount);
        }
        return amountAdded;
    }

    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.getStoredFluid();
        if (fluid != null) {
            return new FluidStack(fluid, this.getStoredFluidAmount());
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return (Integer)this.f_19804_.m_135370_(FLUID_CAP);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getFluidInTank(1).isEmpty() || this.getFluidInTank(1).getFluid().m_6212_(stack.getFluid());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> this.handleAnimState((AnimationState<Construct>)state));
        controller.setCustomInstructionKeyframeHandler((AnimationController.CustomKeyframeHandler)this);
        registrar.add(new AnimationController[]{controller});
    }

    private PlayState handleAnimState(AnimationState<Construct> state) {
        block53: {
            block54: {
                if (!this.isAddedToWorld()) {
                    return PlayState.STOP;
                }
                if (this.forcedAnimation == null) break block53;
                if (!this.forcedAnimationIdleOnly) break block54;
                Vec3 vec3 = new Vec3(this.m_20185_() - this.f_19790_, 0.0, this.m_20189_() - this.f_19792_);
                if (!(vec3.m_82553_() < 0.1)) break block53;
            }
            return state.setAndContinue(this.forcedAnimation.play());
        }
        boolean swim = false;
        if (this.canSwim()) {
            BlockPos bp = this.m_20183_();
            FluidState flState = this.m_9236_().m_6425_(bp);
            FluidState flStateBelow = this.m_9236_().m_6425_(bp.m_7495_());
            if ((double)flState.m_76182_() > 0.8 || (double)flStateBelow.m_76182_() > 0.8) {
                swim = true;
            }
        }
        if (ActionFlags.LEAP_START.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.leap").thenLoop("animation.construct.airborne_leaping"));
        }
        if (ActionFlags.LEAP_AIRBORNE.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.airborne_leaping"));
        }
        if (ActionFlags.LEAP_LAND.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.leap_land").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.DUAL_SWEEP.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.dual_sweep").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.DUAL_SHOOT.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.shoot_dual").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.DUAL_SPRAY.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.spray_both").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.DEFEATED.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.defeated_enter").thenLoop("animation.construct.defeated_loop"));
        }
        if (ActionFlags.DEFEATED_END.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.defeated_exit"));
        }
        if (ActionFlags.RANGED_ATTACK.isFlagSet(this.actionFlags)) {
            if (ActionFlags.SPRAY.isFlagSet(this.actionFlags)) {
                if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.spray_left"));
                }
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.spray_right"));
            }
            if (ActionFlags.CAST_SPELL_SWING.isFlagSet(this.actionFlags)) {
                if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_left").thenLoop("animation.construct.idle"));
                }
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_right").thenLoop("animation.construct.idle"));
            }
            if (ActionFlags.CAST_SPELL_CHANNEL.isFlagSet(this.actionFlags)) {
                if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.channel_cast_left"));
                }
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.channel_cast_right"));
            }
            if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.shoot_left"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.shoot_right"));
        }
        if (ActionFlags.WATER.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.sprinkler"));
        }
        if (ActionFlags.EAT.isFlagSet(this.actionFlags)) {
            if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.eat_left"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.eat_right"));
        }
        if (ActionFlags.FISH.isFlagSet(this.actionFlags)) {
            if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_left").thenLoop("animation.construct.fish_loop_left"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_right").thenLoop("animation.construct.fish_loop_right"));
        }
        if (ActionFlags.FISH_END.isFlagSet(this.actionFlags)) {
            if (this.f_20912_ == null || this.f_20912_ == InteractionHand.MAIN_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.fish_end_left").thenLoop("animation.construct.idle"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.fish_end_right").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.MINE_ENTER.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.drill_enter").thenLoop("animation.construct.drill_loop"));
        }
        if (ActionFlags.MINE_LEAVE.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.drill_leave"));
        }
        if (ActionFlags.ADVENTURE_ENTER.isFlagSet(this.actionFlags)) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.adventure_leave").thenLoop("animation.construct.idle"));
        }
        if (ActionFlags.ADVENTURE_LEAVE.isFlagSet(this.actionFlags)) {
            if (this.clearAnimCache) {
                state.getController().forceAnimationReset();
                this.clearAnimCache = false;
            }
            state.getController().setOverrideEasingType(EasingType.LINEAR);
            state.getController().transitionLength(1);
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.adventure_return"));
        }
        if (this.f_20911_) {
            if (this.f_20912_ == InteractionHand.MAIN_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_left"));
            }
            if (this.f_20912_ == InteractionHand.OFF_HAND) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.swing_right"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct.dual_sweep"));
        }
        if (!(this.m_20096_() || this.canFly() || this.m_20072_())) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.airborne"));
        }
        double speed = new Vec3(this.m_20185_() - this.f_19790_, 0.0, this.m_20189_() - this.f_19792_).m_82553_();
        state.getController().transitionLength(5);
        if (this.canFly() && !this.m_20096_()) {
            if (speed > (double)0.1f && this.m_20184_().f_82480_ < speed / 4.0) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.fly_moving"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.fly_idle"));
        }
        if (speed > (double)0.1f) {
            if (swim) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.swim_loop"));
            }
            if (this.getMoodlets().getStrongestMoodlet() == 8) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.run_happy"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.run"));
        }
        if (speed > (double)0.02f) {
            if (swim) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.swim_loop"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.walk"));
        }
        if (this.dancing) {
            if (this.danceTicks < 148) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.dance_1"));
            }
            if (this.danceTicks < 432) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.dance_2"));
            }
            switch (this.danceIndex) {
                case 0: {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.dance_3"));
                }
                case 1: {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.dance_4"));
                }
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.dance_5"));
        }
        if (swim) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.swim_idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.construct.idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void handle(CustomInstructionKeyframeEvent<Construct> event) {
        String instructions = event.getKeyframeData().getInstructions();
        if (instructions.equals("hide")) {
            this.clearAnimCache = true;
            this.mine_leave_pfx = false;
            this.mine_return_pfx = false;
            this.adventure_leave_pfx = false;
            this.adventure_return_pfx = false;
        } else if (instructions.equals("show")) {
            this.clearAnimCache = false;
        } else if (instructions.equals("mine_enter_pfx_start")) {
            this.mine_leave_pfx = true;
            this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SFX.Spell.Impact.AoE.EARTH, this.m_5720_(), 1.0f, 1.0f);
        } else if (instructions.equals("drill_leave_sound")) {
            this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SFX.Spell.Impact.AoE.EARTH, this.m_5720_(), 1.0f, 1.0f);
        } else if (instructions.equals("mine_leave_pfx_start")) {
            this.mine_return_pfx = true;
        } else if (instructions.equals("mine_leave_pfx_stop")) {
            this.mine_return_pfx = false;
        } else if (instructions.equals("adventure_leave")) {
            this.adventure_leave_pfx = true;
            this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SFX.Spell.Impact.Single.WIND, this.m_5720_(), 1.0f, 1.0f);
            this.pfxCounter = 0;
        } else if (instructions.equals("adventure_return")) {
            this.adventure_return_pfx = true;
            this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SFX.Spell.Impact.Single.WIND, this.m_5720_(), 1.0f, 1.0f);
            this.pfxCounter = 0;
        } else if (instructions.equals("adventure_return_stop")) {
            this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11685_, this.m_5720_(), 1.0f, 1.0f);
            this.adventure_return_pfx = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnSmoothParticles(float partialTick) {
        block5: {
            block4: {
                Vec3 vel;
                Vec3 particlePos;
                Vec3 look;
                int i;
                if (!ActionFlags.SPRAY.isFlagSet(this.actionFlags) || !this.m_9236_().m_5776_() || this.getStoredFluid() == Fluids.f_76191_) break block4;
                FluidParameterRegistry.FluidParameter param = FluidParameterRegistry.INSTANCE.forFluid(this.getStoredFluid());
                float angle = (float)(Math.toRadians(60.0) * Math.sin((double)partialTick * Math.PI));
                for (i = 0; i < param.getParticleQuantity(); ++i) {
                    look = this.m_20171_(this.m_146909_(), this.m_6080_());
                    look = look.m_82524_(angle - (float)Math.toRadians(40.0));
                    particlePos = this.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82549_(look);
                    vel = param.adjustVelocity(look);
                    this.m_9236_().m_7106_(param.particle(), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
                if (!this.expandFluidRange()) break block5;
                angle = (float)(Math.toRadians(60.0) * -Math.sin((double)partialTick * Math.PI));
                for (i = 0; i < param.getParticleQuantity(); ++i) {
                    look = this.m_20171_(this.m_146909_(), this.m_6080_());
                    look = look.m_82524_(angle + (float)Math.toRadians(40.0));
                    particlePos = this.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82549_(look);
                    vel = param.adjustVelocity(look);
                    this.m_9236_().m_7106_(param.particle(), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
                break block5;
            }
            if (ActionFlags.WATER.isFlagSet(this.actionFlags)) {
                for (int i = 0; i < 20; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)0.9f + Math.random(), this.m_20182_().f_82481_, -0.5 + Math.random(), 0.0, -0.5 + Math.random());
                }
            }
        }
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.m_41619_() || stack.m_41613_() < amount) {
            return ItemStack.f_41583_;
        }
        if (!simulate) {
            ItemStack output = stack.m_41620_(amount);
            return output;
        }
        ItemStack output = stack.m_41777_();
        output.m_41764_(amount);
        return output;
    }

    public int getSlotLimit(int slot) {
        if (this.constructCapabilities != null) {
            return this.constructCapabilities.calculateInventoryStackLimit();
        }
        return 1;
    }

    public int getSlots() {
        if (this.constructCapabilities != null) {
            return this.constructCapabilities.calculateInventorySize();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_()) {
            if (!simulate) {
                this.inventory.set(slot, (Object)stack);
            }
            return ItemStack.f_41583_;
        }
        if (existing.m_41768_()) {
            return stack;
        }
        if (existing.m_41782_() && !ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, existing)) {
            return stack;
        }
        int countToInsert = Math.min(stack.m_41613_(), existing.m_41741_() - existing.m_41613_());
        ItemStack clone = stack.m_41777_();
        clone.m_41774_(countToInsert);
        if (!simulate) {
            existing.m_41764_(existing.m_41613_() + countToInsert);
        }
        return clone;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot >= 0 && slot < this.inventory.size();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return;
        }
        this.inventory.set(slot, (Object)stack);
    }

    @Override
    public void dropAllItems() {
        if (!this.m_21205_().m_41619_()) {
            this.m_19983_(this.m_21205_());
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (!this.m_21206_().m_41619_()) {
            this.m_19983_(this.m_21206_());
            this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
        if (!this.getConstructData().getHat().m_41619_()) {
            this.setHat(ItemStack.f_41583_);
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack invStack = this.getStackInSlot(i);
            if (invStack.m_41619_()) continue;
            this.m_19983_(invStack);
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void SpawnSmashParticles(Level world, Vec3 position) {
        double offsetZ;
        double offsetX;
        int i;
        for (i = 0; i < 10; ++i) {
            offsetX = -0.5 + Math.random();
            offsetZ = -0.5 + Math.random();
            world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setGravity(0.02f).setScale(0.1f), position.f_82479_ + offsetX, position.f_82480_, position.f_82481_ + offsetZ, -offsetX, 0.2 + 0.4 * Math.random(), -offsetZ);
        }
        for (i = 0; i < 10; ++i) {
            offsetX = -0.5 + Math.random();
            offsetZ = -0.5 + Math.random();
            world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setGravity(0.02f).setScale(0.1f), position.f_82479_ + offsetX, position.f_82480_, position.f_82481_ + offsetZ, -offsetX / 2.0, 0.2 + 0.4 * Math.random(), -offsetZ / 2.0);
        }
        for (i = 0; i < 10; ++i) {
            offsetX = -0.5 + Math.random();
            offsetZ = -0.5 + Math.random();
            world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setGravity(0.02f).setScale(0.2f), position.f_82479_ + offsetX, position.f_82480_, position.f_82481_ + offsetZ, 0.0, 0.2 + 0.4 * Math.random(), 0.0);
        }
        world.m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, SFX.Spell.Impact.AoE.EARTH, SoundSource.PLAYERS, 1.0f, 0.9f + (float)Math.random() * 0.2f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void SpawnCritParticles(Level world, Vec3 position, CompoundTag tag) {
        if (tag == null) {
            return;
        }
        int entityID = tag.m_128451_("entityID");
        Entity e = world.m_6815_(entityID);
        if (e != null) {
            Minecraft mc = Minecraft.m_91087_();
            mc.f_91061_.m_107329_(e, (ParticleOptions)ParticleTypes.f_123797_);
        }
    }

    public UUID m_21805_() {
        return this.getOwnerId();
    }

    static enum ActionFlags {
        RANGED_ATTACK(1),
        MINE_ENTER(2),
        MINE_LEAVE(4),
        CRUSH(8),
        SPRAY(16),
        WATER(32),
        FISH(64),
        FISH_END(128),
        EAT(256),
        ADVENTURE_ENTER(512),
        ADVENTURE_LEAVE(1024),
        AWAY(2048),
        CAST_SPELL_SWING(4096),
        CAST_SPELL_CHANNEL(8192),
        DEFEATED(16384),
        DEFEATED_END(32768),
        LEAP_START(65536),
        LEAP_AIRBORNE(131072),
        LEAP_LAND(262144),
        DUAL_SWEEP(524288),
        DUAL_SHOOT(0x100000),
        DUAL_SPRAY(0x200000);

        private final int flag;

        private ActionFlags(int flag) {
            this.flag = flag;
        }

        public boolean isFlagSet(int mutex) {
            return (mutex & this.flag) != 0;
        }

        int set(int actionFlags) {
            return actionFlags | this.flag;
        }

        int clear(int actionFlags) {
            return actionFlags & ~this.flag;
        }
    }

    class ConstructSwimGoal
    extends Goal {
        public ConstructSwimGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            Construct.this.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            if (!Construct.this.canSwim() || Construct.this.m_217005_()) {
                return false;
            }
            return Construct.this.m_20069_() && Construct.this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > Construct.this.m_20204_() || Construct.this.m_20077_();
        }

        public void m_8037_() {
            if (Construct.this.m_217043_().m_188501_() < 0.8f) {
                Construct.this.f_21343_.m_24901_();
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class ConstructOpenDoors
    extends ConstructDoorInteractGoal {
        private final boolean closeDoor;

        public ConstructOpenDoors(Construct construct, boolean shouldClose) {
            super(construct);
            this.mob = construct;
            this.closeDoor = shouldClose;
        }

        @Override
        public boolean m_8045_() {
            return this.closeDoor && super.m_8045_();
        }

        @Override
        public void m_8056_() {
            this.setOpen(true);
        }

        public void m_8041_() {
            this.setOpen(false);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
        }
    }
}

