/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;

public class ConstructFish
extends ConstructAITask<ConstructFish> {
    protected Direction side;
    protected BlockPos blockPos;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.FISH};
    private int fish_counter = -1;
    private int end_wait_time = -1;

    public ConstructFish(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        Level world = this.construct.asEntity().m_9236_();
        if (!world.m_46749_(this.blockPos)) {
            this.exitCode = 1;
            return;
        }
        if (this.end_wait_time > 0) {
            if (--this.end_wait_time <= 0) {
                this.construct.resetActions();
                this.exitCode = 0;
            }
            return;
        }
        if (!this.construct.isFishing()) {
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, Vec3.m_82512_((Vec3i)this.blockPos));
            this.setMoveTarget(this.blockPos);
            if (this.doMove(8.0f)) {
                if (world.m_8055_(this.blockPos).m_60734_() != Blocks.f_49990_) {
                    this.blockPos = this.blockPos.m_121955_(this.side.m_122436_());
                    if (world.m_8055_(this.blockPos).m_60734_() != Blocks.f_49990_) {
                        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.fish_not_water", new Object[0]));
                        this.forceFail();
                        return;
                    }
                }
                this.construct.setFishing(this.blockPos);
            }
        } else {
            this.setMoveTarget(this.blockPos);
            this.faceBlockPos(this.blockPos);
            this.doMove(8.0f);
            if (--this.fish_counter <= 0) {
                AbstractGolem c = this.construct.asEntity();
                this.construct.stopFishing();
                List<ItemStack> fishingLoot = this.getLootRoll(BuiltInLootTables.f_78720_, new ItemStack((ItemLike)Items.f_42523_), LootContextParamSets.f_81414_);
                for (ItemStack itemstack : fishingLoot) {
                    Vec3 center = Vec3.m_82512_((Vec3i)this.blockPos).m_82520_(0.0, 0.5, 0.0);
                    ItemEntity itementity = new ItemEntity(c.m_9236_(), center.f_82479_, center.f_82480_, center.f_82481_, itemstack);
                    double d0 = c.m_20185_() - center.f_82479_;
                    double d1 = c.m_20186_() - center.f_82480_;
                    double d2 = c.m_20189_() - center.f_82481_;
                    itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    c.m_9236_().m_7967_((Entity)itementity);
                }
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.fish_success", new Object[0]));
                this.end_wait_time = 20;
            }
        }
    }

    @Override
    public void onTaskSet() {
        super.onTaskSet();
        this.end_wait_time = -1;
        this.fish_counter = this.getInteractTime(ConstructCapability.FISH, 400);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.FISH);
    }

    @Override
    public ConstructFish duplicate() {
        return new ConstructFish(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructFish copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructFish) {
            this.blockPos = ((ConstructFish)other).blockPos;
            this.side = ((ConstructFish)other).side;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.blockPos != null) {
            nbt.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.m_128405_("direction", this.side.m_122411_());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos")) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos"));
        }
        if (nbt.m_128441_("direction")) {
            this.side = Direction.m_122376_((int)nbt.m_128451_("direction"));
        }
    }

    @Override
    public void inflateParameters() {
        this.getParameter("fish.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.blockPos = ((ConstructTaskPointParameter)param).getPosition();
                this.side = ((ConstructTaskPointParameter)param).getDirection();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter("fish.point"));
        return parameters;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null;
    }

    public static ConstructCapability[] getRequiredcaps() {
        return requiredCaps;
    }
}

