/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.entities.EntityInit;
import com.mna.entities.constructs.animated.Construct;
import com.mna.events.EventDispatcher;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemAnimusDust;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ConstructAssemblyStand
extends LivingEntity
implements ISpellInteractibleEntity<ConstructAssemblyStand> {
    public static final int WOBBLE_TIME = 5;
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.m_135353_(ConstructAssemblyStand.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    private Rotations headPose = DEFAULT_HEAD_POSE;
    private Rotations bodyPose = DEFAULT_BODY_POSE;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private Rotations leftLegPose = DEFAULT_LEFT_LEG_POSE;
    private Rotations rightLegPose = DEFAULT_RIGHT_LEG_POSE;
    private final NonNullList<ItemStack> bodyItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    public long lastHit;
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart && ((AbstractMinecart)p_31582_).canBeRidden();

    public ConstructAssemblyStand(EntityType<? extends ConstructAssemblyStand> type, Level world) {
        super(type, world);
    }

    public ConstructAssemblyStand(Level world, double x, double y, double z) {
        this((EntityType<? extends ConstructAssemblyStand>)((EntityType)EntityInit.CONSTRUCT_ASSEMBLY_STAND.get()), world);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        this.f_19804_.m_135372_(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        this.f_19804_.m_135372_(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_LEFT_LEG_POSE, (Object)DEFAULT_LEFT_LEG_POSE);
        this.f_19804_.m_135372_(DATA_RIGHT_LEG_POSE, (Object)DEFAULT_RIGHT_LEG_POSE);
    }

    public float getStepHeight() {
        return 0.0f;
    }

    public ConstructMaterial[] getComposition() {
        ArrayList materials = new ArrayList();
        this.bodyItems.forEach(is -> {
            if (is.m_41720_() instanceof ItemConstructPart) {
                materials.add(((ItemConstructPart)is.m_41720_()).getMaterial());
            }
        });
        this.armItems.forEach(is -> {
            if (is.m_41720_() instanceof ItemConstructPart) {
                materials.add(((ItemConstructPart)is.m_41720_()).getMaterial());
            }
        });
        return materials.toArray(new ConstructMaterial[0]);
    }

    public ItemConstructPart[] getPartsForMaterial(ConstructMaterial matl) {
        ArrayList parts = new ArrayList();
        this.bodyItems.forEach(is -> {
            if (is.m_41720_() instanceof ItemConstructPart && ((ItemConstructPart)is.m_41720_()).getMaterial() == matl) {
                parts.add((ItemConstructPart)is.m_41720_());
            }
        });
        this.armItems.forEach(is -> {
            if (is.m_41720_() instanceof ItemConstructPart && ((ItemConstructPart)is.m_41720_()).getMaterial() == matl) {
                parts.add((ItemConstructPart)is.m_41720_());
            }
        });
        return parts.toArray(new ItemConstructPart[0]);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.m_20068_();
    }

    public boolean m_21515_() {
        return super.m_21515_() && this.hasPhysics();
    }

    public Iterable<ItemStack> m_6167_() {
        return this.armItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.bodyItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        switch (slot) {
            case LEGS: 
            case CHEST: 
            case HEAD: {
                return (ItemStack)this.bodyItems.get(slot.m_20749_());
            }
            case MAINHAND: 
            case OFFHAND: {
                return (ItemStack)this.armItems.get(slot.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        if (!stack.m_41619_()) {
            this.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
        }
        if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
            this.armItems.set(slot.m_20749_(), (Object)stack);
        } else {
            this.bodyItems.set(slot.m_20749_(), (Object)stack);
        }
    }

    public boolean m_7066_(ItemStack p_31638_) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)p_31638_);
        return this.m_6844_(equipmentslot).m_41619_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.bodyItems) {
            CompoundTag compoundtag = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundtag);
            }
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.armItems) {
            CompoundTag compoundtag1 = new CompoundTag();
            if (!itemstack1.m_41619_()) {
                itemstack1.m_41739_(compoundtag1);
            }
            listtag1.add((Object)compoundtag1);
        }
        tag.m_128365_("HandItems", (Tag)listtag1);
        tag.m_128365_("Pose", (Tag)this.writePose());
    }

    public void m_7378_(CompoundTag p_31600_) {
        super.m_7378_(p_31600_);
        if (p_31600_.m_128425_("ArmorItems", 9)) {
            ListTag listtag = p_31600_.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.bodyItems.size(); ++i) {
                this.bodyItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        if (p_31600_.m_128425_("HandItems", 9)) {
            ListTag listtag1 = p_31600_.m_128437_("HandItems", 10);
            for (int j = 0; j < this.armItems.size(); ++j) {
                this.armItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)listtag1.m_128728_(j)));
            }
        }
        this.f_19794_ = !this.hasPhysics();
        CompoundTag compoundtag = p_31600_.m_128469_("Pose");
        this.readPose(compoundtag);
    }

    private void readPose(CompoundTag p_31658_) {
        ListTag listtag = p_31658_.m_128437_("Head", 5);
        this.setHeadPose(listtag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listtag));
        ListTag listtag1 = p_31658_.m_128437_("Body", 5);
        this.setBodyPose(listtag1.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(listtag1));
        ListTag listtag2 = p_31658_.m_128437_("LeftArm", 5);
        this.setLeftArmPose(listtag2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listtag2));
        ListTag listtag3 = p_31658_.m_128437_("RightArm", 5);
        this.setRightArmPose(listtag3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listtag3));
        ListTag listtag4 = p_31658_.m_128437_("LeftLeg", 5);
        this.setLeftLegPose(listtag4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(listtag4));
        ListTag listtag5 = p_31658_.m_128437_("RightLeg", 5);
        this.setRightLegPose(listtag5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(listtag5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundtag = new CompoundTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundtag.m_128365_("Head", (Tag)this.headPose.m_123155_());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            compoundtag.m_128365_("Body", (Tag)this.bodyPose.m_123155_());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            compoundtag.m_128365_("LeftArm", (Tag)this.leftArmPose.m_123155_());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            compoundtag.m_128365_("RightArm", (Tag)this.rightArmPose.m_123155_());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals((Object)this.leftLegPose)) {
            compoundtag.m_128365_("LeftLeg", (Tag)this.leftLegPose.m_123155_());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals((Object)this.rightLegPose)) {
            compoundtag.m_128365_("RightLeg", (Tag)this.rightLegPose.m_123155_());
        }
        return compoundtag;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_31564_) {
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), RIDABLE_MINECARTS);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public void m_8119_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.m_8119_();
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
        if (!this.bodyPose.equals((Object)(rotations1 = (Rotations)this.f_19804_.m_135370_(DATA_BODY_POSE)))) {
            this.setBodyPose(rotations1);
        }
        if (!this.leftArmPose.equals((Object)(rotations2 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(rotations2);
        }
        if (!this.rightArmPose.equals((Object)(rotations3 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rotations3);
        }
        if (!this.leftLegPose.equals((Object)(rotations4 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_LEG_POSE)))) {
            this.setLeftLegPose(rotations4);
        }
        if (!this.rightLegPose.equals((Object)(rotations5 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_LEG_POSE)))) {
            this.setRightLegPose(rotations5);
        }
    }

    public InteractionResult m_7111_(Player p_31594_, Vec3 p_31595_, InteractionHand p_31596_) {
        ItemStack itemstack = p_31594_.m_21120_(p_31596_);
        if (p_31594_.m_5833_()) {
            return InteractionResult.SUCCESS;
        }
        if (p_31594_.m_9236_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_41720_() instanceof ItemConstructPart) {
            EquipmentSlot equipmentslot1;
            EquipmentSlot slot = EquipmentSlot.FEET;
            switch (((ItemConstructPart)itemstack.m_41720_()).getSlot()) {
                case HEAD: {
                    slot = EquipmentSlot.HEAD;
                    break;
                }
                case LEFT_ARM: {
                    slot = EquipmentSlot.MAINHAND;
                    break;
                }
                case LEGS: {
                    slot = EquipmentSlot.LEGS;
                    break;
                }
                case RIGHT_ARM: {
                    slot = EquipmentSlot.OFFHAND;
                    break;
                }
                case TORSO: {
                    slot = EquipmentSlot.CHEST;
                }
            }
            if (itemstack.m_41619_() ? this.m_21033_(equipmentslot1 = this.getClickedSlot(p_31595_)) && this.swapItem(p_31594_, equipmentslot1, itemstack, p_31596_) : this.swapItem(p_31594_, slot, itemstack, p_31596_)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (itemstack.m_41720_() == ItemInit.ANIMUS_DUST.get()) {
            this.summonConstruct(p_31594_);
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isConstructComplete() {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        parts.add(this.m_6844_(EquipmentSlot.HEAD));
        parts.add(this.m_6844_(EquipmentSlot.CHEST));
        parts.add(this.m_6844_(EquipmentSlot.MAINHAND));
        parts.add(this.m_6844_(EquipmentSlot.OFFHAND));
        parts.add(this.m_6844_(EquipmentSlot.LEGS));
        return parts.stream().allMatch(is -> !is.m_41619_() && is.m_41720_() instanceof ItemConstructPart);
    }

    private void summonConstruct(Player player) {
        if (!this.isConstructComplete()) {
            return;
        }
        if (this.m_9236_().m_5776_() || player.m_36316_() == null || player.m_36316_().getId() == null) {
            ItemAnimusDust.spawnParticles(this.m_9236_(), this.m_20183_());
            return;
        }
        Construct construct = new Construct(this.m_9236_());
        construct.setConstructParts(this.m_6844_(EquipmentSlot.HEAD), this.m_6844_(EquipmentSlot.CHEST), this.m_6844_(EquipmentSlot.MAINHAND), this.m_6844_(EquipmentSlot.OFFHAND), this.m_6844_(EquipmentSlot.LEGS));
        Vec3 fwd = this.m_20156_().m_82541_();
        construct.m_7678_(this.m_20185_() + fwd.f_82479_, this.m_20186_() + fwd.f_82480_, this.m_20189_() + fwd.f_82481_, 0.0f, 0.0f);
        construct.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(fwd.m_82490_(10.0)));
        construct.setOwner(player.m_36316_().getId());
        this.m_9236_().m_7967_((Entity)construct);
        EventDispatcher.DispatchConstructCrafted((Entity)construct, player);
        if (player instanceof ServerPlayer) {
            CustomAdvancementTriggers.SUMMON_CONSTRUCT.trigger((ServerPlayer)player, construct);
        }
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.brokenByPlayer(this.m_269291_().m_269264_());
        this.m_6074_();
    }

    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        double d0 = p_31660_.f_82480_;
        EquipmentSlot equipmentslot1 = EquipmentSlot.LEGS;
        if (d0 >= 0.1 && d0 < 0.55 && this.m_21033_(equipmentslot1)) {
            equipmentslot = EquipmentSlot.LEGS;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentslot = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentslot = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentslot = EquipmentSlot.HEAD;
        } else if (!this.m_21033_(EquipmentSlot.MAINHAND) && this.m_21033_(EquipmentSlot.OFFHAND)) {
            equipmentslot = EquipmentSlot.OFFHAND;
        }
        return equipmentslot;
    }

    private boolean swapItem(Player player, EquipmentSlot slot, ItemStack insert, InteractionHand hand) {
        ItemStack itemstack = this.m_6844_(slot);
        if (player.m_150110_().f_35937_ && itemstack.m_41619_() && !insert.m_41619_()) {
            ItemStack itemstack2 = insert.m_41777_();
            itemstack2.m_41764_(1);
            this.m_8061_(slot, itemstack2);
            return true;
        }
        if (!insert.m_41619_() && insert.m_41613_() > 1) {
            if (!itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = insert.m_41777_();
            itemstack1.m_41764_(1);
            this.m_8061_(slot, itemstack1);
            insert.m_41774_(1);
            return true;
        }
        this.m_8061_(slot, insert);
        player.m_21008_(hand, itemstack);
        return true;
    }

    public boolean m_6469_(DamageSource p_31579_, float p_31580_) {
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            if (p_31579_.m_276093_(DamageTypes.f_268724_)) {
                this.m_6074_();
                return false;
            }
            if (!this.m_6673_(p_31579_)) {
                if (p_31579_.m_269533_(DamageTypeTags.f_268415_)) {
                    this.brokenByAnything(p_31579_);
                    this.m_6074_();
                    return false;
                }
                if (p_31579_.m_276093_(DamageTypes.f_268631_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(p_31579_, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (p_31579_.m_276093_(DamageTypes.f_268468_) && this.m_21223_() > 0.5f) {
                    this.causeDamage(p_31579_, 4.0f);
                    return false;
                }
                boolean flag = p_31579_.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)p_31579_.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(p_31579_.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                if (p_31579_.m_7639_() instanceof Player && !((Player)p_31579_.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (p_31579_.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return flag1;
                }
                long i = this.m_9236_().m_46467_();
                if (i - this.lastHit > 5L && !flag) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, p_31579_.m_7639_());
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(p_31579_);
                    this.showBreakingParticles();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_7822_(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(p_31568_);
        }
    }

    public boolean m_6783_(double p_31574_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_31574_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource p_31649_, float p_31650_) {
        float f = this.m_21223_();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_31649_);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_223706_, p_31649_.m_7639_());
        }
    }

    private void brokenByPlayer(DamageSource p_31647_) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)Items.f_42650_));
        this.brokenByAnything(p_31647_);
    }

    private void brokenByAnything(DamageSource p_31654_) {
        this.playBrokenSound();
        this.m_6668_(p_31654_);
        for (int i = 0; i < this.armItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.armItems.get(i);
            if (itemstack.m_41619_()) continue;
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_().m_7494_(), (ItemStack)itemstack);
            this.armItems.set(i, (Object)ItemStack.f_41583_);
        }
        for (int j = 0; j < this.bodyItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.bodyItems.get(j);
            if (itemstack1.m_41619_()) continue;
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_().m_7494_(), (ItemStack)itemstack1);
            this.bodyItems.set(j, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_6431_(Pose p_31614_, EntityDimensions p_31615_) {
        return p_31615_.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_7023_(Vec3 p_31656_) {
        if (this.hasPhysics()) {
            super.m_7023_(p_31656_);
        }
    }

    public void m_5618_(float p_31670_) {
        this.f_20884_ = this.f_19859_ = p_31670_;
        this.f_20886_ = this.f_20885_ = p_31670_;
    }

    public void m_5616_(float p_31668_) {
        this.f_20884_ = this.f_19859_ = p_31668_;
        this.f_20886_ = this.f_20885_ = p_31668_;
    }

    public void setHeadPose(Rotations p_31598_) {
        this.headPose = p_31598_;
        this.f_19804_.m_135381_(DATA_HEAD_POSE, (Object)p_31598_);
    }

    public void setBodyPose(Rotations p_31617_) {
        this.bodyPose = p_31617_;
        this.f_19804_.m_135381_(DATA_BODY_POSE, (Object)p_31617_);
    }

    public void setLeftArmPose(Rotations p_31624_) {
        this.leftArmPose = p_31624_;
        this.f_19804_.m_135381_(DATA_LEFT_ARM_POSE, (Object)p_31624_);
    }

    public void setRightArmPose(Rotations p_31629_) {
        this.rightArmPose = p_31629_;
        this.f_19804_.m_135381_(DATA_RIGHT_ARM_POSE, (Object)p_31629_);
    }

    public void setLeftLegPose(Rotations p_31640_) {
        this.leftLegPose = p_31640_;
        this.f_19804_.m_135381_(DATA_LEFT_LEG_POSE, (Object)p_31640_);
    }

    public void setRightLegPose(Rotations p_31652_) {
        this.rightLegPose = p_31652_;
        this.f_19804_.m_135381_(DATA_RIGHT_LEG_POSE, (Object)p_31652_);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7313_(Entity p_31687_) {
        return p_31687_ instanceof Player && !this.m_9236_().m_7966_((Player)p_31687_, this.m_20183_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_31636_) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42650_);
    }

    public static boolean checkAndConvert(ArmorStand stand, ItemStack clickedWith, Player player, InteractionHand hand) {
        if (stand.m_9236_().m_5776_() || !(clickedWith.m_41720_() instanceof ItemConstructPart)) {
            return false;
        }
        MutableBoolean allEmpty = new MutableBoolean(true);
        stand.m_6167_().forEach(is -> {
            if (!is.m_41619_()) {
                allEmpty.setFalse();
            }
        });
        stand.m_6168_().forEach(is -> {
            if (!is.m_41619_()) {
                allEmpty.setFalse();
            }
        });
        if (!allEmpty.getValue().booleanValue()) {
            return false;
        }
        Vec3 pos = stand.m_20182_();
        ConstructAssemblyStand conStand = new ConstructAssemblyStand(stand.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        conStand.m_7678_(stand.m_20185_(), stand.m_20186_(), stand.m_20189_(), stand.m_146908_(), 0.0f);
        stand.m_9236_().m_7967_((Entity)conStand);
        stand.m_142687_(Entity.RemovalReason.DISCARDED);
        EquipmentSlot slot = EquipmentSlot.FEET;
        switch (((ItemConstructPart)clickedWith.m_41720_()).getSlot()) {
            case HEAD: {
                slot = EquipmentSlot.HEAD;
                break;
            }
            case LEFT_ARM: {
                slot = EquipmentSlot.MAINHAND;
                break;
            }
            case LEGS: {
                slot = EquipmentSlot.LEGS;
                break;
            }
            case RIGHT_ARM: {
                slot = EquipmentSlot.OFFHAND;
                break;
            }
            case TORSO: {
                slot = EquipmentSlot.CHEST;
            }
        }
        conStand.swapItem(player, slot, clickedWith, hand);
        return true;
    }

    @Override
    public boolean onShapeTarget(ISpellDefinition spell, SpellSource source) {
        if (source.isPlayerCaster() && spell.getComponents().stream().anyMatch(c -> c.getPart() == Components.ANIMUS || c.getPart() == Components.GREATER_ANIMUS)) {
            this.summonConstruct(source.getPlayer());
            return false;
        }
        return true;
    }
}

