/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.EntityInit;
import com.mna.items.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class BubbleBoat
extends Boat {
    private static final EntityDataAccessor<Byte> UPGRADE = SynchedEntityData.m_135353_(BubbleBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private float boatRotation = 0.0f;
    private float prevBoatRotation = 0.0f;

    public BubbleBoat(EntityType<? extends BubbleBoat> p_i50129_1_, Level p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.f_19850_ = true;
    }

    public float getBoatRotation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevBoatRotation, (float)this.boatRotation);
    }

    public BubbleBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends BubbleBoat>)((EntityType)EntityInit.BUBBLE_BOAT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public BubbleBoat setBrimstone() {
        this.f_19804_.m_135381_(UPGRADE, (Object)1);
        return this;
    }

    public boolean isBrimstone() {
        return (Byte)this.f_19804_.m_135370_(UPGRADE) == 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UPGRADE, (Object)0);
    }

    public void m_8119_() {
        this.underwaterControl();
        this.handleSpecialLavaProperties();
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.m_20197_().size() > 0 && this.f_38279_ != Boat.Status.IN_AIR && this.f_38279_ != Boat.Status.ON_LAND) {
            float RADIUS = 3.0f;
            Vec3 OFFSET = new Vec3(-1.0, -0.25, -1.0);
            Vec3 VELOCITY = new Vec3((double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
            int amount = (int)Math.ceil(this.m_20184_().m_82553_() * 25.0);
            for (int i = 0; i < amount; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), OFFSET.f_82479_ + this.m_20185_() + Math.random() * (double)RADIUS, OFFSET.f_82480_ + this.m_20186_() + Math.random() * (double)RADIUS, OFFSET.f_82481_ + this.m_20189_() + Math.random() * (double)RADIUS, VELOCITY.f_82479_, VELOCITY.f_82480_, VELOCITY.f_82481_);
            }
        }
        this.prevBoatRotation = this.boatRotation;
        if (this.m_20197_().size() > 0) {
            double motionMagnitude = this.m_20184_().m_82553_() * 0.25;
            if (motionMagnitude > 0.001) {
                this.boatRotation = (float)((double)this.boatRotation - motionMagnitude);
                this.boatRotation = (float)((double)this.boatRotation % (Math.PI * 2));
            }
        } else {
            double halfPi = 1.5707963267948966;
            this.boatRotation -= 0.1f;
            if ((double)Math.abs(this.boatRotation) % halfPi <= (double)0.1f) {
                this.boatRotation = 0.0f;
                this.prevBoatRotation = 0.0f;
            }
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return true;
        }
        if (type == ForgeMod.LAVA_TYPE.get()) {
            return this.isBrimstone();
        }
        return false;
    }

    public boolean m_6128_() {
        if (this.isBrimstone()) {
            return true;
        }
        return super.m_6128_();
    }

    public boolean m_5825_() {
        if (this.isBrimstone()) {
            return true;
        }
        return super.m_5825_();
    }

    public boolean m_6051_() {
        if (this.isBrimstone()) {
            return false;
        }
        return super.m_6051_();
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.m_20077_() && this.isBrimstone()) {
            this.f_19789_ = 0.0f;
        }
        super.m_7840_(y, onGroundIn, state, pos);
    }

    private void underwaterControl() {
        this.f_38265_ = 0.0f;
        if ((this.f_38279_ == Boat.Status.UNDER_WATER || this.f_38279_ == Boat.Status.UNDER_FLOWING_WATER) && this.m_20197_().size() > 0) {
            double yVel = Math.min(this.m_20184_().f_82480_ + (double)0.2f, 2.0);
            this.m_20256_(new Vec3(this.m_20184_().f_82479_, yVel, this.m_20184_().f_82481_));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Item m_38369_() {
        return (Byte)this.f_19804_.m_135370_(UPGRADE) == 0 ? (Item)ItemInit.BUBBLE_BOAT.get() : (Item)ItemInit.BRIMSTONE_BOAT.get();
    }

    private void handleSpecialLavaProperties() {
        if (this.m_20077_()) {
            this.m_20197_().forEach(e -> {
                if (e instanceof LivingEntity && (((LivingEntity)e).m_21124_(MobEffects.f_19607_) == null || ((LivingEntity)e).m_21124_(MobEffects.f_19607_).m_19557_() < 20)) {
                    ((LivingEntity)e).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200));
                }
            });
            this.m_6853_(false);
            CollisionContext iselectioncontext = CollisionContext.m_82750_((Entity)this);
            if (iselectioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ * 0.5 + 0.05, this.m_20184_().f_82481_);
            }
        }
    }

    public float getStepHeight() {
        if (this.m_20077_()) {
            return 2.0f;
        }
        return 1.0f;
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 1;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return 0.3;
    }
}

