/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.worlddata;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.blocks.PlayerOwnershipRecord;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InterdictionData {
    private final PlayerOwnershipRecord owner;
    private final AABB bounds;
    private final boolean in;
    private final boolean affect_allied_factions;

    public InterdictionData(PlayerOwnershipRecord owner, AABB bounds, boolean in, boolean affect_allied_factions) {
        this.owner = owner;
        this.bounds = bounds;
        this.in = in;
        this.affect_allied_factions = affect_allied_factions;
    }

    public boolean getDirection() {
        return this.in;
    }

    public boolean isAlly(LivingEntity other) {
        if (this.owner == null) {
            return false;
        }
        this.owner.refresh(other.m_9236_());
        if (other instanceof IFactionEnemy) {
            IFactionEnemy factionMob = (IFactionEnemy)other;
            if (this.owner.getFaction() != null && factionMob.getFaction() == this.owner.getFaction()) {
                return true;
            }
        }
        if (other instanceof Player) {
            IPlayerProgression progression;
            Player player = (Player)other;
            if (this.owner.getPlayerProfileID().equals(player.m_36316_().getId())) {
                return true;
            }
            if (this.owner.getTeam() != null && player.m_5647_() != null && this.owner.getTeam() == player.m_5647_().m_5758_()) {
                return true;
            }
            if (!this.affect_allied_factions && (progression = (IPlayerProgression)player.getCapability(ManaAndArtificeMod.getProgressionCapability()).orElse(null)) != null) {
                IFaction ownerFaction = this.owner.getFaction();
                IFaction playerFaction = progression.getAlliedFaction();
                if (ownerFaction != null && playerFaction != null && ownerFaction.isAlliedTo(playerFaction)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean includes(Vec3 pos) {
        return this.bounds.m_82390_(pos);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("owner", (Tag)this.owner.save(null));
        tag.m_128347_("aabbcx", this.bounds.m_82399_().f_82479_);
        tag.m_128347_("aabbcy", this.bounds.m_82399_().f_82480_);
        tag.m_128347_("aabbcz", this.bounds.m_82399_().f_82481_);
        tag.m_128347_("aabbsx", this.bounds.m_82362_());
        tag.m_128347_("aabbsy", this.bounds.m_82376_());
        tag.m_128347_("aabbsz", this.bounds.m_82385_());
        tag.m_128379_("in", this.in);
        tag.m_128379_("faction", this.affect_allied_factions);
        return tag;
    }

    public static InterdictionData of(CompoundTag tag) {
        PlayerOwnershipRecord rec = PlayerOwnershipRecord.of(tag.m_128469_("owner"));
        AABB bounds = AABB.m_165882_((Vec3)new Vec3(tag.m_128459_("aabbcx"), tag.m_128459_("aabbcy"), tag.m_128459_("aabbcz")), (double)tag.m_128459_("aabbsx"), (double)tag.m_128459_("aabbsy"), (double)tag.m_128459_("aabbsz"));
        return new InterdictionData(rec, bounds, tag.m_128471_("in"), tag.m_128471_("faction"));
    }
}

