/*
 * Decompiled with CFR 0.152.
 */
package com.mna.cantrips;

import com.google.common.collect.Lists;
import com.mna.ManaAndArtifice;
import com.mna.api.cantrips.ICantrip;
import com.mna.api.cantrips.ICantripRegistry;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.api.tools.RLoc;
import com.mna.cantrips.Cantrip;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.utility.PresentItem;
import com.mna.entities.utility.SpellFX;
import com.mna.items.ItemInit;
import com.mna.items.manaweaving.ItemManaweaverWand;
import com.mna.spells.SpellCaster;
import com.mna.spells.components.ComponentGust;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.BlockUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class CantripRegistry
implements ICantripRegistry {
    private static ItemStack IGNITE_CANTRIP_SPELL = new ItemStack((ItemLike)ItemInit.SPELL.get());
    private static ItemStack TRANSMUTE_CANTRIP_SPELL = new ItemStack((ItemLike)ItemInit.SPELL.get());
    private List<ICantrip> cantrips = new ArrayList<ICantrip>();
    public static final CantripRegistry INSTANCE = new CantripRegistry();

    public CantripRegistry() {
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(Shapes.TOUCH);
        recipe.addComponent(Components.FIRE_DAMAGE);
        recipe.changeComponentAttributeValue(0, Attribute.DAMAGE, 0.0f);
        recipe.writeToNBT(IGNITE_CANTRIP_SPELL.m_41784_());
        IGNITE_CANTRIP_SPELL.m_41783_().m_128379_("default_cantrip", true);
        recipe = new SpellRecipe();
        recipe.setShape(Shapes.TOUCH);
        recipe.addComponent(Components.TRANSMUTE);
        recipe.changeShapeAttributeValue(Attribute.RADIUS, 1.0f);
        recipe.writeToNBT(TRANSMUTE_CANTRIP_SPELL.m_41784_());
        TRANSMUTE_CANTRIP_SPELL.m_41783_().m_128379_("default_cantrip", true);
        this.registerCantrip(RLoc.create("ignite"), RLoc.create("textures/gui/cantrips/ignite.png"), 1, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), IGNITE_CANTRIP_SPELL, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/triangle")).setRequiredAdvancement(RLoc.create("tier_1/advance_tier_2"));
        this.registerCantrip(RLoc.create("transmute"), RLoc.create("textures/gui/cantrips/transmute.png"), 1, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), TRANSMUTE_CANTRIP_SPELL, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/square"));
        this.registerCantrip(RLoc.create("halp"), RLoc.create("textures/gui/cantrips/halp.png"), 1, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::firework), ItemStack.f_41583_, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/slash")).dynamicItem(Items.f_42688_);
        this.registerCantrip(RLoc.create("gust"), RLoc.create("textures/gui/cantrips/gust.png"), 1, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::gust), ItemStack.f_41583_, RLoc.create("manaweave_patterns/slash"), RLoc.create("manaweave_patterns/backslash"));
        this.registerCantrip(RLoc.create("dispel"), RLoc.create("textures/gui/cantrips/dispel.png"), 2, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::dispel), ItemStack.f_41583_, RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/triangle"));
        this.registerCantrip(RLoc.create("drought"), RLoc.create("textures/gui/cantrips/drought.png"), 2, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::drought), ItemStack.f_41583_, RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/circle"));
        this.registerCantrip(RLoc.create("grimoire"), RLoc.create("textures/gui/cantrips/grimoire.png"), 3, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::summonGrimoire), ItemStack.f_41583_, RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/inverted_triangle"));
        this.registerCantrip(RLoc.create("faction_grimoire"), RLoc.create("textures/gui/cantrips/grimoire2.png"), 4, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::summonFactionGrimoire), ItemStack.f_41583_, RLoc.create("manaweave_patterns/hourglass"), RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/inverted_triangle"));
        this.registerCantrip(RLoc.create("freeform_spell_a"), RLoc.create("textures/gui/cantrips/chevron_1.png"), 3, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.f_41583_, RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/circle")).dynamicItem((Item)ItemInit.SPELL.get());
        this.registerCantrip(RLoc.create("freeform_spell_b"), RLoc.create("textures/gui/cantrips/chevron_2.png"), 4, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.f_41583_, RLoc.create("manaweave_patterns/diamond"), RLoc.create("manaweave_patterns/square")).dynamicItem((Item)ItemInit.SPELL.get());
        this.registerCantrip(RLoc.create("freeform_spell_c"), RLoc.create("textures/gui/cantrips/chevron_3.png"), 5, (TriConsumer<Player, ICantrip, InteractionHand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.f_41583_, RLoc.create("manaweave_patterns/knot2"), RLoc.create("manaweave_patterns/split_triangle")).dynamicItem((Item)ItemInit.SPELL.get());
    }

    @Override
    public ICantrip registerCantrip(ResourceLocation id, ResourceLocation icon, int tier, TriConsumer<Player, ICantrip, InteractionHand> effector, ItemStack spell, ResourceLocation ... defaultCombination) {
        if (this.cantrips.stream().anyMatch(c -> c.getId().equals((Object)id))) {
            ManaAndArtifice.LOGGER.error("Attempted to register duplicate cantrips with id " + id);
            return null;
        }
        ICantrip c2 = new Cantrip(id, effector, spell, defaultCombination).setTier(tier).setDelay(60).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH).setIcon(icon);
        this.cantrips.add(c2);
        return c2;
    }

    public static void applySpellAtTargetOnDelay(Player player, ICantrip cantrip, InteractionHand hand) {
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().getCantrip(cantrip.getId()).ifPresent(c -> {
            SpellRecipe spell = SpellRecipe.fromNBT(c.getStack().m_41783_());
            if (spell.isValid()) {
                DelayedEventQueue.pushEvent(player.m_9236_(), new TimedDelayedEvent<Triple>(player.m_20148_().toString() + "cantrip", 60, Triple.of((Object)player, (Object)cantrip, (Object)hand), CantripRegistry::applySpellAtTarget));
            }
        }));
    }

    public static void applySpellAtTarget(String id, Triple<Player, ICantrip, InteractionHand> data) {
        if (data.getLeft() == null || data.getMiddle() == null) {
            return;
        }
        InteractionHand checkHand = ((Player)data.getLeft()).m_7655_();
        if (!(((Player)data.getLeft()).m_21120_(checkHand).m_41720_() instanceof ItemManaweaverWand)) {
            InteractionHand interactionHand = checkHand = checkHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if (!(((Player)data.getLeft()).m_21120_(checkHand).m_41720_() instanceof ItemManaweaverWand)) {
                ((Player)data.getLeft()).m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.cantrip_wand_removed"));
                return;
            }
        }
        InteractionHand useHand = checkHand;
        ((Player)data.getLeft()).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().getCantrip(((ICantrip)data.getMiddle()).getId()).ifPresent(c -> {
            CompoundTag tag = c.getStack().m_41783_();
            boolean isDefaultCantrip = tag.m_128471_("default_cantrip");
            SpellRecipe recipe = SpellRecipe.fromNBT(tag);
            if (recipe.isValid()) {
                if (!isDefaultCantrip) {
                    ((ModifiedSpellPart)recipe.getShape()).getContainedAttributes().forEach(a -> ((ModifiedSpellPart)recipe.getShape()).resetValueToDefault((Attribute)((Object)((Object)((Object)a)))));
                    recipe.iterateComponents(comp -> comp.getContainedAttributes().forEach(a -> comp.resetValueToDefault((Attribute)((Object)((Object)((Object)((Object)a)))))));
                }
                if (!((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isChanneled() && recipe.getReagents((Player)data.getLeft(), null, null).size() == 0) {
                    SpellCaster.Affect(c.getStack(), recipe, ((Player)data.getLeft()).m_9236_(), new SpellSource((LivingEntity)data.getLeft(), useHand));
                }
            }
        }));
    }

    public static void summonGrimoire(Player player, ICantrip cantrip, InteractionHand hand) {
        Vec3 vec = player.m_20299_(0.0f).m_82549_(player.m_20154_().m_82490_(2.0));
        PresentItem entity = new PresentItem(player.m_9236_(), vec.f_82479_, vec.f_82480_ - 0.5, vec.f_82481_, new ItemStack((ItemLike)ItemInit.GRIMOIRE.get()));
        entity.m_32060_();
        player.m_9236_().m_7967_((Entity)entity);
    }

    public static void summonFactionGrimoire(Player player, ICantrip cantrip, InteractionHand hand) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            IFaction f = p.getAlliedFaction();
            ItemStack stack = f.getFactionGrimoire();
            if (stack.m_41619_()) {
                player.m_213846_((Component)Component.m_237115_((String)"cantrip.mna.faction_grimoire_nofaction"));
                return;
            }
            Vec3 vec = player.m_20299_(0.0f).m_82549_(player.m_20154_().m_82490_(2.0));
            PresentItem entity = new PresentItem(player.m_9236_(), vec.f_82479_, vec.f_82480_ - 0.5, vec.f_82481_, stack);
            entity.m_32060_();
            player.m_9236_().m_7967_((Entity)entity);
        });
    }

    public static void dispel(Player player, ICantrip cantrip, InteractionHand hand) {
        player.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(Shapes.SELF);
        recipe.addComponent(Components.TRUE_INVISIBILITY);
        SpellFX fx = new SpellFX((EntityType)EntityInit.SPELL_FX.get(), player.m_9236_());
        fx.setCasterUUID((LivingEntity)player);
        fx.setRecipe(recipe);
        fx.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        player.m_9236_().m_7967_((Entity)fx);
    }

    public static void drought(Player player, ICantrip cantrip, InteractionHand hand) {
        Level world = player.m_9236_();
        BlockPos pos = player.m_20183_();
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = world.m_8055_(blockpos1);
                FluidState fluidstate = world.m_6425_(blockpos1);
                if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                if (blockstate.m_60734_() instanceof BucketPickup && ((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)world, blockpos1, blockstate) != ItemStack.f_41583_) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    world.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!ComponentGust.BlockStateIsGustable(blockstate)) continue;
                BlockEntity tileentity = blockstate.m_155947_() ? world.m_7702_(blockpos1) : null;
                Block.m_49892_((BlockState)blockstate, (LevelAccessor)world, (BlockPos)blockpos1, (BlockEntity)tileentity);
                world.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
    }

    public static void gust(Player player, ICantrip cantrip, InteractionHand hand) {
        if (!player.m_9236_().m_5776_()) {
            int radius = 4;
            int height = 2;
            for (int i = -radius; i <= radius; ++i) {
                for (int k = -radius; k <= radius; ++k) {
                    for (int j = 0; j < height; ++j) {
                        BlockPos pos = player.m_20183_().m_7918_(i, j, k);
                        BlockState state = player.m_9236_().m_8055_(pos);
                        if (!ComponentGust.BlockStateIsGustable(state) || !BlockUtils.destroyBlock((LivingEntity)player, player.m_9236_(), pos, true, (Tier)Tiers.WOOD)) continue;
                        BlockUtils.updateBlockState(player.m_9236_(), pos);
                    }
                }
            }
        }
    }

    public static void firework(Player player, ICantrip cantrip, InteractionHand hand) {
        Vec3 vec = player.m_20182_().m_82549_(player.m_20156_().m_82541_().m_82490_(4.0)).m_82520_(0.0, 1.0, 0.0);
        MutableObject fireworkStack = new MutableObject((Object)ItemStack.f_41583_);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().getCantrip(cantrip.getId()).ifPresent(c -> fireworkStack.setValue((Object)c.getStack())));
        if (((ItemStack)fireworkStack.getValue()).m_41619_() || ((ItemStack)fireworkStack.getValue()).m_41720_() != Items.f_42688_) {
            ItemStack defaultStack = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag explosion = new CompoundTag();
            CompoundTag fw = defaultStack.m_41698_("Fireworks");
            DyeColor explosionColor = DyeColor.values()[(int)(Math.random() * (double)DyeColor.values().length)];
            DyeColor explosionFade = DyeColor.values()[(int)(Math.random() * (double)DyeColor.values().length)];
            explosion.m_128344_("Type", (byte)0);
            explosion.m_128385_("Colors", new int[]{explosionColor.m_41070_()});
            explosion.m_128385_("FadeColors", new int[]{explosionFade.m_41070_()});
            fw.m_128344_("Flight", (byte)2);
            ListTag explosions = new ListTag();
            explosions.add((Object)explosion);
            fw.m_128365_("Explosions", (Tag)explosions);
            fireworkStack.setValue((Object)defaultStack);
        }
        FireworkRocketEntity firework = new FireworkRocketEntity(player.m_9236_(), null, vec.f_82479_, vec.f_82480_, vec.f_82481_, (ItemStack)fireworkStack.getValue());
        player.m_9236_().m_7967_((Entity)firework);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 1, false, false));
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.hasAlliedFaction() && p.getAllyCooldown() <= 0) {
                p.summonRandomAlly(player);
            }
        });
    }

    @Override
    public int countRegisteredCantrips() {
        return this.cantrips.size();
    }

    @Override
    @Nullable
    public Optional<ICantrip> getCantrip(ResourceLocation cantripID) {
        return this.cantrips.stream().filter(c -> c.getId().equals((Object)cantripID)).findFirst();
    }

    @Override
    public List<ICantrip> getCantrips() {
        return this.cantrips;
    }

    @Override
    public List<ICantrip> getCantrips(Player player) {
        int tier = 0;
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression != null) {
            tier = progression.getTier();
        }
        int resolvedTier = tier;
        return this.getCantrips().stream().filter(c -> {
            if (c.getTier() > resolvedTier) {
                return false;
            }
            return c.getRequiredAdvancement() == null || ManaAndArtifice.instance.proxy.playerHasAdvancement(player, c.getRequiredAdvancement());
        }).collect(Collectors.toList());
    }

    @Override
    public List<ICantrip> getCantrips(int tier) {
        return this.getCantrips().stream().filter(c -> c.getTier() <= tier && c.getRequiredAdvancement() == null).collect(Collectors.toList());
    }
}

