/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.items.sorcery.ItemTornJournalPage;
import com.mna.spells.SpellCaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class StudyDeskTile
extends WizardLabTile
implements IEldrinConsumerTile {
    public static final int SLOT_THESIS = 0;
    public static final int INVENTORY_SIZE = 1;

    public StudyDeskTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public StudyDeskTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.STUDY_DESK.get(), pos, state, 1);
    }

    @Override
    public boolean canActivate(Player player) {
        boolean base = this.canContinue();
        if (!base) {
            return false;
        }
        return this.getCantStartReason(player) == CantStartReason.NONE;
    }

    @Override
    protected boolean canContinue() {
        return this.hasStack(0);
    }

    @Override
    public float getPctComplete() {
        return this.hasStack(0) ? 1.0f : 0.0f;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(new Integer[0]);
    }

    @Override
    protected boolean canActiveTick() {
        return true;
    }

    @Override
    protected void onComplete() {
        ItemStack thesis = this.m_8020_(0);
        Player crafter = this.getCrafter();
        if (thesis.m_41619_() || crafter == null) {
            return;
        }
        HashMap<ISpellComponent, Float> partsToRote = new HashMap<ISpellComponent, Float>();
        if (thesis.m_41720_() instanceof ItemTornJournalPage && !this.m_58904_().m_5776_()) {
            ISpellComponent component = ((ItemTornJournalPage)thesis.m_41720_()).getComponent(thesis);
            if (component == null) {
                return;
            }
            partsToRote.put(component, Float.valueOf(((ItemTornJournalPage)thesis.m_41720_()).isThesis(thesis) ? (float)component.requiredXPForRote() : (float)component.requiredXPForRote() * 0.25f));
        } else if (thesis.m_41720_() instanceof ICanContainSpell) {
            ISpellDefinition spell = ((ICanContainSpell)thesis.m_41720_()).getSpell(thesis);
            if (!spell.isChargedSpell(thesis) || spell.isMysterious()) {
                return;
            }
            partsToRote.put(spell.getShape().getPart(), Float.valueOf((float)spell.getShape().getPart().requiredXPForRote() * 0.05f));
            spell.iterateComponents(c -> partsToRote.put((ISpellComponent)c.getPart(), Float.valueOf((float)((SpellEffect)c.getPart()).requiredXPForRote() * 0.1f)));
            spell.getModifiers().forEach(m -> partsToRote.put((ISpellComponent)m, Float.valueOf((float)m.requiredXPForRote() * 0.1f)));
        } else {
            return;
        }
        thesis.m_41774_(1);
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Gui.CHARCOAL_SCRIBBLE, SoundSource.BLOCKS, 1.0f, (float)(0.95 + Math.random() * (double)0.1f));
        }
        crafter.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(p -> {
            ArrayList<ISpellComponent> alreadyRote = new ArrayList<ISpellComponent>();
            for (Map.Entry entry : partsToRote.entrySet()) {
                if (p.isRote((ISpellComponent)entry.getKey())) {
                    alreadyRote.add((ISpellComponent)entry.getKey());
                    continue;
                }
                p.addRoteXP(crafter, (ISpellComponent)entry.getKey(), ((Float)entry.getValue()).floatValue());
                float progression = p.getRoteProgression((ISpellComponent)entry.getKey());
                partsToRote.put((ISpellComponent)entry.getKey(), Float.valueOf(progression));
                if (!(crafter instanceof ServerPlayer)) continue;
                CustomAdvancementTriggers.STUDY_DESK_ROTE.trigger((ServerPlayer)crafter, ((ISpellComponent)entry.getKey()).getRegistryName(), progression);
            }
            for (ISpellComponent iSpellComponent : alreadyRote) {
                partsToRote.remove(iSpellComponent);
            }
        });
        partsToRote.forEach((c, p) -> {
            if (p.floatValue() < 1.0f) {
                ChatFormatting color = ChatFormatting.WHITE;
                IFaction faction = c.getFactionRequirement();
                if (faction != null) {
                    color = faction.getTornJournalPageFactionColor();
                }
                crafter.m_213846_((Component)Component.m_237115_((String)"item.mna.torn_journal_page.learned.prefix").m_130940_(ChatFormatting.ITALIC).m_7220_((Component)Component.m_237115_((String)c.getRegistryName().toString()).m_130940_(color)).m_7220_((Component)Component.m_237115_((String)"item.mna.torn_journal_page.learned.suffix").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.WHITE)));
            } else {
                SpellCaster.sendRoteMessage(crafter, c);
            }
        });
    }

    @Override
    protected boolean needsPower() {
        return false;
    }

    @Override
    public int getXPCost(Player crafter) {
        ItemStack thesis = this.m_8020_(0);
        if (!thesis.m_41619_()) {
            if (thesis.m_41720_() instanceof ItemTornJournalPage) {
                return ((ItemTornJournalPage)thesis.m_41720_()).isThesis(thesis) ? 100 : 20;
            }
            if (thesis.m_41720_() instanceof ICanContainSpell) {
                ISpellDefinition spell = ((ICanContainSpell)thesis.m_41720_()).getSpell(thesis);
                if (!spell.isChargedSpell(thesis) || spell.isMysterious()) {
                    return super.getXPCost(crafter);
                }
                return 20;
            }
        }
        return super.getXPCost(crafter);
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isActive();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        switch (index) {
            case 0: {
                if (existing.m_41720_() instanceof ItemTornJournalPage) {
                    return existing.m_41619_() || existing.m_41613_() < existing.m_41741_();
                }
                if (!(existing.m_41720_() instanceof ICanContainSpell)) break;
                ISpellDefinition spell = ((ICanContainSpell)existing.m_41720_()).getSpell(existing);
                return spell.isChargedSpell(existing) && !spell.isMysterious();
            }
        }
        return false;
    }

    public CantStartReason getCantStartReason(Player player) {
        if (!player.m_7500_() && player.f_36079_ < this.getXPCost(player)) {
            return CantStartReason.NOT_ENOUGH_XP;
        }
        LazyOptional rote = player.getCapability(PlayerRoteSpellsProvider.ROTE);
        LazyOptional progression = player.getCapability(PlayerProgressionProvider.PROGRESSION);
        if (!rote.isPresent() || !progression.isPresent()) {
            return CantStartReason.MISSING_CAPABILITY;
        }
        ItemStack thesis = this.m_8020_(0);
        ArrayList<ISpellComponent> components = new ArrayList<ISpellComponent>();
        if (thesis.m_41720_() instanceof ItemTornJournalPage) {
            ISpellComponent component = ((ItemTornJournalPage)thesis.m_41720_()).getComponent(thesis);
            if (component == null) {
                return CantStartReason.EMPTY_SPELL;
            }
            components.add(component);
        } else if (thesis.m_41720_() instanceof ICanContainSpell) {
            ISpellDefinition spell = ((ICanContainSpell)thesis.m_41720_()).getSpell(thesis);
            if (!spell.isChargedSpell(thesis)) {
                return CantStartReason.NON_CHARGED_SPELL;
            }
            if (spell.isMysterious()) {
                return CantStartReason.MYSTERIOUS_SPELL;
            }
            components.add(spell.getShape().getPart());
            spell.iterateComponents(c -> components.add((ISpellComponent)c.getPart()));
            spell.getModifiers().forEach(m -> components.add((ISpellComponent)m));
        }
        if (components.size() == 0) {
            return CantStartReason.EMPTY_SPELL;
        }
        if (components.stream().anyMatch(c -> ((IPlayerProgression)progression.resolve().get()).getTier() < c.getTier(player.m_9236_()))) {
            return CantStartReason.TIER_TOO_LOW;
        }
        if (components.stream().allMatch(c -> ((IPlayerRoteSpells)rote.resolve().get()).isRote((ISpellComponent)c))) {
            return CantStartReason.ALREADY_FULLY_ROTE;
        }
        return CantStartReason.NONE;
    }

    public static enum CantStartReason {
        NONE(""),
        MISSING_CAPABILITY("gui.mna.study_desk.capability_missing"),
        MYSTERIOUS_SPELL("gui.mna.study_desk.mysterious_spell"),
        NON_CHARGED_SPELL("gui.mna.study_desk.non_charged"),
        ALREADY_FULLY_ROTE("gui.mna.study_desk.already_rote"),
        TIER_TOO_LOW("gui.mna.study_desk.low_tier"),
        NOT_ENOUGH_XP("gui.mna.study_desk.not_enough_xp"),
        EMPTY_SPELL("gui.mna.study_desk.empty_spell");

        private Component tooltip;

        private CantStartReason(String componentTranslationString) {
            this.tooltip = Component.m_237115_((String)componentTranslationString);
        }

        public Component tooltip() {
            return this.tooltip;
        }
    }
}

