/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.sorcery.TransitoryTileBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TransitoryTile
extends BlockEntity {
    private float topFaceAlpha = 0.0f;
    private boolean wasSteppedOn = false;
    private byte neighborMatrix = 0;
    private int age = 0;
    private int color = -1;

    public TransitoryTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TransitoryTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.TRANSITORY_TILE.get(), pos, state);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, TransitoryTile tile) {
        ++tile.age;
        if (tile.m_58904_().m_5776_()) {
            tile.topFaceAlpha = tile.m_58904_().m_45976_(Entity.class, new AABB(tile.f_58858_.m_7494_())).size() > 0 ? 1.0f : (tile.topFaceAlpha -= 0.05f);
            if (!tile.wasSteppedOn && tile.topFaceAlpha > 0.0f) {
                tile.particleBurst();
            }
            tile.wasSteppedOn = tile.topFaceAlpha > 0.0f;
            for (Direction d : Direction.values()) {
                if (tile.hasNeighborOnSide(d)) continue;
                tile.SpawnParticlesForFace(pos, d);
            }
        } else if (tile.age > (Integer)tile.m_58900_().m_61143_((Property)TransitoryTileBlock.DURATION) * 20) {
            tile.m_58904_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void SpawnParticlesForFace(BlockPos pos, Direction face) {
        if (ManaAndArtifice.instance.proxy.isGamePaused()) {
            return;
        }
        Vec3 offset = null;
        RandomSource rand = this.f_58857_.f_46441_;
        switch (face) {
            case DOWN: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                        offset = new Vec3(rand.m_188499_() ? 1.0 : 0.0, 0.0, rand.m_188500_());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.EAST)) {
                        offset = new Vec3(1.0, 0.0, rand.m_188500_());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.WEST)) break;
                    offset = new Vec3(0.0, 0.0, rand.m_188500_());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vec3(rand.m_188500_(), 0.0, rand.m_188499_() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vec3(rand.m_188500_(), 0.0, 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vec3(rand.m_188500_(), 0.0, 1.0);
                break;
            }
            case EAST: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vec3(1.0, rand.m_188499_() ? 1.0 : 0.0, rand.m_188500_());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vec3(1.0, 1.0, rand.m_188500_());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vec3(1.0, 0.0, rand.m_188500_());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vec3(1.0, rand.m_188500_(), rand.m_188499_() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vec3(1.0, rand.m_188500_(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vec3(1.0, rand.m_188500_(), 1.0);
                break;
            }
            case WEST: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vec3(0.0, rand.m_188499_() ? 1.0 : 0.0, rand.m_188500_());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vec3(0.0, 1.0, rand.m_188500_());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vec3(0.0, 0.0, rand.m_188500_());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vec3(0.0, rand.m_188500_(), rand.m_188499_() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vec3(0.0, rand.m_188500_(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vec3(0.0, rand.m_188500_(), 1.0);
                break;
            }
            case NORTH: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vec3(rand.m_188500_(), rand.m_188499_() ? 1.0 : 0.0, 0.0);
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vec3(rand.m_188500_(), 1.0, 0.0);
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vec3(rand.m_188500_(), 0.0, 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                    offset = new Vec3(rand.m_188499_() ? 1.0 : 0.0, rand.m_188500_(), 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST)) {
                    offset = new Vec3(1.0, rand.m_188500_(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.WEST)) break;
                offset = new Vec3(0.0, rand.m_188500_(), 0.0);
                break;
            }
            case SOUTH: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vec3(rand.m_188500_(), rand.m_188499_() ? 1.0 : 0.0, 1.0);
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vec3(rand.m_188500_(), 1.0, 1.0);
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vec3(rand.m_188500_(), 0.0, 1.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                    offset = new Vec3(rand.m_188499_() ? 1.0 : 0.0, rand.m_188500_(), 1.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST)) {
                    offset = new Vec3(1.0, rand.m_188500_(), 1.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.WEST)) break;
                offset = new Vec3(0.0, rand.m_188500_(), 1.0);
                break;
            }
            case UP: {
                if (rand.m_188499_()) {
                    if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                        offset = new Vec3(rand.m_188499_() ? 1.0 : 0.0, 1.0, rand.m_188500_());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.EAST)) {
                        offset = new Vec3(1.0, 1.0, rand.m_188500_());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.WEST)) break;
                    offset = new Vec3(0.0, 1.0, rand.m_188500_());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vec3(rand.m_188500_(), 1.0, rand.m_188499_() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vec3(rand.m_188500_(), 1.0, 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vec3(rand.m_188500_(), 1.0, 1.0);
            }
        }
        if (offset != null) {
            MAParticleType pfx = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
            if (this.color != -1) {
                pfx.setColor(FastColor.ARGB32.m_13665_((int)this.color), FastColor.ARGB32.m_13667_((int)this.color), FastColor.ARGB32.m_13669_((int)this.color));
            }
            this.m_58904_().m_7106_((ParticleOptions)pfx, (double)pos.m_123341_() + offset.f_82479_, (double)pos.m_123342_() + offset.f_82480_, (double)pos.m_123343_() + offset.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void setNeighborOnSide(Direction side) {
        if (side != null) {
            this.neighborMatrix = (byte)(this.neighborMatrix | 1 << side.ordinal());
            if (!this.m_58904_().m_5776_()) {
                this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void clearNeighborOnSide(Direction side) {
        if (side != null) {
            this.neighborMatrix = (byte)(this.neighborMatrix & ~(1 << side.ordinal()));
            if (!this.m_58904_().m_5776_()) {
                this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean hasNeighborOnSide(Direction side) {
        if (side == null) {
            return false;
        }
        byte value = (byte)(1 << side.ordinal());
        return (this.neighborMatrix & value) != 0;
    }

    public float topFaceAlpha() {
        return this.topFaceAlpha;
    }

    public void m_183515_(CompoundTag data) {
        data.m_128344_("neighbors", this.neighborMatrix);
        data.m_128405_("color", this.color);
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        if (data.m_128441_("neighbors")) {
            this.neighborMatrix = data.m_128445_("neighbors");
        }
        if (data.m_128441_("color")) {
            this.color = data.m_128451_("color");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        if (data.m_128441_("neighbors")) {
            this.neighborMatrix = data.m_128445_("neighbors");
        }
        if (data.m_128441_("color")) {
            this.color = data.m_128451_("color");
        }
    }

    private void particleBurst() {
        float velocityMod = 0.2f;
        for (int i = 0; i < 5; ++i) {
            MAParticleType pfx = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get()));
            if (this.color != -1) {
                pfx.setColor(FastColor.ARGB32.m_13665_((int)this.color), FastColor.ARGB32.m_13667_((int)this.color), FastColor.ARGB32.m_13669_((int)this.color));
            }
            this.m_58904_().m_7106_((ParticleOptions)pfx, (double)this.f_58858_.m_123341_() + Math.random(), (double)this.f_58858_.m_123342_() + Math.random(), (double)this.f_58858_.m_123343_() + Math.random(), (Math.random() - 0.5) * (double)velocityMod, Math.random() * (double)velocityMod, (Math.random() - 0.5) * (double)velocityMod);
        }
    }

    public void setColor(int color) {
        this.color = color;
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

