/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.events.RunicAnvilShouldActivateEvent;
import com.mna.blocks.runeforging.RunicAnvilBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.enchantments.auras.Aura;
import com.mna.events.EventDispatcher;
import com.mna.items.ItemInit;
import com.mna.items.armor.BrokenMageArmor;
import com.mna.items.ritual.ItemPractitionersPatch;
import com.mna.items.ritual.ItemPractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.runes.ItemRune;
import com.mna.items.runes.ItemRunePattern;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.recipes.runeforging.RuneforgingRecipe;
import com.mna.tools.ContainerTools;
import com.mna.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RunicAnvilTile
extends TileEntityWithInventory
implements IForgeBlockEntity,
WorldlyContainer,
GeoBlockEntity {
    private static final int MAX_ITEMS = 2;
    public static final int PATTERN_SLOT_INDEX = 0;
    public static final int MATERIAL_SLOT_INDEX = 1;
    public static final int TOOL_SLOT_INDEX = 2;
    public static final int ADVANCE_RESPONSE_ADVANCED = 0;
    public static final int ADVANCE_RESPONSE_NO_MATCH = 1;
    public static final int ADVANCE_RESPONSE_LOW_TIER = 2;
    public static final int ADVANCE_RESPONSE_CLIENT_WORLD = 3;
    public static final int ADVANCE_RESPONSE_CRAFTING_COMPLETE = 4;
    public static final int ADVANCE_RESPONSE_EVENT_CANCELED = 5;
    public int craftProgress = 0;
    public int maxCraftProgress = 10;
    private ItemStack __cachedRecipeOutput = ItemStack.f_41583_;
    private RuneforgingRecipe __cachedRecipe;
    private Optional<ManaweavingRecipe> __cachedEnchantRecipe;
    private boolean autoCacheRecipe = true;
    private boolean settingCraftOutput = false;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RunicAnvilTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 2);
        this.__cachedRecipeOutput = ItemStack.f_41583_;
    }

    public RunicAnvilTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.RUNIC_ANVIL.get(), pos, state);
    }

    public int advanceCrafting(Player crafter, int playerTier) {
        return this.advanceCrafting(crafter, playerTier, true);
    }

    public int advanceCrafting(Player crafter, int playerTier, boolean allowDurability) {
        int cacheResponse = this.cacheRecipe(crafter, playerTier);
        if (this.m_58904_().m_5776_()) {
            return 3;
        }
        if (this.__cachedRecipeOutput.m_41619_()) {
            return cacheResponse;
        }
        ++this.craftProgress;
        int targetProgress = this.getMaxCraftProgress();
        if (this.craftProgress >= targetProgress) {
            this.craftProgress = 0;
            if (this.__cachedRecipe != null ? !EventDispatcher.DispatchRuneforgeCraft(this.__cachedRecipe, this.__cachedRecipeOutput, crafter) : (this.__cachedEnchantRecipe != null || EnchantmentHelper.m_44831_((ItemStack)this.__cachedRecipeOutput).size() > 0) && !EventDispatcher.DispatchRuneforgeEnchant(this.__cachedRecipeOutput, crafter)) {
                return 5;
            }
            this.completeCraftingAndReset(crafter, allowDurability);
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            return 4;
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        return 0;
    }

    private void completeCraftingAndReset(Player crafter, boolean allowPatternDurability) {
        this.settingCraftOutput = true;
        if (this.__cachedRecipe != null) {
            ArrayList<ItemStack> byproducts = this.__cachedRecipe.rollByproducts(this.f_58857_.m_213780_());
            for (ItemStack byproduct : byproducts) {
                InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()), this.f_58857_, true);
            }
        }
        ItemStack patternStack = this.m_8020_(0);
        if (allowPatternDurability && patternStack.m_41720_() instanceof ItemRunePattern) {
            if (!ItemRunePattern.incrementDamage(patternStack)) {
                this.m_6836_(1, this.__cachedRecipeOutput);
            } else {
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12160_, SoundSource.BLOCKS, 1.0f, (float)(0.8 + Math.random() * 0.4));
                this.m_6836_(0, this.__cachedRecipeOutput);
                this.m_6836_(1, ItemStack.f_41583_);
            }
        } else {
            this.m_6836_(0, this.__cachedRecipeOutput);
            this.m_6836_(1, ItemStack.f_41583_);
        }
        this.settingCraftOutput = false;
        if (crafter != null & crafter instanceof ServerPlayer) {
            CustomAdvancementTriggers.RUNIC_ANVIL_CRAFT.trigger((ServerPlayer)crafter, this.m_8020_(0));
        }
        this.__cachedRecipeOutput = ItemStack.f_41583_;
        this.__cachedRecipe = null;
        this.__cachedEnchantRecipe = null;
    }

    public int getMaxCraftProgress() {
        return this.__cachedRecipe != null ? this.__cachedRecipe.getHits() : this.maxCraftProgress;
    }

    private int cacheRecipe(Player player, int playerTier) {
        int output = 1;
        if (this.cacheSpecialRecipes(playerTier)) {
            boolean isActive = (Boolean)this.m_58900_().m_61143_((Property)RunicAnvilBlock.ACTIVE);
            if (!isActive) {
                this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            CraftingContainer inv = this.createDummyCraftingInventory();
            this.__cachedRecipe = this.m_58904_().m_7465_().m_44015_((RecipeType)RecipeInit.RUNEFORGING_TYPE.get(), (Container)inv, this.f_58857_).orElse(null);
            this.__cachedRecipeOutput = ItemStack.f_41583_;
            if (this.__cachedRecipe == null) {
                ItemStack rune = this.m_8020_(1);
                if (!rune.m_41619_()) {
                    output = this.cacheEnchantRecipe(rune, player, playerTier);
                }
            } else if (this.__cachedRecipe.getTier() <= playerTier) {
                this.__cachedRecipeOutput = this.__cachedRecipe.getResultItem();
                output = 0;
            } else {
                this.__cachedRecipe = null;
                this.__cachedRecipeOutput = ItemStack.f_41583_;
                output = 2;
            }
            boolean isActive = (Boolean)this.m_58900_().m_61143_((Property)RunicAnvilBlock.ACTIVE);
            if (!this.__cachedRecipeOutput.m_41619_()) {
                if (!isActive) {
                    this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (isActive) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 0);
            }
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return output;
    }

    private int cacheEnchantRecipe(ItemStack rune, Player player, int playerTier) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)rune);
        if (enchantments.size() == 0) {
            this.__cachedEnchantRecipe = null;
            this.__cachedRecipeOutput = ItemStack.f_41583_;
            return 1;
        }
        this.__cachedEnchantRecipe = this.m_58904_().m_7465_().m_44051_().stream().filter(r -> r.m_6671_() == RecipeInit.MANAWEAVING_RECIPE_TYPE.get() && ((ManaweavingRecipe)r).matches(enchantments)).map(r -> (ManaweavingRecipe)r).findFirst();
        int highestEnchantmentLevel = 0;
        for (Integer entry : enchantments.values()) {
            if (entry <= highestEnchantmentLevel) continue;
            highestEnchantmentLevel = entry;
        }
        int freeformTier = 5;
        if (highestEnchantmentLevel <= 2) {
            freeformTier = 3;
        } else if (highestEnchantmentLevel <= 4) {
            freeformTier = 4;
        }
        if (rune.m_41720_() == ItemInit.RUNE_PROJECTION.get() && GeneralConfigValues.ProjectionCanEnchantAnything) {
            this.__cachedEnchantRecipe = Optional.empty();
            freeformTier = 1;
        }
        if (this.__cachedEnchantRecipe.isPresent() && this.__cachedEnchantRecipe.get().getTier() > playerTier || !this.__cachedEnchantRecipe.isPresent() && playerTier < freeformTier) {
            this.__cachedEnchantRecipe = null;
            this.__cachedRecipeOutput = ItemStack.f_41583_;
            return 2;
        }
        this.__cachedRecipeOutput = this.m_8020_(0).m_41777_();
        boolean compatible = true;
        for (Map.Entry e2 : enchantments.entrySet()) {
            Aura aura;
            Object object;
            if (player != null && (object = e2.getKey()) instanceof Aura && !(aura = (Aura)((Object)object)).canEnchant(this.__cachedRecipeOutput, player)) {
                compatible = false;
                break;
            }
            if (((Enchantment)e2.getKey()).m_6081_(this.__cachedRecipeOutput)) continue;
            compatible = false;
            break;
        }
        Map existingEnchants = EnchantmentHelper.m_44831_((ItemStack)this.__cachedRecipeOutput);
        block2: for (Map.Entry ee : existingEnchants.entrySet()) {
            for (Map.Entry entry : enchantments.entrySet()) {
                Aura aura;
                Object k;
                if (entry.getKey() == ee.getKey() && (Integer)entry.getValue() > (Integer)ee.getValue()) continue;
                if (player != null && (k = entry.getKey()) instanceof Aura && !(aura = (Aura)((Object)k)).canEnchant(this.__cachedRecipeOutput, player)) {
                    compatible = false;
                    continue block2;
                }
                if (!((Enchantment)entry.getKey()).m_6081_(this.__cachedRecipeOutput)) {
                    compatible = false;
                    continue block2;
                }
                if (entry.getKey() == ee.getKey() && (Integer)entry.getValue() <= (Integer)ee.getValue()) {
                    compatible = false;
                    continue block2;
                }
                if (player != null && (k = entry.getKey()) instanceof Aura && !(aura = (Aura)((Object)k)).isCompatibleWith((Enchantment)ee.getKey(), player)) {
                    compatible = false;
                    continue block2;
                }
                if (((Enchantment)entry.getKey()).m_44695_((Enchantment)ee.getKey())) continue;
                compatible = false;
                continue block2;
            }
        }
        if (compatible) {
            existingEnchants.forEach((e, i) -> {
                if (!enchantments.containsKey(e) || (Integer)enchantments.get(e) < i) {
                    enchantments.put(e, i);
                }
            });
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)this.__cachedRecipeOutput);
            return 0;
        }
        this.__cachedRecipeOutput = ItemStack.f_41583_;
        return 1;
    }

    private boolean cacheSpecialRecipes(int playerTier) {
        RunicAnvilShouldActivateEvent event = new RunicAnvilShouldActivateEvent(this.m_8020_(0), this.m_8020_(1));
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        return this.cachePouch() || this.cachePattern() || this.cacheRepairs();
    }

    private boolean cacheRepairs() {
        ItemStack armorStack = this.m_8020_(0);
        if (!(armorStack.m_41720_() instanceof BrokenMageArmor) || !BrokenMageArmor.hasRestore(armorStack)) {
            return false;
        }
        ItemStack patchStack = this.m_8020_(1);
        return patchStack.m_41720_() == ItemInit.INFUSED_SILK.get();
    }

    private boolean cachePouch() {
        ItemStack pouchStack = this.m_8020_(0);
        if (!(pouchStack.m_41720_() instanceof ItemPractitionersPouch)) {
            return false;
        }
        ItemStack patchStack = this.m_8020_(1);
        if (!(patchStack.m_41720_() instanceof ItemPractitionersPatch)) {
            return false;
        }
        PractitionersPouchPatches patch = ((ItemPractitionersPatch)patchStack.m_41720_()).getPatch();
        int patchLevel = ((ItemPractitionersPatch)patchStack.m_41720_()).getLevel();
        if (((ItemPractitionersPouch)pouchStack.m_41720_()).getPatchLevel(pouchStack, patch) >= patchLevel) {
            return false;
        }
        return ((ItemPractitionersPouch)pouchStack.m_41720_()).countAppliedPatchesForLimit(pouchStack, patchStack) < 4;
    }

    private boolean cachePattern() {
        ItemStack runeStack = this.m_8020_(0);
        if (!(runeStack.m_41720_() instanceof ItemRune)) {
            return false;
        }
        ItemStack patchStack = this.m_8020_(1);
        return patchStack.m_41720_() == Items.f_42516_;
    }

    public ItemStack getOutputStack() {
        return this.__cachedRecipeOutput;
    }

    @Nullable
    public RuneforgingRecipe getCachedRecipe() {
        return this.__cachedRecipe;
    }

    private CraftingContainer createDummyCraftingInventory() {
        return ContainerTools.createTemporaryContainer(2, 1, (NonNullList<ItemStack>)NonNullList.m_122783_(null, (Object[])new ItemStack[]{this.m_8020_(0), this.m_8020_(1)}));
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("craft_progress", this.craftProgress);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.craftProgress = compound.m_128451_("craft_progress");
        super.m_142466_(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        CompoundTag sub_1 = new CompoundTag();
        this.m_8020_(0).m_41739_(sub_1);
        base.m_128365_("invSync_1", (Tag)sub_1);
        CompoundTag sub_2 = new CompoundTag();
        this.m_8020_(1).m_41739_(sub_2);
        base.m_128365_("invSync_2", (Tag)sub_2);
        base.m_128405_("craft_progress", this.craftProgress);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        CompoundTag sub = tag.m_128469_("invSync_1");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
        CompoundTag sub2 = tag.m_128469_("invSync_2");
        this.m_6836_(1, ItemStack.m_41712_((CompoundTag)sub2));
        this.craftProgress = tag.m_128451_("craft_progress");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        CompoundTag sub = data.m_128469_("invSync_1");
        this.m_6836_(0, ItemStack.m_41712_((CompoundTag)sub));
        CompoundTag sub2 = data.m_128469_("invSync_2");
        this.m_6836_(1, ItemStack.m_41712_((CompoundTag)sub2));
        this.craftProgress = data.m_128451_("craft_progress");
    }

    @Override
    public int m_6643_() {
        return 2;
    }

    public int m_6893_() {
        return this.settingCraftOutput ? 64 : 1;
    }

    public boolean pushItemStack(ItemStack stack, Player player, int playerTier) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            this.m_6836_(0, stack);
            return true;
        }
        if (this.m_8020_(1).m_41619_()) {
            this.setInventorySlotContentsNoCache(1, stack);
            this.cacheRecipe(player, playerTier);
            return true;
        }
        return false;
    }

    private void setInventorySlotContentsNoCache(int index, ItemStack stack) {
        this.autoCacheRecipe = false;
        this.m_6836_(index, stack);
        this.autoCacheRecipe = true;
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (this.autoCacheRecipe) {
            this.cacheRecipe(null, 5);
        }
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        return this.m_8016_(index);
    }

    @Override
    public ItemStack m_8016_(int index) {
        ItemStack output = super.m_8016_(index);
        if (!output.m_41619_() && this.autoCacheRecipe) {
            this.cacheRecipe(null, 5);
        }
        return output;
    }

    public ItemStack popItemStack() {
        if (this.craftProgress > 0) {
            return ItemStack.f_41583_;
        }
        this.__cachedRecipeOutput = ItemStack.f_41583_;
        if (!this.m_8020_(1).m_41619_()) {
            return this.m_8016_(1);
        }
        if (!this.m_8020_(0).m_41619_()) {
            return this.m_8016_(0);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack[] getDisplayedItems() {
        return new ItemStack[]{this.m_8020_(0), this.m_8020_(1)};
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        if (itemStackIn.m_41613_() != 1) {
            return false;
        }
        if (index == 1) {
            return !this.m_8020_(0).m_41619_() && this.m_8020_(1).m_41619_();
        }
        if (index == 0) {
            return this.m_8020_(1).m_41619_() && this.m_8020_(0).m_41619_();
        }
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.m_41728_((ItemStack)this.m_8020_(index), (ItemStack)stack)) {
            return false;
        }
        if (index == 0) {
            return this.m_8020_(1).m_41619_() && !this.m_8020_(0).m_41619_();
        }
        if (index == 1) {
            return !this.m_8020_(1).m_41619_();
        }
        return false;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (((Boolean)this.m_58900_().m_61143_((Property)RunicAnvilBlock.ACTIVE)).booleanValue()) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("animation.anvil_armature.in").thenLoop("animation.anvil_armature.idle"));
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.anvil_armature.out").thenLoop("animation.anvil_armature.hidden"));
        })});
    }
}

