/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.ritual;

import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.blocks.FacingBlock;
import com.mna.entities.sorcery.AffinityIcon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChimeriteCrystalBlock
extends FacingBlock
implements ISpellInteractibleBlock<ChimeriteCrystalBlock>,
ITranslucentBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public ChimeriteCrystalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(2.0f));
    }

    @Override
    public boolean onHitBySpell(Level world, BlockPos pos, ISpellDefinition spell) {
        for (IModifiedSpellPart<SpellEffect> c : spell.getComponents()) {
            if (c.getPart() != Components.BREAK) continue;
            return false;
        }
        if (!world.f_46443_) {
            Vec3 entityPos = this.getPositionBasedOnState(world, pos);
            BlockPos search = BlockPos.m_274446_((Position)entityPos);
            world.m_45976_(AffinityIcon.class, new AABB(search)).stream().forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
            AffinityIcon efi = new AffinityIcon(world);
            efi.setAffinity(spell.getHighestAffinity());
            efi.m_6034_(entityPos.f_82479_, entityPos.f_82480_, entityPos.f_82481_);
            world.m_7967_((Entity)efi);
        }
        return true;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        this.removeEntities(worldIn, pos);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        this.removeEntities(world, pos);
    }

    private void removeEntities(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            Vec3 entityPos = this.getPositionBasedOnState(world, pos);
            BlockPos search = BlockPos.m_274446_((Position)entityPos);
            world.m_45976_(AffinityIcon.class, new AABB(search)).stream().forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
        }
    }

    private Vec3 getPositionBasedOnState(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Vec3 basePos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (state.m_61138_((Property)SURFACE_TYPE) && state.m_61138_((Property)FACING)) {
            int surfType = (Integer)state.m_61143_((Property)SURFACE_TYPE);
            if (surfType == 1) {
                return basePos.m_82520_(0.0, 1.0, 0.0);
            }
            if (surfType == 2) {
                return basePos.m_82520_(0.0, -1.0, 0.0);
            }
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            return basePos.m_82520_((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
        }
        return basePos;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 15;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }
}

