/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class WardingCandleBlock
extends WaterloggableBlock
implements ISpellInteractibleBlock<WardingCandleBlock> {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public WardingCandleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60955_().m_60978_(1.0f), false);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (!worldIn.f_46443_) {
            BlockState newstate = state;
            newstate = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ACTIVE) == false));
            if (((Boolean)newstate.m_61143_((Property)ACTIVE)).booleanValue()) {
                if (player.m_21120_(handIn).m_41720_() != Items.f_42409_) {
                    return InteractionResult.FAIL;
                }
                worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.addWardingCandleLocation(pos));
                worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
                worldIn.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.m_7731_(pos, newstate, 1);
            worldIn.m_7260_(pos, state, newstate, 2);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)ACTIVE)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                worldIn.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setScale(0.02f).setMaxAge((int)(20.0 + Math.random() * 20.0)).setColor(30, 172, 255), (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_() + 0.93 + Math.random() * 0.05, (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.005, 0.0);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? 15 : 5;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!(pLevel.f_46443_ || pNewState.m_60713_((Block)BlockInit.WARDING_CANDLE.get()) && ((Boolean)pNewState.m_61143_((Property)ACTIVE)).booleanValue())) {
            pLevel.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pPos));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        if (!worldIn.f_46443_) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.f_46443_) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Override
    public boolean onHitBySpell(Level world, BlockPos pos, ISpellDefinition spell) {
        BlockState existing;
        if (!world.f_46443_ && spell.getAffinity().containsKey((Object)Affinity.FIRE) && (existing = world.m_8055_(pos)).m_61138_((Property)ACTIVE) && !((Boolean)existing.m_61143_((Property)ACTIVE)).booleanValue()) {
            BlockState newState = (BlockState)existing.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.addWardingCandleLocation(pos));
            world.m_7731_(pos, newState, 1);
            world.m_7260_(pos, existing, newState, 2);
            return true;
        }
        return false;
    }

    public static boolean shouldEntityBeBlocked(EntityType<?> entityType) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        String regName = key.toString();
        String modName = key.m_135827_() + ":*";
        if (GeneralConfigValues.WardingCandleBlacklist.contains("*.*")) {
            return true;
        }
        if (GeneralConfigValues.WardingCandleBlacklist.contains(regName) || GeneralConfigValues.WardingCandleBlacklist.contains(modName)) {
            return true;
        }
        if (GeneralConfigValues.WardingCandleWhitelist.contains(regName) || GeneralConfigValues.WardingCandleWhitelist.contains(modName)) {
            return false;
        }
        return false;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }
}

