/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.blocks.artifice.SeerStoneBlock;
import com.mna.blocks.tileentities.ElementalSentryTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElementalSentryBlock
extends WaterloggableBlock
implements ICutoutBlock,
EntityBlock {
    public static final BooleanProperty SHOOTING = BooleanProperty.m_61465_((String)"shooting");
    public static final BooleanProperty TARGET_OVERRIDE = BooleanProperty.m_61465_((String)"targeting_overridden");
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final Direction[] offsets = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private final Affinity shootAffinity;

    public ElementalSentryBlock(Affinity shootAffinity) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(6.0f, 30.0f).m_60910_(), false);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SHOOTING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TARGET_OVERRIDE, (Comparable)Boolean.valueOf(false)));
        this.shootAffinity = shootAffinity;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof ElementalSentryTile && placer instanceof Player) {
            ElementalSentryTile teas = (ElementalSentryTile)te;
            teas.setOwner((Player)placer);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        for (Direction dir : offsets) {
            BlockState offsetState = context.m_43725_().m_8055_(context.m_8083_().m_121955_(dir.m_122436_()));
            if (!(offsetState.m_60734_() instanceof SeerStoneBlock)) continue;
            state = (BlockState)state.m_61124_((Property)TARGET_OVERRIDE, (Comparable)Boolean.valueOf(true));
            break;
        }
        return state;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHOOTING});
        builder.m_61104_(new Property[]{TARGET_OVERRIDE});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean broken) {
        if (world.f_46443_) {
            return;
        }
        boolean found = false;
        for (Direction dir : offsets) {
            BlockState offsetState = world.m_8055_(pos.m_121955_(dir.m_122436_()));
            if (!(offsetState.m_60734_() instanceof SeerStoneBlock)) continue;
            found = true;
            break;
        }
        if (!found && ((Boolean)state.m_61143_((Property)TARGET_OVERRIDE)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TARGET_OVERRIDE, (Comparable)Boolean.valueOf(false)), 3);
        } else if (found && !((Boolean)state.m_61143_((Property)TARGET_OVERRIDE)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TARGET_OVERRIDE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof ElementalSentryTile && ((ElementalSentryTile)te).hasTarget()) {
            return 15;
        }
        return 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElementalSentryTile(pos, state, this.shootAffinity);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.ELEMENTAL_SENTRY.get() ? (world1, pos, state1, te) -> ElementalSentryTile.Tick(world1, pos, state1, (ElementalSentryTile)te) : null;
    }
}

